/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq.io;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.biojava.bio.seq.io.ParseException;
import org.biojava.bio.seq.io.SeqIOListener;
import org.biojava.bio.seq.io.StreamParser;
import org.biojava.bio.seq.io.SymbolParser;
import org.biojava.bio.symbol.IllegalSymbolException;

class GenbankContext {
    private static final int HEADER = 1;
    private static final int FEATURES = 2;
    private static final int SEQUENCE = 3;
    private static final int VERSION_LENGTH = 11;
    private static final int TAG_LENGTH = 12;
    private int status = 1;
    private SymbolParser symParser;
    private StreamParser streamParser;
    private List symbols;
    private String accession;
    private String headerTag = "";
    private StringBuffer headerTagText = new StringBuffer();
    private SeqIOListener listener;

    protected GenbankContext(SymbolParser symbolParser, SeqIOListener seqIOListener) {
        this.symbols = new ArrayList();
        this.listener = seqIOListener;
        this.symParser = symbolParser;
        this.streamParser = this.symParser.parseStream(this.listener);
    }

    private boolean hasHeaderTag(String string) {
        boolean bl = false;
        char[] cArray = string.toCharArray();
        int n = 0;
        while (n < 12) {
            if (cArray[n] != ' ') {
                bl = true;
                break;
            }
            ++n;
        }
        return bl;
    }

    private void processFeatureLine(String string) throws ParseException {
        if (string.startsWith("     ")) {
            this.saveSeqAnno();
            this.headerTag = "FT";
            this.headerTagText = new StringBuffer(string.substring(5));
        } else {
            this.processHeaderLine(string);
        }
    }

    private void processHeaderLine(String string) throws ParseException {
        if (string.startsWith("LOCUS")) {
            this.saveSeqAnno();
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            this.headerTag = stringTokenizer.nextToken();
            this.headerTagText = new StringBuffer(stringTokenizer.nextToken());
            this.saveSeqAnno();
            this.headerTag = "SIZE";
            this.headerTagText = new StringBuffer(stringTokenizer.nextToken());
            stringTokenizer.nextToken();
            if (string.charAt(34) != ' ') {
                this.saveSeqAnno();
                this.headerTag = "STRANDS";
                this.headerTagText = new StringBuffer(stringTokenizer.nextToken());
            }
            if (string.charAt(37) != ' ') {
                this.saveSeqAnno();
                this.headerTag = "TYPE";
                this.headerTagText = new StringBuffer(stringTokenizer.nextToken());
            }
            if (string.charAt(43) != ' ') {
                this.saveSeqAnno();
                this.headerTag = "CIRCULAR";
                this.headerTagText = new StringBuffer(stringTokenizer.nextToken());
            }
            this.saveSeqAnno();
            this.headerTag = "DIVISION";
            this.headerTagText = new StringBuffer(stringTokenizer.nextToken());
            this.saveSeqAnno();
            this.headerTag = "MDAT";
            this.headerTagText = new StringBuffer(stringTokenizer.nextToken());
        } else if (string.startsWith("VERSION")) {
            this.saveSeqAnno();
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            this.headerTag = stringTokenizer.nextToken();
            this.headerTagText = new StringBuffer(stringTokenizer.nextToken());
            String string2 = stringTokenizer.nextToken();
            if (string2.startsWith("GI")) {
                this.saveSeqAnno();
                this.headerTag = "GI";
                this.headerTagText = new StringBuffer(string2.substring(3));
            }
        } else if (this.hasHeaderTag(string)) {
            this.saveSeqAnno();
            this.headerTag = string.substring(0, 12).trim();
            this.headerTagText = new StringBuffer(string.substring(12));
        } else {
            this.headerTagText.append(" " + string.substring(12));
        }
    }

    protected void processLine(String string) throws ParseException, IllegalSymbolException {
        if (string.startsWith("FEATURES")) {
            this.status = 2;
            this.saveSeqAnno();
        } else if (string.startsWith("ORIGIN")) {
            this.status = 3;
            this.saveSeqAnno();
        } else if (this.status == 2) {
            this.processFeatureLine(string);
        } else if (this.status == 3) {
            this.processSeqLine(string, this.streamParser);
        } else if (this.status == 1) {
            this.processHeaderLine(string);
        }
    }

    /*
     * Unable to fully structure code
     */
    private void processSeqLine(String var1_1, StreamParser var2_2) throws IllegalSymbolException {
        var3_3 = var1_1.toCharArray();
        var4_4 = 0;
        var5_5 = 0;
        ** GOTO lbl15
        {
            ++var4_4;
            do {
                if (var4_4 < var3_3.length && (var3_3[var4_4] == ' ' || Character.isDigit(var3_3[var4_4]))) continue block0;
                if (var4_4 >= var3_3.length) break block0;
                var5_5 = var4_4 + 1;
                while (var5_5 < var3_3.length && var3_3[var5_5] != ' ') {
                    ++var5_5;
                }
                var2_2.characters(var3_3, var4_4, var5_5 - var4_4);
                var4_4 = var5_5;
lbl15:
                // 2 sources

            } while (var4_4 < var3_3.length);
        }
    }

    private void saveSeqAnno() throws ParseException {
        if (!this.headerTag.equals("")) {
            this.listener.addSequenceProperty(this.headerTag, this.headerTagText.toString());
            this.headerTag = "";
            this.headerTagText = new StringBuffer("");
        }
    }
}

