/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq;

import org.biojava.bio.BioException;
import org.biojava.bio.seq.FeatureRealizer;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.seq.ViewSequence;
import org.biojava.bio.seq.io.SymbolParser;
import org.biojava.bio.symbol.Alphabet;
import org.biojava.bio.symbol.Symbol;
import org.biojava.bio.symbol.SymbolList;

public class CircularView
extends ViewSequence {
    public CircularView(Sequence sequence) {
        super(sequence);
    }

    public CircularView(Sequence sequence, FeatureRealizer featureRealizer) {
        super(sequence, featureRealizer);
    }

    public SymbolList subList(int n, int n2) {
        if (n == 0 || n2 == 0) {
            throw new IllegalArgumentException("Must use a non 0 integer");
        }
        n = (n - 1) % super.length() + 1;
        n2 = (n2 - 1) % super.length() + 1;
        if (n < 0) {
            n = super.length() + 1 + n;
        }
        if (n2 < 0) {
            n2 = super.length() + 1 + n2;
        }
        if (n <= n2) {
            return super.subList(n, n2);
        }
        String string = super.subStr(n, super.length());
        String string2 = super.subStr(1, n2);
        String string3 = String.valueOf(string) + string2;
        try {
            Alphabet alphabet = super.getAlphabet();
            SymbolParser symbolParser = alphabet.getParser("token");
            SymbolList symbolList = symbolParser.parse(string3);
            return symbolList;
        }
        catch (BioException bioException) {
            System.err.println("A serious error has occured during the reconstruction of " + super.getName());
            return null;
        }
    }

    public String subStr(int n, int n2) {
        if (n == 0 || n2 == 0) {
            throw new IllegalArgumentException("Must use a non 0 integer");
        }
        n = (n - 1) % super.length() + 1;
        n2 = (n2 - 1) % super.length() + 1;
        if (n < 0) {
            n = super.length() + 1 + n;
        }
        if (n2 < 0) {
            n2 = super.length() + 1 + n2;
        }
        if (n <= n2) {
            return super.subStr(n, n2);
        }
        String string = super.subStr(n, super.length());
        String string2 = super.subStr(1, n2);
        return String.valueOf(string) + string2;
    }

    public Symbol symbolAt(int n) {
        if (n == 0) {
            throw new IllegalArgumentException("Must use a non 0 integer");
        }
        if ((n = (n - 1) % super.length() + 1) < 0) {
            n = super.length() + 1 + n;
        }
        return super.symbolAt(n);
    }
}

