/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.program.gff;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import org.biojava.bio.BioException;
import org.biojava.bio.program.gff.GFFDocumentHandler;
import org.biojava.bio.program.gff.GFFErrorHandler;
import org.biojava.bio.program.gff.GFFRecord;
import org.biojava.bio.program.gff.IgnoreRecordException;
import org.biojava.bio.program.gff.SimpleGFFRecord;
import org.biojava.bio.seq.StrandedFeature;
import org.biojava.utils.ParserException;

public class GFFParser {
    private GFFErrorHandler errors = GFFErrorHandler.ABORT_PARSING;

    protected GFFRecord createRecord(GFFDocumentHandler gFFDocumentHandler, List list, String string, String string2) throws BioException, ParserException, IgnoreRecordException {
        SimpleGFFRecord simpleGFFRecord = new SimpleGFFRecord();
        simpleGFFRecord.setSeqName((String)list.get(0));
        simpleGFFRecord.setSource((String)list.get(1));
        simpleGFFRecord.setFeature((String)list.get(2));
        int n = -1;
        try {
            n = Integer.parseInt((String)list.get(3));
        }
        catch (NumberFormatException numberFormatException) {
            n = this.errors.invalidStart((String)list.get(3));
        }
        simpleGFFRecord.setStart(n);
        int n2 = -1;
        try {
            n2 = Integer.parseInt((String)list.get(4));
        }
        catch (NumberFormatException numberFormatException) {
            n2 = this.errors.invalidEnd((String)list.get(3));
        }
        simpleGFFRecord.setEnd(n2);
        String string3 = (String)list.get(5);
        if (string3 == null || string3.equals("") || string3.equals(".") || string3.equals("0")) {
            simpleGFFRecord.setScore(Double.NEGATIVE_INFINITY);
        } else {
            double d = 0.0;
            try {
                d = Double.parseDouble(string3);
            }
            catch (NumberFormatException numberFormatException) {
                d = this.errors.invalidScore(string3);
            }
            simpleGFFRecord.setScore(d);
        }
        String string4 = (String)list.get(6);
        if (string4 == null || string4.equals("") || string4.equals(".")) {
            simpleGFFRecord.setStrand(StrandedFeature.UNKNOWN);
        } else if (string4.equals("+")) {
            simpleGFFRecord.setStrand(StrandedFeature.POSITIVE);
        } else if (string4.equals("-")) {
            simpleGFFRecord.setStrand(StrandedFeature.NEGATIVE);
        } else {
            simpleGFFRecord.setStrand(this.errors.invalidStrand(string4));
        }
        String string5 = (String)list.get(7);
        if (string5.equals(".")) {
            simpleGFFRecord.setFrame(-1);
        } else {
            int n3 = 0;
            try {
                n3 = Integer.parseInt(string5);
            }
            catch (NumberFormatException numberFormatException) {
                n3 = this.errors.invalidFrame(string5);
            }
            simpleGFFRecord.setFrame(n3);
        }
        if (string != null) {
            simpleGFFRecord.setGroupAttributes(this.parseAttribute(string));
        } else {
            simpleGFFRecord.setGroupAttributes(new HashMap());
        }
        simpleGFFRecord.setComment(string2);
        return simpleGFFRecord;
    }

    public GFFErrorHandler getErrorHandler() {
        return this.errors;
    }

    public void parse(BufferedReader bufferedReader, GFFDocumentHandler gFFDocumentHandler) throws IOException, BioException, ParserException {
        this.parse(bufferedReader, gFFDocumentHandler, "unknown:");
    }

    public void parse(BufferedReader bufferedReader, GFFDocumentHandler gFFDocumentHandler, String string) throws IOException, BioException, ParserException {
        gFFDocumentHandler.startDocument(string);
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 0;
        String string2 = bufferedReader.readLine();
        while (string2 != null) {
            block10: {
                ++n;
                try {
                    int n2;
                    String string3;
                    arrayList.clear();
                    if (string2.startsWith("#")) {
                        gFFDocumentHandler.commentLine(string2.substring(1));
                        break block10;
                    }
                    StringTokenizer stringTokenizer = new StringTokenizer(string2, "\t", false);
                    while (stringTokenizer.hasMoreTokens() && arrayList.size() < 8) {
                        string3 = stringTokenizer.nextToken();
                        arrayList.add(string3);
                    }
                    string3 = null;
                    String string4 = null;
                    if (stringTokenizer.hasMoreTokens()) {
                        try {
                            string3 = stringTokenizer.nextToken("\u0000");
                        }
                        catch (NoSuchElementException noSuchElementException) {}
                    }
                    if (string3 != null && (n2 = string3.indexOf("#")) != -1) {
                        string4 = string3.substring(n2);
                        string3 = string3.substring(0, n2);
                    }
                    GFFRecord gFFRecord = this.createRecord(gFFDocumentHandler, arrayList, string3, string4);
                    gFFDocumentHandler.recordLine(gFFRecord);
                }
                catch (ParserException parserException) {
                    throw new ParserException(parserException.getMessage(), string, n, string2);
                }
                catch (IgnoreRecordException ignoreRecordException) {}
            }
            string2 = bufferedReader.readLine();
        }
        gFFDocumentHandler.endDocument();
    }

    protected Map parseAttribute(String string) {
        HashMap hashMap = new HashMap();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";", false);
        while (stringTokenizer.hasMoreTokens()) {
            String string2;
            String string3 = stringTokenizer.nextToken().trim();
            ArrayList<String> arrayList = new ArrayList<String>();
            int n = string3.indexOf(" ");
            if (n == -1) {
                string2 = string3;
            } else {
                string2 = string3.substring(0, n);
                string = string3.substring(n).trim();
                while (string.length() > 0) {
                    if (string.startsWith("\"")) {
                        int n2 = 0;
                        do {
                            ++n2;
                        } while ((n2 = string.indexOf("\"", n2)) != -1 && string.charAt(n2 - 1) == '\\');
                        arrayList.add(string.substring(1, n2));
                        string = string.substring(n2 + 1).trim();
                        continue;
                    }
                    n = string.indexOf(" ");
                    if (n == -1) {
                        arrayList.add(string);
                        string = "";
                        continue;
                    }
                    arrayList.add(string.substring(0, n));
                    string = string.substring(n).trim();
                }
            }
            hashMap.put(string2, arrayList);
        }
        return hashMap;
    }

    public void setErrorHandler(GFFErrorHandler gFFErrorHandler) {
        this.errors = gFFErrorHandler;
    }
}

