/*
 * Decompiled with CFR 0.152.
 */
package jal.DOUBLE;

import jal.DOUBLE.BinaryPredicate;
import jal.DOUBLE.Modification;
import jal.DOUBLE.Range;

public final class Sorting {
    private static final int partitionCutoff = 13;
    private static final int qsort_stacksize = 56;
    private static final int stableSortCutoff = 9;

    public static void sort(double[] dArray, int n, int n2) {
        if (n2 - n >= 13) {
            Sorting.qsortLoop(dArray, n, n2);
        }
        Sorting.insertion_sort(dArray, n, n2);
    }

    public static void sort(double[] dArray, int n, int n2, BinaryPredicate binaryPredicate) {
        if (n2 - n >= 13) {
            Sorting.qsortLoop(dArray, n, n2, binaryPredicate);
        }
        Sorting.insertion_sort(dArray, n, n2, binaryPredicate);
    }

    public static void insertion_sort(double[] dArray, int n, int n2) {
        int n3 = n;
        while (++n3 < n2) {
            double d = dArray[n3];
            int n4 = n3;
            double d2 = dArray[n4 - 1];
            while (d < d2) {
                dArray[n4] = d2;
                if (n == n4 - 1) {
                    --n4;
                    break;
                }
                d2 = dArray[--n4 - 1];
            }
            dArray[n4] = d;
        }
    }

    public static void insertion_sort(double[] dArray, int n, int n2, BinaryPredicate binaryPredicate) {
        int n3 = n;
        while (++n3 < n2) {
            double d = dArray[n3];
            int n4 = n3;
            double d2 = dArray[n4 - 1];
            while (binaryPredicate.apply(d, d2)) {
                dArray[n4] = d2;
                if (n == n4 - 1) {
                    --n4;
                    break;
                }
                d2 = dArray[--n4 - 1];
            }
            dArray[n4] = d;
        }
    }

    private static int quickPartition(double[] dArray, int n, int n2) {
        double d = dArray[n];
        double d2 = dArray[n2 - 1];
        double d3 = dArray[n + (n2 - n) / 2];
        if (d3 < d) {
            if (d < d2) {
                d3 = d;
            } else if (d3 < d2) {
                d3 = d2;
            }
        } else if (d2 < d) {
            d3 = d;
        } else if (d2 < d3) {
            d3 = d2;
        }
        --n;
        while (true) {
            if (dArray[++n] < d3) {
                continue;
            }
            while (d3 < dArray[--n2]) {
            }
            if (n >= n2) {
                return n;
            }
            double d4 = dArray[n];
            dArray[n] = dArray[n2];
            dArray[n2] = d4;
        }
    }

    private static int quickPartition(double[] dArray, int n, int n2, BinaryPredicate binaryPredicate) {
        double d = dArray[n];
        double d2 = dArray[n2 - 1];
        double d3 = dArray[n + (n2 - n) / 2];
        if (binaryPredicate.apply(d3, d)) {
            if (binaryPredicate.apply(d, d2)) {
                d3 = d;
            } else if (binaryPredicate.apply(d3, d2)) {
                d3 = d2;
            }
        } else if (binaryPredicate.apply(d2, d)) {
            d3 = d;
        } else if (binaryPredicate.apply(d2, d3)) {
            d3 = d2;
        }
        --n;
        while (true) {
            if (binaryPredicate.apply(dArray[++n], d3)) {
                continue;
            }
            while (binaryPredicate.apply(d3, dArray[--n2])) {
            }
            if (n >= n2) {
                return n;
            }
            double d4 = dArray[n];
            dArray[n] = dArray[n2];
            dArray[n2] = d4;
        }
    }

    private static void qsortLoop(double[] dArray, int n, int n2) {
        int[] nArray = new int[56];
        int n3 = 0;
        while (true) {
            int n4;
            if (n2 - (n4 = Sorting.quickPartition(dArray, n, n2)) < 13) {
                if (n4 - n < 13) {
                    if (n3 == 0) {
                        return;
                    }
                    n2 = nArray[--n3];
                    n = nArray[--n3];
                    continue;
                }
                n2 = n4;
                continue;
            }
            if (n4 - n < 13) {
                n = n4;
                continue;
            }
            if (n2 - n4 > n4 - n) {
                nArray[n3++] = n4;
                nArray[n3++] = n2;
                n2 = n4;
                continue;
            }
            nArray[n3++] = n;
            nArray[n3++] = n4;
            n = n4;
        }
    }

    private static void qsortLoop(double[] dArray, int n, int n2, BinaryPredicate binaryPredicate) {
        int[] nArray = new int[56];
        int n3 = 0;
        while (true) {
            int n4;
            if (n2 - (n4 = Sorting.quickPartition(dArray, n, n2, binaryPredicate)) < 13) {
                if (n4 - n < 13) {
                    if (n3 == 0) {
                        return;
                    }
                    n2 = nArray[--n3];
                    n = nArray[--n3];
                    continue;
                }
                n2 = n4;
                continue;
            }
            if (n4 - n < 13) {
                n = n4;
                continue;
            }
            if (n2 - n4 > n4 - n) {
                nArray[n3++] = n4;
                nArray[n3++] = n2;
                n2 = n4;
                continue;
            }
            nArray[n3++] = n;
            nArray[n3++] = n4;
            n = n4;
        }
    }

    public static void stable_sort(double[] dArray, int n, int n2) {
        if (n2 - n < 9) {
            Sorting.insertion_sort(dArray, n, n2);
        } else {
            int n3 = n + (n2 - n) / 2;
            Sorting.stable_sort(dArray, n, n3);
            Sorting.stable_sort(dArray, n3, n2);
            Sorting.inplace_merge(dArray, n, n3, n2);
        }
    }

    public static void stable_sort(double[] dArray, int n, int n2, BinaryPredicate binaryPredicate) {
        if (n2 - n < 9) {
            Sorting.insertion_sort(dArray, n, n2, binaryPredicate);
        } else {
            int n3 = n + (n2 - n) / 2;
            Sorting.stable_sort(dArray, n, n3, binaryPredicate);
            Sorting.stable_sort(dArray, n3, n2, binaryPredicate);
            Sorting.inplace_merge(dArray, n, n3, n2, binaryPredicate);
        }
    }

    public static void partial_sort(double[] dArray, int n, int n2, int n3) {
        Sorting.make_heap(dArray, n, n2);
        int n4 = n2;
        while (n4 < n3) {
            if (dArray[n4] < dArray[n]) {
                double d = dArray[n4];
                dArray[n4] = dArray[n];
                dArray[n] = d;
                Sorting.adjust_heap(dArray, n, n, n2);
            }
            ++n4;
        }
        Sorting.sort_heap(dArray, n, n2);
    }

    public static void partial_sort(double[] dArray, int n, int n2, int n3, BinaryPredicate binaryPredicate) {
        Sorting.make_heap(dArray, n, n2, binaryPredicate);
        int n4 = n2;
        while (n4 < n3) {
            if (binaryPredicate.apply(dArray[n4], dArray[n])) {
                double d = dArray[n4];
                dArray[n4] = dArray[n];
                dArray[n] = d;
                Sorting.adjust_heap(dArray, n, n, n2, binaryPredicate);
            }
            ++n4;
        }
        Sorting.sort_heap(dArray, n, n2, binaryPredicate);
    }

    public static int partial_sort_copy(double[] dArray, double[] dArray2, int n, int n2, int n3, int n4) {
        if (n3 == n4) {
            return n4;
        }
        int n5 = Math.min(n2 - n, n4 - n3);
        Modification.copy(dArray, dArray2, n, n + n5, n3);
        n4 = n3 + n5;
        Sorting.make_heap(dArray2, n3, n4);
        n += n5;
        while (n < n2) {
            if (dArray[n] < dArray2[n3]) {
                dArray2[n3] = dArray[n];
                Sorting.adjust_heap(dArray2, n3, n3, n4);
            }
            ++n;
        }
        Sorting.sort_heap(dArray2, n3, n4);
        return n4;
    }

    public static int partial_sort_copy(double[] dArray, double[] dArray2, int n, int n2, int n3, int n4, BinaryPredicate binaryPredicate) {
        if (n3 == n4) {
            return n4;
        }
        int n5 = Math.min(n2 - n, n4 - n3);
        Modification.copy(dArray, dArray2, n, n + n5, n3);
        n4 = n3 + n5;
        Sorting.make_heap(dArray2, n3, n4, binaryPredicate);
        n += n5;
        while (n < n2) {
            if (binaryPredicate.apply(dArray[n], dArray2[n3])) {
                dArray2[n3] = dArray[n];
                Sorting.adjust_heap(dArray2, n3, n3, n4, binaryPredicate);
            }
            ++n;
        }
        Sorting.sort_heap(dArray2, n3, n4, binaryPredicate);
        return n4;
    }

    public static void nth_element(double[] dArray, int n, int n2, int n3) {
        while (n3 - n > 3) {
            int n4 = Sorting.quickPartition(dArray, n, n3);
            if (n4 <= n2) {
                n = n4;
                continue;
            }
            n3 = n4;
        }
        Sorting.insertion_sort(dArray, n, n3);
    }

    public static void nth_element(double[] dArray, int n, int n2, int n3, BinaryPredicate binaryPredicate) {
        while (n3 - n > 3) {
            int n4 = Sorting.quickPartition(dArray, n, n3, binaryPredicate);
            if (n4 <= n2) {
                n = n4;
                continue;
            }
            n3 = n4;
        }
        Sorting.insertion_sort(dArray, n, n3, binaryPredicate);
    }

    public static int lower_bound(double[] dArray, int n, int n2, double d) {
        int n3 = n2 - n;
        while (n3 > 0) {
            int n4 = n3 / 2;
            int n5 = n + n4;
            if (dArray[n5] < d) {
                n = n5 + 1;
                n3 -= n4 + 1;
                continue;
            }
            n3 = n4;
        }
        return n;
    }

    public static int lower_bound(double[] dArray, int n, int n2, double d, BinaryPredicate binaryPredicate) {
        int n3 = n2 - n;
        while (n3 > 0) {
            int n4 = n3 / 2;
            int n5 = n + n4;
            if (binaryPredicate.apply(dArray[n5], d)) {
                n = n5 + 1;
                n3 -= n4 + 1;
                continue;
            }
            n3 = n4;
        }
        return n;
    }

    public static int upper_bound(double[] dArray, int n, int n2, double d) {
        int n3 = n2 - n;
        while (n3 > 0) {
            int n4 = n3 / 2;
            int n5 = n + n4;
            if (d < dArray[n5]) {
                n3 = n4;
                continue;
            }
            n = n5 + 1;
            n3 -= n4 + 1;
        }
        return n;
    }

    public static int upper_bound(double[] dArray, int n, int n2, double d, BinaryPredicate binaryPredicate) {
        int n3 = n2 - n;
        while (n3 > 0) {
            int n4 = n3 / 2;
            int n5 = n + n4;
            if (binaryPredicate.apply(d, dArray[n5])) {
                n3 = n4;
                continue;
            }
            n = n5 + 1;
            n3 -= n4 + 1;
        }
        return n;
    }

    public static Range equal_range(double[] dArray, int n, int n2, double d) {
        int n3 = n2 - n;
        while (n3 > 0) {
            int n4 = n3 / 2;
            int n5 = n + n4;
            if (dArray[n5] < d) {
                n = n5 + 1;
                n3 = n3 - n4 + 1;
                continue;
            }
            if (d < dArray[n5]) {
                n3 = n4;
                continue;
            }
            int n6 = Sorting.lower_bound(dArray, n, n5, d);
            int n7 = Sorting.upper_bound(dArray, n5 + 1, n + n3, d);
            return new Range(dArray, n6, n7);
        }
        return new Range(dArray, n, n);
    }

    public static Range equal_range(double[] dArray, int n, int n2, double d, BinaryPredicate binaryPredicate) {
        int n3 = n2 - n;
        while (n3 > 0) {
            int n4 = n3 / 2;
            int n5 = n + n4;
            if (binaryPredicate.apply(dArray[n5], d)) {
                n = n5 + 1;
                n3 = n3 - n4 + 1;
                continue;
            }
            if (binaryPredicate.apply(d, dArray[n5])) {
                n3 = n4;
                continue;
            }
            int n6 = Sorting.lower_bound(dArray, n, n5, d, binaryPredicate);
            int n7 = Sorting.upper_bound(dArray, n5 + 1, n + n3, d, binaryPredicate);
            return new Range(dArray, n6, n7);
        }
        return new Range(dArray, n, n);
    }

    public static boolean binary_search(double[] dArray, int n, int n2, double d) {
        int n3 = Sorting.lower_bound(dArray, n, n2, d);
        return n3 < n2 && !(d < dArray[n3]);
    }

    public static boolean binary_search(double[] dArray, int n, int n2, double d, BinaryPredicate binaryPredicate) {
        int n3 = Sorting.lower_bound(dArray, n, n2, d, binaryPredicate);
        return n3 < n2 && !binaryPredicate.apply(d, dArray[n3]);
    }

    public static int merge(double[] dArray, double[] dArray2, double[] dArray3, int n, int n2, int n3, int n4, int n5) {
        while (n < n2 && n3 < n4) {
            dArray3[n5++] = dArray2[n3] < dArray[n] ? dArray2[n3++] : dArray[n++];
        }
        Modification.copy(dArray, dArray3, n, n2, n5);
        Modification.copy(dArray2, dArray3, n3, n4, n5);
        return n5 + (n2 - n) + (n4 - n3);
    }

    public static int merge(double[] dArray, double[] dArray2, double[] dArray3, int n, int n2, int n3, int n4, int n5, BinaryPredicate binaryPredicate) {
        while (n < n2 && n3 < n4) {
            dArray3[n5++] = binaryPredicate.apply(dArray2[n3], dArray[n]) ? dArray2[n3++] : dArray[n++];
        }
        Modification.copy(dArray, dArray3, n, n2, n5);
        Modification.copy(dArray2, dArray3, n3, n4, n5);
        return n5 + (n2 - n) + (n4 - n3);
    }

    public static void inplace_merge(double[] dArray, int n, int n2, int n3) {
        int n4;
        int n5;
        if (n >= n2 || n2 >= n3) {
            return;
        }
        if (n3 - n == 2) {
            if (dArray[n2] < dArray[n]) {
                double d = dArray[n];
                dArray[n] = dArray[n2];
                dArray[n2] = d;
            }
            return;
        }
        if (n2 - n > n3 - n2) {
            n5 = n + (n2 - n) / 2;
            n4 = Sorting.lower_bound(dArray, n2, n3, dArray[n5]);
        } else {
            n4 = n2 + (n3 - n2) / 2;
            n5 = Sorting.upper_bound(dArray, n, n2, dArray[n4]);
        }
        Modification.rotate(dArray, n5, n2, n4);
        n2 = n5 + (n4 - n2);
        Sorting.inplace_merge(dArray, n, n5, n2);
        Sorting.inplace_merge(dArray, n2, n4, n3);
    }

    public static void inplace_merge(double[] dArray, int n, int n2, int n3, BinaryPredicate binaryPredicate) {
        int n4;
        int n5;
        if (n >= n2 || n2 >= n3) {
            return;
        }
        if (n3 - n == 2) {
            if (binaryPredicate.apply(dArray[n2], dArray[n])) {
                double d = dArray[n];
                dArray[n] = dArray[n2];
                dArray[n2] = d;
            }
            return;
        }
        if (n2 - n > n3 - n2) {
            n5 = n + (n2 - n) / 2;
            n4 = Sorting.lower_bound(dArray, n2, n3, dArray[n5], binaryPredicate);
        } else {
            n4 = n2 + (n3 - n2) / 2;
            n5 = Sorting.upper_bound(dArray, n, n2, dArray[n4], binaryPredicate);
        }
        Modification.rotate(dArray, n5, n2, n4);
        n2 = n5 + (n4 - n2);
        Sorting.inplace_merge(dArray, n, n5, n2, binaryPredicate);
        Sorting.inplace_merge(dArray, n2, n4, n3, binaryPredicate);
    }

    public static boolean includes(double[] dArray, double[] dArray2, int n, int n2, int n3, int n4) {
        while (n < n2 && n3 < n4) {
            if (dArray2[n3] < dArray[n]) {
                return false;
            }
            if (dArray[n] < dArray2[n3]) {
                ++n;
                continue;
            }
            ++n;
            ++n3;
        }
        return n3 == n4;
    }

    public static boolean includes(double[] dArray, double[] dArray2, int n, int n2, int n3, int n4, BinaryPredicate binaryPredicate) {
        while (n < n2 && n3 < n4) {
            if (binaryPredicate.apply(dArray2[n3], dArray[n])) {
                return false;
            }
            if (binaryPredicate.apply(dArray[n], dArray2[n3])) {
                ++n;
                continue;
            }
            ++n;
            ++n3;
        }
        return n3 == n4;
    }

    public static int set_union(double[] dArray, double[] dArray2, double[] dArray3, int n, int n2, int n3, int n4, int n5) {
        while (n < n2 && n3 < n4) {
            if (dArray[n] < dArray2[n3]) {
                dArray3[n5++] = dArray[n++];
                continue;
            }
            if (dArray2[n3] < dArray[n]) {
                dArray3[n5++] = dArray2[n3++];
                continue;
            }
            dArray3[n5++] = dArray[n++];
            ++n3;
        }
        Modification.copy(dArray, dArray3, n, n2, n5);
        Modification.copy(dArray2, dArray3, n3, n4, n5);
        return n5 + (n2 - n) + (n4 - n3);
    }

    public static int set_union(double[] dArray, double[] dArray2, double[] dArray3, int n, int n2, int n3, int n4, int n5, BinaryPredicate binaryPredicate) {
        while (n < n2 && n3 < n4) {
            if (binaryPredicate.apply(dArray[n], dArray2[n3])) {
                dArray3[n5++] = dArray[n++];
                continue;
            }
            if (binaryPredicate.apply(dArray2[n3], dArray[n])) {
                dArray3[n5++] = dArray2[n3++];
                continue;
            }
            dArray3[n5++] = dArray[n++];
            ++n3;
        }
        Modification.copy(dArray, dArray3, n, n2, n5);
        Modification.copy(dArray2, dArray3, n3, n4, n5);
        return n5 + (n2 - n) + (n4 - n3);
    }

    public static int set_intersection(double[] dArray, double[] dArray2, double[] dArray3, int n, int n2, int n3, int n4, int n5) {
        while (n < n2 && n3 < n4) {
            if (dArray[n] < dArray2[n3]) {
                ++n;
                continue;
            }
            if (dArray2[n3] < dArray[n]) {
                ++n3;
                continue;
            }
            dArray3[n5++] = dArray[n++];
            ++n3;
        }
        return n5;
    }

    public static int set_intersection(double[] dArray, double[] dArray2, double[] dArray3, int n, int n2, int n3, int n4, int n5, BinaryPredicate binaryPredicate) {
        while (n < n2 && n3 < n4) {
            if (binaryPredicate.apply(dArray[n], dArray2[n3])) {
                ++n;
                continue;
            }
            if (binaryPredicate.apply(dArray2[n3], dArray[n])) {
                ++n3;
                continue;
            }
            dArray3[n5++] = dArray[n++];
            ++n3;
        }
        return n5;
    }

    public static int set_difference(double[] dArray, double[] dArray2, double[] dArray3, int n, int n2, int n3, int n4, int n5) {
        while (n < n2 && n3 < n4) {
            if (dArray[n] < dArray2[n3]) {
                dArray3[n5++] = dArray[n++];
                continue;
            }
            if (dArray2[n3] < dArray[n]) {
                ++n3;
                continue;
            }
            ++n;
            ++n3;
        }
        Modification.copy(dArray, dArray3, n, n2, n5);
        return n5 + (n2 - n);
    }

    public static int set_difference(double[] dArray, double[] dArray2, double[] dArray3, int n, int n2, int n3, int n4, int n5, BinaryPredicate binaryPredicate) {
        while (n < n2 && n3 < n4) {
            if (binaryPredicate.apply(dArray[n], dArray2[n3])) {
                dArray3[n5++] = dArray[n++];
                continue;
            }
            if (binaryPredicate.apply(dArray2[n3], dArray[n])) {
                ++n3;
                continue;
            }
            ++n;
            ++n3;
        }
        Modification.copy(dArray, dArray3, n, n2, n5);
        return n5 + (n2 - n);
    }

    public static int set_symmetric_difference(double[] dArray, double[] dArray2, double[] dArray3, int n, int n2, int n3, int n4, int n5) {
        while (n < n2 && n3 < n4) {
            if (dArray[n] < dArray2[n3]) {
                dArray3[n5++] = dArray[n++];
                continue;
            }
            if (dArray2[n3] < dArray[n]) {
                dArray3[n5++] = dArray2[n3++];
                continue;
            }
            ++n;
            ++n3;
        }
        Modification.copy(dArray, dArray3, n, n2, n5);
        Modification.copy(dArray2, dArray3, n3, n4, n5);
        return n5 + (n2 - n) + (n4 - n3);
    }

    public static int set_symmetric_difference(double[] dArray, double[] dArray2, double[] dArray3, int n, int n2, int n3, int n4, int n5, BinaryPredicate binaryPredicate) {
        while (n < n2 && n3 < n4) {
            if (binaryPredicate.apply(dArray[n], dArray2[n3])) {
                dArray3[n5++] = dArray[n++];
                continue;
            }
            if (binaryPredicate.apply(dArray2[n3], dArray[n])) {
                dArray3[n5++] = dArray2[n3++];
                continue;
            }
            ++n;
            ++n3;
        }
        Modification.copy(dArray, dArray3, n, n2, n5);
        Modification.copy(dArray2, dArray3, n3, n4, n5);
        return n5 + (n2 - n) + (n4 - n3);
    }

    public static void push_heap(double[] dArray, int n, int n2) {
        if (n2 - n < 2) {
            return;
        }
        double d = dArray[--n2];
        int n3 = n + (n2 - n - 1) / 2;
        while (n2 > n && dArray[n3] < d) {
            dArray[n2] = dArray[n3];
            n2 = n3;
            n3 = n + (n2 - n - 1) / 2;
        }
        dArray[n2] = d;
    }

    public static void push_heap(double[] dArray, int n, int n2, BinaryPredicate binaryPredicate) {
        if (n2 - n < 2) {
            return;
        }
        double d = dArray[--n2];
        int n3 = n + (n2 - n - 1) / 2;
        while (n2 > n && binaryPredicate.apply(dArray[n3], d)) {
            dArray[n2] = dArray[n3];
            n2 = n3;
            n3 = n + (n2 - n - 1) / 2;
        }
        dArray[n2] = d;
    }

    private static void adjust_heap(double[] dArray, int n, int n2, int n3) {
        double d = dArray[n2];
        int n4 = n3 - n;
        int n5 = n2 - n;
        int n6 = 2 * n5 + 2;
        while (n6 < n4) {
            if (dArray[n + n6] < dArray[n + (n6 - 1)]) {
                --n6;
            }
            dArray[n + n5] = dArray[n + n6];
            n5 = n6++;
            n6 *= 2;
        }
        if (n6-- == n4) {
            dArray[n + n5] = dArray[n + n6];
            n5 = n6;
        }
        int n7 = (n5 - 1) / 2;
        int n8 = n2 - n;
        while (n5 != n8 && dArray[n + n7] < d) {
            dArray[n + n5] = dArray[n + n7];
            n5 = n7;
            n7 = (n5 - 1) / 2;
        }
        dArray[n + n5] = d;
    }

    private static void adjust_heap(double[] dArray, int n, int n2, int n3, BinaryPredicate binaryPredicate) {
        double d = dArray[n2];
        int n4 = n3 - n;
        int n5 = n2 - n;
        int n6 = 2 * n5 + 2;
        while (n6 < n4) {
            if (binaryPredicate.apply(dArray[n + n6], dArray[n + (n6 - 1)])) {
                --n6;
            }
            dArray[n + n5] = dArray[n + n6];
            n5 = n6++;
            n6 *= 2;
        }
        if (n6-- == n4) {
            dArray[n + n5] = dArray[n + n6];
            n5 = n6;
        }
        int n7 = (n5 - 1) / 2;
        int n8 = n2 - n;
        while (n5 != n8 && binaryPredicate.apply(dArray[n + n7], d)) {
            dArray[n + n5] = dArray[n + n7];
            n5 = n7;
            n7 = (n5 - 1) / 2;
        }
        dArray[n + n5] = d;
    }

    public static void pop_heap(double[] dArray, int n, int n2) {
        if (n2 - n < 2) {
            return;
        }
        double d = dArray[--n2];
        dArray[n2] = dArray[n];
        dArray[n] = d;
        Sorting.adjust_heap(dArray, n, n, n2);
    }

    public static void pop_heap(double[] dArray, int n, int n2, BinaryPredicate binaryPredicate) {
        if (n2 - n < 2) {
            return;
        }
        double d = dArray[--n2];
        dArray[n2] = dArray[n];
        dArray[n] = d;
        Sorting.adjust_heap(dArray, n, n, n2, binaryPredicate);
    }

    public static void make_heap(double[] dArray, int n, int n2) {
        if (n2 - n < 2) {
            return;
        }
        int n3 = (n2 - n - 2) / 2;
        do {
            Sorting.adjust_heap(dArray, n, n + n3, n2);
        } while (n3-- != 0);
    }

    public static void make_heap(double[] dArray, int n, int n2, BinaryPredicate binaryPredicate) {
        if (n2 - n < 2) {
            return;
        }
        int n3 = (n2 - n - 2) / 2;
        do {
            Sorting.adjust_heap(dArray, n, n + n3, n2, binaryPredicate);
        } while (n3-- != 0);
    }

    public static void sort_heap(double[] dArray, int n, int n2) {
        while (n2 - n > 1) {
            double d = dArray[--n2];
            dArray[n2] = dArray[n];
            dArray[n] = d;
            Sorting.adjust_heap(dArray, n, n, n2);
        }
    }

    public static void sort_heap(double[] dArray, int n, int n2, BinaryPredicate binaryPredicate) {
        while (n2 - n > 1) {
            double d = dArray[--n2];
            dArray[n2] = dArray[n];
            dArray[n] = d;
            Sorting.adjust_heap(dArray, n, n, n2, binaryPredicate);
        }
    }

    public static int max_element(double[] dArray, int n, int n2) {
        if (n >= n2) {
            return n2;
        }
        int n3 = n;
        while (++n < n2) {
            if (!(dArray[n3] < dArray[n])) continue;
            n3 = n;
        }
        return n3;
    }

    public static int max_element(double[] dArray, int n, int n2, BinaryPredicate binaryPredicate) {
        if (n >= n2) {
            return n2;
        }
        int n3 = n;
        while (++n < n2) {
            if (!binaryPredicate.apply(dArray[n3], dArray[n])) continue;
            n3 = n;
        }
        return n3;
    }

    public static int min_element(double[] dArray, int n, int n2) {
        if (n >= n2) {
            return n2;
        }
        int n3 = n;
        while (++n < n2) {
            if (!(dArray[n] < dArray[n3])) continue;
            n3 = n;
        }
        return n3;
    }

    public static int min_element(double[] dArray, int n, int n2, BinaryPredicate binaryPredicate) {
        if (n >= n2) {
            return n2;
        }
        int n3 = n;
        while (++n < n2) {
            if (!binaryPredicate.apply(dArray[n], dArray[n3])) continue;
            n3 = n;
        }
        return n3;
    }

    public static boolean lexicographical_compare(double[] dArray, double[] dArray2, int n, int n2, int n3, int n4) {
        while (n < n2 && n3 < n4) {
            if (dArray[n] < dArray2[n3]) {
                return true;
            }
            int n5 = n3++;
            int n6 = n++;
            if (!(dArray2[n5] < dArray[n6])) continue;
            return false;
        }
        return n == n2 && n3 != n4;
    }

    public static boolean lexicographical_compare(double[] dArray, double[] dArray2, int n, int n2, int n3, int n4, BinaryPredicate binaryPredicate) {
        while (n < n2 && n3 < n4) {
            if (binaryPredicate.apply(dArray[n], dArray2[n3])) {
                return true;
            }
            if (!binaryPredicate.apply(dArray2[n3++], dArray[n++])) continue;
            return false;
        }
        return n == n2 && n3 != n4;
    }

    public static boolean next_permutation(double[] dArray, int n, int n2) {
        if (n2 - n < 2) {
            return false;
        }
        int n3 = n2 - 1;
        do {
            int n4;
            if (!(dArray[--n3] < dArray[n4])) continue;
            int n5 = n2;
            while (!(dArray[n3] < dArray[--n5])) {
            }
            double d = dArray[n3];
            dArray[n3] = dArray[n5];
            dArray[n5] = d;
            Modification.reverse(dArray, n4, n2);
            return true;
        } while (n3 != n);
        Modification.reverse(dArray, n, n2);
        return false;
    }

    public static boolean next_permutation(double[] dArray, int n, int n2, BinaryPredicate binaryPredicate) {
        if (n2 - n < 2) {
            return false;
        }
        int n3 = n2 - 1;
        do {
            int n4;
            if (!binaryPredicate.apply(dArray[--n3], dArray[n4])) continue;
            int n5 = n2;
            while (!binaryPredicate.apply(dArray[n3], dArray[--n5])) {
            }
            double d = dArray[n3];
            dArray[n3] = dArray[n5];
            dArray[n5] = d;
            Modification.reverse(dArray, n4, n2);
            return true;
        } while (n3 != n);
        Modification.reverse(dArray, n, n2);
        return false;
    }

    public static boolean prev_permutation(double[] dArray, int n, int n2) {
        if (n2 - n < 2) {
            return false;
        }
        int n3 = n2 - 1;
        do {
            int n4;
            if (!(dArray[n4] < dArray[--n3])) continue;
            int n5 = n2;
            while (!(dArray[--n5] < dArray[n3])) {
            }
            double d = dArray[n3];
            dArray[n3] = dArray[n5];
            dArray[n5] = d;
            Modification.reverse(dArray, n4, n2);
            return true;
        } while (n3 != n);
        Modification.reverse(dArray, n, n2);
        return false;
    }

    public static boolean prev_permutation(double[] dArray, int n, int n2, BinaryPredicate binaryPredicate) {
        if (n2 - n < 2) {
            return false;
        }
        int n3 = n2 - 1;
        do {
            int n4;
            if (!binaryPredicate.apply(dArray[n4], dArray[--n3])) continue;
            int n5 = n2;
            while (!binaryPredicate.apply(dArray[--n5], dArray[n3])) {
            }
            double d = dArray[n3];
            dArray[n3] = dArray[n5];
            dArray[n5] = d;
            Modification.reverse(dArray, n4, n2);
            return true;
        } while (n3 != n);
        Modification.reverse(dArray, n, n2);
        return false;
    }

    private Sorting() {
    }
}

