/*
 * Decompiled with CFR 0.152.
 */
package eponine;

import eponine.XMLPrettyPrinter;
import eponine.datasource.DataSource;
import eponine.model.EponineXML;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import org.biojava.stats.svm.TrainingEvent;
import org.biojava.stats.svm.TrainingListener;
import org.biojava.utils.xml.AppEntry;
import stats.glm.BasisSource;
import stats.glm.GLMClassificationModel;
import stats.glm.GLMTrainer;
import stats.glm.ListBasisSource;
import stats.glm.SLMTrainingContext;

public class TrainingCore
implements AppEntry {
    private DataSource dataSource;
    private GLMTrainer trainer;
    private GLMTrainer retrainer;
    private BasisSource basisSource;
    private String fileName;
    private int learningCurveStep = 1;
    private int checkpointFrequency = 0;
    private PrintWriter learningCurveFile = null;

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public void setTrainer(GLMTrainer gLMTrainer) {
        this.trainer = gLMTrainer;
    }

    public void setRetrainer(GLMTrainer gLMTrainer) {
        this.retrainer = gLMTrainer;
    }

    public void setBasisSource(BasisSource basisSource) {
        this.basisSource = basisSource;
    }

    public void setFileName(String string) {
        this.fileName = string;
    }

    public void setLearningCurveStep(int n) {
        this.learningCurveStep = n;
    }

    public void setLearningCurveFile(String string) throws IOException {
        this.learningCurveFile = new PrintWriter(new FileWriter(string));
    }

    public void setCheckpointFrequency(int n) {
        this.checkpointFrequency = n;
    }

    private GLMClassificationModel doRetrain(GLMClassificationModel gLMClassificationModel) {
        if (this.retrainer == null) {
            return gLMClassificationModel;
        }
        return this.retrainer.trainClassification(this.dataSource.getTrainingExamples(), new ListBasisSource(new ArrayList(gLMClassificationModel.getBasisFunctions())), new TrainingListener(){

            public void trainingCycleComplete(TrainingEvent trainingEvent) {
            }

            public void trainingComplete(TrainingEvent trainingEvent) {
            }
        });
    }

    public void start(String[] stringArray) {
        TrainingListener trainingListener = new TrainingListener(){

            public void trainingCycleComplete(TrainingEvent trainingEvent) {
                System.out.print('.');
                SLMTrainingContext sLMTrainingContext = (SLMTrainingContext)trainingEvent.getContext();
                int n = sLMTrainingContext.getCurrentCycle();
                if (TrainingCore.this.learningCurveFile != null && n % TrainingCore.this.learningCurveStep == 0) {
                    TrainingCore.this.learningCurveFile.println("" + n + " " + sLMTrainingContext.getDeviation() + " " + sLMTrainingContext.getBasisList().size());
                }
                if (TrainingCore.this.checkpointFrequency != 0 && n != 0 && n % TrainingCore.this.checkpointFrequency == 0) {
                    System.out.print("Checkpointing...");
                    GLMClassificationModel gLMClassificationModel = TrainingCore.this.doRetrain(sLMTrainingContext.freezeModel());
                    try {
                        PrintWriter printWriter = new PrintWriter(new FileWriter(TrainingCore.this.fileName + "cp-" + n));
                        XMLPrettyPrinter xMLPrettyPrinter = new XMLPrettyPrinter(printWriter);
                        EponineXML eponineXML = new EponineXML();
                        xMLPrettyPrinter.startDocument();
                        eponineXML.modelToXML(gLMClassificationModel, xMLPrettyPrinter);
                        xMLPrettyPrinter.endDocument();
                        printWriter.close();
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    System.out.println("Done!");
                }
            }

            public void trainingComplete(TrainingEvent trainingEvent) {
                System.out.println("Done!");
            }
        };
        System.out.println("Starting training...");
        GLMClassificationModel gLMClassificationModel = this.trainer.trainClassification(this.dataSource.getTrainingExamples(), this.basisSource, trainingListener);
        System.out.print("Retraining...");
        gLMClassificationModel = this.doRetrain(gLMClassificationModel);
        System.out.println("Done!");
        try {
            PrintWriter printWriter = new PrintWriter(new FileWriter(this.fileName));
            XMLPrettyPrinter xMLPrettyPrinter = new XMLPrettyPrinter(printWriter);
            EponineXML eponineXML = new EponineXML();
            xMLPrettyPrinter.startDocument();
            eponineXML.modelToXML(gLMClassificationModel, xMLPrettyPrinter);
            xMLPrettyPrinter.endDocument();
            if (this.learningCurveFile != null) {
                this.learningCurveFile.close();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

