# prepare environment
source(snakemake@params$setup_code_fname)

devtools::load_all("../..")

# run model
fit <- pareg::pareg(
  study$df %>%
    select(gene, pvalue) %>%
    mutate(pvalue = -ifelse(
      pvalue > 0,
      log10(pvalue),
      log10(min(pvalue[pvalue > 0]))
    )),
  df_terms,
  family = pareg::gaussian
)

df <- fit %>%
  as.data.frame() %>%
  mutate(method = "pareg_gau", enrichment = abs(enrichment))

df %>%
  arrange(desc(abs(enrichment))) %>%
  head()

# misc
do.call(rbind, fit$obj$loss_hist) %>%
  as_tibble() %>%
  unnest(everything()) %>%
  mutate(iteration = seq_along(fit$obj$loss_hist)) %>%
  pivot_longer(-iteration) %>%
  ggplot(aes(x = iteration, y = value, color = name)) +
    geom_line() +
    # geom_point() +
    theme_minimal()
ggsave(
  file.path(dirname(snakemake@output$fname), "loss.pdf"),
  width = 8,
  height = 6
)

# save result
df %>%
  write_csv(snakemake@output$fname)
