## ----eval=FALSE---------------------------------------------------------------
#  if(!requireNamespace("BiocManager", quietly = TRUE))
#      install.packages("BiocManager")
#  BiocManager::install("netZooR")

## ----message=FALSE,warning=FALSE----------------------------------------------
library(netZooR)

## ----message=FALSE,warning=FALSE----------------------------------------------
r = c(1,1,1,2,2,2,3,3,3,4,4);
b = c(1,2,3,1,2,4,2,3,4,3,4);
reds <- c("Alice","Sue","Janine","Mary")
blues <- c("Bob","John","Ed","Hank")
elist <- data.frame(red=reds[r], blue=blues[b])

## ----message=FALSE,warning=FALSE----------------------------------------------
condor.object <- createCondorObject(elist)

## ----message=FALSE,warning=FALSE----------------------------------------------
names(condor.object)

## ----message=FALSE,warning=FALSE----------------------------------------------
condor.object <- condorCluster(condor.object)
print(condor.object$red.memb)
print(condor.object$blue.memb)

## ----message=FALSE,warning=FALSE----------------------------------------------
gtoy = graph.edgelist(as.matrix(elist),directed=FALSE)
set.graph.attribute(gtoy, "layout", layout.kamada.kawai(gtoy))
V(gtoy)[c(reds,blues)]$color <- c(rep("red",4),rep("blue",4))

## ----fig=TRUE,message=FALSE,warning=FALSE-------------------------------------
plot(gtoy,vertex.label.dist=2)

## ----message=FALSE,warning=FALSE----------------------------------------------
condor.object <- condorQscore(condor.object)

## ----fig=TRUE,message=FALSE,warning=FALSE-------------------------------------
q_women <- condor.object$qscores$red.qscore
core_stats <- condorCoreEnrich(test_nodes=c("Alice","Mary"),
                                 q=q_women,perm=TRUE,plot.hist=TRUE)

## ----message=FALSE,warning=FALSE----------------------------------------------
data(small1976)
condor.object <- createCondorObject(small1976)
condor.object <- condorCluster(condor.object, project=FALSE)

## ----fig=TRUE,message=FALSE,warning=FALSE-------------------------------------
condorPlotHeatmap(condor.object)

## -----------------------------------------------------------------------------
sessionInfo()

