/*
 * Decompiled with CFR 0.152.
 */
package ciat.agrobio.javautils;

import ciat.agrobio.core.CalculateDistancesCOSINE;
import ciat.agrobio.core.VariantManager;
import ciat.agrobio.core.VariantProcessor;
import ciat.agrobio.hcluster.HierarchicalCluster;
import ciat.agrobio.io.VCFManager;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

@Parameters(commandDescription="VCF2TREE")
public class UtilVCF2TREE {
    @Parameter(names={"--help"}, help=true)
    private boolean help;
    @Parameter(description="Input_File", required=true)
    private String inputFileName;
    @Parameter(names={"--numberOfThreads", "-t"})
    private int numOfThreads = 1;
    @Parameter(names={"--ignoremissing", "-m"})
    private boolean ignoremissing = false;
    @Parameter(names={"--onlyHets", "-h"})
    private boolean onlyHets = false;
    @Parameter(names={"--ignoreHets", "-g"})
    private boolean ignoreHets = false;

    public static String getUtilName() {
        return "VCF2TREE";
    }

    public void go() {
        try {
            int cpus = Runtime.getRuntime().availableProcessors();
            int usingThreads = cpus < this.numOfThreads ? cpus : this.numOfThreads;
            System.err.println("cpus=" + cpus);
            System.err.println("using=" + usingThreads);
            CountDownLatch startSignal = new CountDownLatch(1);
            CountDownLatch doneSignal = new CountDownLatch(usingThreads + 1);
            ExecutorService pool = Executors.newFixedThreadPool(usingThreads + 1);
            HashMap<Integer, VariantProcessor> variantProcessors = new HashMap<Integer, VariantProcessor>();
            VariantManager vm = new VariantManager();
            VCFManager vcfm = new VCFManager(vm, this.inputFileName, startSignal, doneSignal);
            pool.execute(vcfm);
            VariantProcessor.resetCounters();
            int i = 0;
            while (i < usingThreads) {
                VariantProcessor vp = new VariantProcessor(vm, vcfm, startSignal, doneSignal);
                variantProcessors.put(vp.getId(), vp);
                pool.execute(vp);
                ++i;
            }
            doneSignal.await();
            pool.shutdown();
            vm.populateSampleVariant();
            ArrayList<String> sampleNames = new ArrayList<String>();
            int i2 = 9;
            while (i2 < vcfm.getHeaderData().length) {
                sampleNames.add(new String(vcfm.getHeaderData()[i2]));
                ++i2;
            }
            System.err.printf("\rProcessed variants : \t%8d\n", VariantProcessor.getVariantCount().get());
            CalculateDistancesCOSINE.resetCounters();
            CalculateDistancesCOSINE fj = new CalculateDistancesCOSINE();
            double[][] distances = fj.calculateDistances(usingThreads, sampleNames, vm, vcfm, this.ignoreHets, this.onlyHets, this.ignoremissing);
            HierarchicalCluster hc = new HierarchicalCluster();
            String treeString = hc.hclusteringTree(sampleNames.toArray(new String[sampleNames.size()]), distances);
            System.out.println(treeString);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

