/*
 * Decompiled with CFR 0.152.
 */
package ciat.agrobio.javautils;

import ciat.agrobio.core.CalculateDistancesD2;
import ciat.agrobio.core.GeneralTools;
import ciat.agrobio.core.SequenceD2;
import ciat.agrobio.core.SequenceProcessor;
import ciat.agrobio.io.FastaManager;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

@Parameters(commandDescription="FASTA2DIST")
public class UtilFASTA2DIST {
    @Parameter(names={"--help"}, help=true)
    private boolean help;
    @Parameter(names={"--inputFile", "-i"}, description="Input_File", required=true)
    private List<String> inputFileNames;
    @Parameter(names={"--kmerSize", "-k"}, description="Kmer size", required=true)
    private Integer k;
    @Parameter(names={"--normalize", "-n"})
    private boolean normalize = false;
    @Parameter(names={"--numberOfThreads", "-t"})
    private int numOfThreads = 1;

    public static String getUtilName() {
        return "FASTA2DIST";
    }

    public void go() {
        try {
            int cpus = Runtime.getRuntime().availableProcessors();
            int usingThreads = cpus < this.numOfThreads ? cpus : this.numOfThreads;
            System.err.println("cpus=" + cpus);
            System.err.println("using=" + usingThreads);
            ConcurrentHashMap<Integer, SequenceD2> seqVectors = new ConcurrentHashMap<Integer, SequenceD2>();
            CountDownLatch startSignal = new CountDownLatch(1);
            CountDownLatch doneSignal = new CountDownLatch(usingThreads + 1);
            ExecutorService pool = Executors.newFixedThreadPool(usingThreads + 1);
            HashMap<Integer, SequenceProcessor> sequenceProcessors = new HashMap<Integer, SequenceProcessor>();
            FastaManager frm = new FastaManager(false, this.inputFileNames, startSignal, doneSignal);
            pool.execute(frm);
            SequenceProcessor.resetCounters();
            int i = 0;
            while (i < usingThreads) {
                SequenceProcessor sp = new SequenceProcessor(seqVectors, frm, this.k, this.normalize, startSignal, doneSignal);
                sequenceProcessors.put(sp.getId(), sp);
                pool.execute(sp);
                ++i;
            }
            doneSignal.await();
            pool.shutdown();
            List<String> seqNames = frm.getSequenceNames();
            List<Integer> seqIds = frm.getSequenceIds();
            CalculateDistancesD2 fj = new CalculateDistancesD2();
            double[][] distances = fj.calculateDistances(usingThreads, seqVectors, seqNames, seqIds, frm);
            int seqCounter = 0;
            System.out.println(seqNames.size());
            int i2 = 0;
            while (i2 < seqNames.size()) {
                String seqName1 = seqNames.get(i2);
                System.out.print(seqName1);
                int j = 0;
                while (j < seqNames.size()) {
                    String seqName2 = seqNames.get(j);
                    System.out.print("\t" + GeneralTools.decimalFormat.format(distances[i2][j]));
                    ++j;
                }
                System.out.println("");
                ++seqCounter;
                ++i2;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

