/*
 * Decompiled with CFR 0.152.
 */
package ciat.agrobio.io;

import ciat.agrobio.core.GeneralTools;
import ciat.agrobio.core.Variant;
import ciat.agrobio.core.VariantManager;
import ciat.agrobio.io.VCFDecoder;
import ciat.agrobio.io.VCFIterator;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class VCFManager
implements Runnable {
    private List<byte[]> commentData;
    private byte[][] headerData;
    private AtomicInteger currVariantId = new AtomicInteger(0);
    private VariantManager vm = null;
    private String inputFileName = null;
    private boolean done = false;
    private CountDownLatch startSignal = null;
    private CountDownLatch doneSignal = null;

    public VCFManager(VariantManager vm, String inputFileName, CountDownLatch startSignal, CountDownLatch doneSignal) {
        this.vm = vm;
        this.inputFileName = inputFileName;
        this.startSignal = startSignal;
        this.doneSignal = doneSignal;
        this.commentData = new ArrayList<byte[]>();
    }

    public final List<byte[]> getCommentData() {
        return this.commentData;
    }

    public final byte[][] getHeaderData() {
        return this.headerData;
    }

    public boolean isDone() {
        return this.done;
    }

    @Override
    public void run() {
        try {
            this.done = false;
            this.startSignal.countDown();
            System.err.println(String.valueOf(GeneralTools.time()) + " VCFManager: START READ");
            ArrayList<File> inputFiles = new ArrayList<File>();
            inputFiles.add(new File(this.inputFileName).getCanonicalFile());
            for (File f : inputFiles) {
                if (f.exists() && f.canRead()) continue;
                System.err.println("\tERROR : File " + f + "\n\tdoes not exist ot cannot be read. Exiting.");
                System.exit(1);
            }
            VCFDecoder decoder = new VCFDecoder();
            VCFIterator<byte[][]> iterator = VCFIterator.create(decoder, inputFiles);
            for (List<byte[][]> list : iterator) {
                int i = 0;
                while (i < list.size()) {
                    byte[][] line = list.get(i);
                    if (line[0][0] == 35 && line[0][1] == 35) {
                        this.commentData.add(line[0]);
                    } else if (line[0][0] == 35) {
                        this.headerData = line;
                        this.vm.setNumSamples(this.headerData.length - 9);
                    } else if (line.length >= 10) {
                        Variant variant = new Variant(this.currVariantId.incrementAndGet(), line);
                        if (this.vm.getPloidy() <= 0) {
                            String format = variant.getFormat();
                            int indexGT = Arrays.asList(format.split(":")).indexOf("GT");
                            String GT = new String(variant.getDataRaw()[9]).split(":")[indexGT];
                            if (GT.contains("/")) {
                                this.vm.setPloidy((byte)GT.split("/").length);
                            } else if (GT.contains("|")) {
                                this.vm.setPloidy((byte)GT.split("\\|").length);
                            } else {
                                System.err.println("Cannot understand GT field.");
                                System.exit(this.vm.getPloidy());
                            }
                        }
                        while (!this.vm.putVariantRaw(variant)) {
                            TimeUnit.MILLISECONDS.sleep(500L);
                        }
                        line = null;
                    }
                    ++i;
                }
                list.clear();
                Object var4_6 = null;
            }
            System.err.println(String.valueOf(GeneralTools.time()) + " VCFManager: END READ");
            this.vm.setNumVariants(this.currVariantId.get());
            this.done = true;
            this.doneSignal.countDown();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(0);
        }
    }
}

