/*
 * Decompiled with CFR 0.152.
 */
package ciat.agrobio.core;

import ciat.agrobio.core.Sequence;
import ciat.agrobio.core.SequenceD2;

public class SequenceEncoder {
    public static long encodeToLong(Sequence sequence, int start, int end, boolean reverse) {
        if (!reverse) {
            long num = 0L;
            int i = start;
            while (i < end) {
                num *= 4L;
                switch (sequence.charAt(i)) {
                    case 'A': 
                    case 'a': {
                        num += 0L;
                        break;
                    }
                    case 'T': 
                    case 't': {
                        ++num;
                        break;
                    }
                    case 'C': 
                    case 'c': {
                        num += 2L;
                        break;
                    }
                    case 'G': 
                    case 'g': {
                        num += 3L;
                        break;
                    }
                    default: {
                        num = -1L;
                    }
                }
                if (num == -1L) break;
                ++i;
            }
            return num;
        }
        long num = 0L;
        int i = end - 1;
        while (i >= start) {
            num *= 4L;
            switch (sequence.charAt(i)) {
                case 'A': 
                case 'a': {
                    ++num;
                    break;
                }
                case 'T': 
                case 't': {
                    num += 0L;
                    break;
                }
                case 'C': 
                case 'c': {
                    num += 3L;
                    break;
                }
                case 'G': 
                case 'g': {
                    num += 2L;
                    break;
                }
                default: {
                    num = -1L;
                }
            }
            if (num == -1L) break;
            --i;
        }
        return num;
    }

    public static long encodeToLong(SequenceD2 sequence, int start, int end, boolean reverse, boolean countNucl) {
        if (!reverse) {
            long num = 0L;
            int a = 0;
            int t = 0;
            int c = 0;
            int g = 0;
            int i = start;
            while (i < end) {
                num *= 4L;
                switch (sequence.charAt(i)) {
                    case 'A': 
                    case 'a': {
                        num += 0L;
                        if (!countNucl) break;
                        a = (short)(a + 1);
                        break;
                    }
                    case 'T': 
                    case 't': {
                        ++num;
                        if (!countNucl) break;
                        t = (short)(t + 1);
                        break;
                    }
                    case 'C': 
                    case 'c': {
                        num += 2L;
                        if (!countNucl) break;
                        c = (short)(c + 1);
                        break;
                    }
                    case 'G': 
                    case 'g': {
                        num += 3L;
                        if (!countNucl) break;
                        g = (short)(g + 1);
                        break;
                    }
                    default: {
                        num = -1L;
                    }
                }
                if (num == -1L) break;
                ++i;
            }
            if (countNucl && num != -1L) {
                sequence.as += a;
                sequence.ts += t;
                sequence.cs += c;
                sequence.gs += g;
            }
            return num;
        }
        long num = 0L;
        int a = 0;
        int t = 0;
        int c = 0;
        int g = 0;
        int i = end - 1;
        while (i >= start) {
            num *= 4L;
            switch (sequence.charAt(i)) {
                case 'A': 
                case 'a': {
                    ++num;
                    if (!countNucl) break;
                    t = (short)(t + 1);
                    break;
                }
                case 'T': 
                case 't': {
                    num += 0L;
                    if (!countNucl) break;
                    a = (short)(a + 1);
                    break;
                }
                case 'C': 
                case 'c': {
                    num += 3L;
                    if (!countNucl) break;
                    g = (short)(g + 1);
                    break;
                }
                case 'G': 
                case 'g': {
                    num += 2L;
                    if (!countNucl) break;
                    c = (short)(c + 1);
                    break;
                }
                default: {
                    num = -1L;
                }
            }
            if (num == -1L) break;
            --i;
        }
        if (countNucl && num != -1L) {
            sequence.as += a;
            sequence.ts += t;
            sequence.cs += c;
            sequence.gs += g;
        }
        return num;
    }

    public static String decodeFromLong(long encoded, int length) {
        StringBuilder sbf = new StringBuilder();
        StringBuilder sbr = new StringBuilder();
        int i = 0;
        while (i < length) {
            int mod = (int)(encoded % 4L);
            switch (mod) {
                case 0: {
                    sbf.append('A');
                    sbr.append('T');
                    encoded -= 0L;
                    break;
                }
                case 1: {
                    sbf.append('T');
                    sbr.append('A');
                    --encoded;
                    break;
                }
                case 2: {
                    sbf.append('C');
                    sbr.append('G');
                    encoded -= 2L;
                    break;
                }
                case 3: {
                    sbf.append('G');
                    sbr.append('C');
                    encoded -= 3L;
                    break;
                }
            }
            encoded /= 4L;
            ++i;
        }
        String f = sbf.reverse().toString();
        String r = sbr.toString();
        return String.valueOf(f) + "/" + r;
    }

    public static long encodeToLong(String kmerS, int k) {
        long num = 0L;
        int i = 0;
        while (i < k) {
            num *= 4L;
            switch (kmerS.charAt(i)) {
                case 'A': 
                case 'a': {
                    num += 0L;
                    break;
                }
                case 'T': 
                case 't': {
                    ++num;
                    break;
                }
                case 'C': 
                case 'c': {
                    num += 2L;
                    break;
                }
                case 'G': 
                case 'g': {
                    num += 3L;
                    break;
                }
                default: {
                    num = -1L;
                }
            }
            if (num == -1L) break;
            ++i;
        }
        return num;
    }
}

