/*
 * Decompiled with CFR 0.152.
 */
package ciat.agrobio.core;

import ciat.agrobio.core.CalculateD2ChildTask;
import ciat.agrobio.core.CalculateD2Task;
import ciat.agrobio.core.SequenceD2;
import ciat.agrobio.io.FastaManager;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ForkJoinPool;

public class CalculateDistancesD2 {
    public static void resetCounters() {
        CalculateD2ChildTask.resetCounters();
    }

    public double[][] calculateDistances(int numOfThreads, ConcurrentHashMap<Integer, SequenceD2> seqVectors, List<String> seqNames, List<Integer> seqIds, FastaManager frm) {
        try {
            int numOfSequences = seqNames.size();
            double[][] distances = new double[numOfSequences][numOfSequences];
            CalculateD2Task task = new CalculateD2Task(seqVectors, seqNames, seqIds, frm, distances);
            ForkJoinPool pool = new ForkJoinPool(numOfThreads);
            pool.execute(task);
            return (double[][])task.get();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

