/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.util;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class LongRange
implements Externalizable {
    private static final long serialVersionUID = 9196521188817114486L;
    long lb;
    long stride;
    long length;
    long ub;

    public LongRange() {
        this.lb = 0L;
        this.stride = 1L;
        this.length = 0L;
        this.setUb();
    }

    public LongRange(long l, long l2) {
        this.lb = l;
        this.stride = 1L;
        this.length = Math.max(l2 - l + 1L, 0L);
        this.setUb();
    }

    public LongRange(long l, long l2, long l3) {
        if (l3 < 1L) {
            throw new IllegalArgumentException("LongRange(): stride = " + l3 + " illegal");
        }
        this.lb = l;
        this.stride = l3;
        this.length = Math.max((l2 - l + l3) / l3, 0L);
        this.setUb();
    }

    public LongRange(LongRange longRange) {
        this.lb = longRange.lb;
        this.stride = longRange.stride;
        this.length = longRange.length;
        this.ub = longRange.ub;
    }

    public long lb() {
        return this.lb;
    }

    public long ub() {
        return this.ub;
    }

    public long stride() {
        return this.stride;
    }

    public long length() {
        return this.length;
    }

    public boolean contains(long l) {
        return this.lb <= l && l <= this.ub;
    }

    public boolean contains(LongRange longRange) {
        return this.lb <= longRange.lb && longRange.ub <= this.ub;
    }

    public LongRange subrange(int n, int n2) {
        if (n < 1) {
            throw new IllegalArgumentException("LongRange.subrange(): size = " + n + " illegal");
        }
        if (0 > n2 || n2 >= n) {
            throw new IllegalArgumentException("LongRange.subrange(): rank = " + n2 + " illegal");
        }
        LongRange longRange = new LongRange();
        long l = this.length / (long)n;
        int n3 = (int)(this.length % (long)n);
        longRange.lb = n2 < n3 ? this.lb + (long)n2 * ++l * this.stride : this.lb + ((long)n3 + (long)n2 * l) * this.stride;
        longRange.stride = this.stride;
        longRange.length = l;
        longRange.setUb();
        return longRange;
    }

    public LongRange[] subranges(int n) {
        LongRange longRange;
        int n2;
        if (n < 1) {
            throw new IllegalArgumentException("LongRange.subranges(): size = " + n + " illegal");
        }
        LongRange[] longRangeArray = new LongRange[n];
        long l = this.length / (long)n;
        int n3 = (int)(this.length % (long)n);
        long l2 = this.lb;
        ++l;
        for (n2 = 0; n2 < n3; ++n2) {
            longRange = new LongRange();
            longRange.lb = l2;
            l2 += l * this.stride;
            longRange.stride = this.stride;
            longRange.length = l;
            longRange.setUb();
            longRangeArray[n2] = longRange;
        }
        --l;
        for (n2 = n3; n2 < n; ++n2) {
            longRange = new LongRange();
            longRange.lb = l2;
            l2 += l * this.stride;
            longRange.stride = this.stride;
            longRange.length = l;
            longRange.setUb();
            longRangeArray[n2] = longRange;
        }
        return longRangeArray;
    }

    public LongRange chunk(long l, long l2) {
        if (l < 0L) {
            throw new IllegalArgumentException("LongRange.chunk(): N1 = " + l + " illegal");
        }
        if (l2 < 0L) {
            throw new IllegalArgumentException("LongRange.chunk(): N2 = " + l2 + " illegal");
        }
        LongRange longRange = new LongRange();
        longRange.lb = this.lb + l * this.stride;
        longRange.stride = this.stride;
        longRange.length = Math.min(l2, Math.max(0L, this.length - l));
        longRange.setUb();
        return longRange;
    }

    public boolean equals(Object object) {
        return object instanceof LongRange && this.lb == ((LongRange)object).lb && this.stride == ((LongRange)object).stride && this.length == ((LongRange)object).length;
    }

    public int hashCode() {
        return (int)(((this.lb << 10) + this.stride << 10) + this.length);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.lb);
        stringBuilder.append("..");
        stringBuilder.append(this.ub);
        if (this.stride > 1L) {
            stringBuilder.append(';');
            stringBuilder.append(this.stride);
        }
        return stringBuilder.toString();
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeLong(this.lb);
        objectOutput.writeLong(this.stride);
        objectOutput.writeLong(this.length);
    }

    public void readExternal(ObjectInput objectInput) throws IOException {
        this.lb = objectInput.readLong();
        this.stride = objectInput.readLong();
        this.length = objectInput.readLong();
        this.setUb();
    }

    private void setUb() {
        this.ub = this.lb + (this.length - 1L) * this.stride;
    }
}

