/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.pj.reduction;

import edu.rit.pj.reduction.ShortOp;
import java.util.concurrent.atomic.AtomicInteger;

public class SharedShort
extends Number {
    private AtomicInteger myValue;

    public SharedShort() {
        this.myValue = new AtomicInteger();
    }

    public SharedShort(short s) {
        this.myValue = new AtomicInteger(s);
    }

    public short get() {
        return (short)this.myValue.get();
    }

    public void set(short s) {
        this.myValue.set(s);
    }

    public short getAndSet(short s) {
        return (short)this.myValue.getAndSet(s);
    }

    public boolean compareAndSet(short s, short s2) {
        return this.myValue.compareAndSet(s, s2);
    }

    public boolean weakCompareAndSet(short s, short s2) {
        return this.myValue.weakCompareAndSet(s, s2);
    }

    public short getAndIncrement() {
        short s;
        short s2;
        while (!this.myValue.compareAndSet(s2 = (short)this.myValue.get(), s = (short)(s2 + 1))) {
        }
        return s2;
    }

    public short getAndDecrement() {
        short s;
        short s2;
        while (!this.myValue.compareAndSet(s2 = (short)this.myValue.get(), s = (short)(s2 - 1))) {
        }
        return s2;
    }

    public short getAndAdd(short s) {
        short s2;
        short s3;
        while (!this.myValue.compareAndSet(s3 = (short)this.myValue.get(), s2 = (short)(s3 + s))) {
        }
        return s3;
    }

    public short incrementAndGet() {
        short s;
        short s2;
        while (!this.myValue.compareAndSet(s2 = (short)this.myValue.get(), s = (short)(s2 + 1))) {
        }
        return s;
    }

    public short decrementAndGet() {
        short s;
        short s2;
        while (!this.myValue.compareAndSet(s2 = (short)this.myValue.get(), s = (short)(s2 - 1))) {
        }
        return s;
    }

    public short addAndGet(short s) {
        short s2;
        short s3;
        while (!this.myValue.compareAndSet(s3 = (short)this.myValue.get(), s2 = (short)(s3 + s))) {
        }
        return s2;
    }

    public short reduce(short s, ShortOp shortOp) {
        short s2;
        short s3;
        while (!this.myValue.compareAndSet(s3 = (short)this.myValue.get(), s2 = shortOp.op(s3, s))) {
        }
        return s2;
    }

    public String toString() {
        return Integer.toString(this.get());
    }

    public int intValue() {
        return this.get();
    }

    public long longValue() {
        return this.get();
    }

    public float floatValue() {
        return this.get();
    }

    public double doubleValue() {
        return this.get();
    }
}

