/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.pj.io;

import edu.rit.pj.cluster.JobBackend;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class StreamFile {
    private File myFile;

    public StreamFile(File file) {
        if (file == null) {
            throw new NullPointerException("StreamFile(): theFile is null");
        }
        this.myFile = file;
    }

    public File getFile() {
        return this.myFile;
    }

    public OutputStream getOutputStream() throws IOException {
        return this.getOutputStream(false);
    }

    public OutputStream getOutputStream(boolean bl) throws IOException {
        JobBackend jobBackend = JobBackend.getJobBackend();
        if (jobBackend == null) {
            return new FileOutputStream(this.myFile, bl);
        }
        return jobBackend.getFileWriter().open(this.myFile, bl);
    }

    public InputStream getInputStream() throws IOException {
        JobBackend jobBackend = JobBackend.getJobBackend();
        if (jobBackend == null) {
            return new FileInputStream(this.myFile);
        }
        return jobBackend.getFileReader().open(this.myFile);
    }

    public boolean equals(Object object) {
        return object instanceof StreamFile && this.myFile.equals(((StreamFile)object).myFile);
    }

    public int hashCode() {
        return this.myFile.hashCode();
    }

    public String toString() {
        return this.myFile.toString();
    }
}

