/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.pj.cluster;

import edu.rit.pj.cluster.BackendFileInputStream;
import edu.rit.pj.cluster.JobBackendRef;
import edu.rit.pj.cluster.JobFrontendRef;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class BackendFileReader {
    public final BackendFileInputStream in;
    private JobFrontendRef myJobFrontend;
    private JobBackendRef myJobBackend;
    private Map<Integer, BackendFileInputStream> myInputStreamForBFD = new HashMap<Integer, BackendFileInputStream>();
    private Map<Integer, BackendFileInputStream> myInputStreamForFFD = new HashMap<Integer, BackendFileInputStream>();
    private int myNextBFD = 1;

    public BackendFileReader(JobFrontendRef jobFrontendRef, JobBackendRef jobBackendRef) {
        this.myJobFrontend = jobFrontendRef;
        this.myJobBackend = jobBackendRef;
        this.in = new BackendFileInputStream(this.myJobFrontend, this.myJobBackend, 1);
        this.myInputStreamForFFD.put(1, this.in);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BackendFileInputStream open(File file) throws IOException {
        BackendFileInputStream backendFileInputStream = null;
        int n = 0;
        int n2 = 0;
        BackendFileReader backendFileReader = this;
        synchronized (backendFileReader) {
            backendFileInputStream = new BackendFileInputStream(this.myJobFrontend, this.myJobBackend);
            n = this.myNextBFD++;
            this.myInputStreamForBFD.put(n, backendFileInputStream);
        }
        n2 = backendFileInputStream.open(n, file);
        backendFileReader = this;
        synchronized (backendFileReader) {
            this.myInputStreamForFFD.put(n2, backendFileInputStream);
        }
        return backendFileInputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void inputFileOpenResult(JobFrontendRef jobFrontendRef, int n, int n2, IOException iOException) {
        BackendFileInputStream backendFileInputStream = null;
        BackendFileReader backendFileReader = this;
        synchronized (backendFileReader) {
            backendFileInputStream = this.myInputStreamForBFD.remove(n);
        }
        if (backendFileInputStream != null) {
            backendFileInputStream.putResult(n2, 0, 0L, iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void inputFileReadResult(JobFrontendRef jobFrontendRef, int n, int n2, IOException iOException) {
        BackendFileInputStream backendFileInputStream = null;
        BackendFileReader backendFileReader = this;
        synchronized (backendFileReader) {
            backendFileInputStream = this.myInputStreamForFFD.get(n);
        }
        if (backendFileInputStream != null) {
            backendFileInputStream.putResult(n, n2, 0L, iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void inputFileSkipResult(JobFrontendRef jobFrontendRef, int n, long l, IOException iOException) {
        BackendFileInputStream backendFileInputStream = null;
        BackendFileReader backendFileReader = this;
        synchronized (backendFileReader) {
            backendFileInputStream = this.myInputStreamForFFD.get(n);
        }
        if (backendFileInputStream != null) {
            backendFileInputStream.putResult(n, 0, l, iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void inputFileCloseResult(JobFrontendRef jobFrontendRef, int n, IOException iOException) {
        BackendFileInputStream backendFileInputStream = null;
        BackendFileReader backendFileReader = this;
        synchronized (backendFileReader) {
            backendFileInputStream = this.myInputStreamForFFD.remove(n);
        }
        if (backendFileInputStream != null) {
            backendFileInputStream.putResult(n, 0, 0L, iOException);
        }
    }
}

