/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.numeric.plot;

import edu.rit.numeric.plot.Strokes;
import edu.rit.swing.Drawable;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public abstract class Dots
implements Drawable,
Externalizable {
    public static Dots circle() {
        return new Ellipse(Color.black, null, null, 5.0, 5.0);
    }

    public static Dots circle(double d) {
        return new Ellipse(Color.black, null, null, d, d);
    }

    public static Dots circle(Color color) {
        return new Ellipse(color, null, null, 5.0, 5.0);
    }

    public static Dots circle(Color color, BasicStroke basicStroke, Color color2) {
        return new Ellipse(color, basicStroke, color2, 5.0, 5.0);
    }

    public static Dots circle(Color color, BasicStroke basicStroke, Color color2, double d) {
        return new Ellipse(color, basicStroke, color2, d, d);
    }

    public static Dots ellipse(double d, double d2) {
        return new Ellipse(Color.black, null, null, d, d2);
    }

    public static Dots ellipse(Color color, double d, double d2) {
        return new Ellipse(color, null, null, d, d2);
    }

    public static Dots ellipse(Color color, BasicStroke basicStroke, Color color2, double d, double d2) {
        return new Ellipse(color, basicStroke, color2, d, d2);
    }

    public static Dots diamond() {
        return new Rectangle(Color.black, null, null, 5.0, 5.0, 0.7853981633974483);
    }

    public static Dots diamond(double d) {
        return new Rectangle(Color.black, null, null, d, d, 0.7853981633974483);
    }

    public static Dots diamond(Color color) {
        return new Rectangle(color, null, null, 5.0, 5.0, 0.7853981633974483);
    }

    public static Dots diamond(Color color, BasicStroke basicStroke, Color color2) {
        return new Rectangle(color, basicStroke, color2, 5.0, 5.0, 0.7853981633974483);
    }

    public static Dots diamond(Color color, BasicStroke basicStroke, Color color2, double d) {
        return new Rectangle(color, basicStroke, color2, d, d, 0.7853981633974483);
    }

    public static Dots square() {
        return new Rectangle(Color.black, null, null, 5.0, 5.0, 0.0);
    }

    public static Dots square(double d) {
        return new Rectangle(Color.black, null, null, d, d, 0.0);
    }

    public static Dots square(Color color) {
        return new Rectangle(color, null, null, 5.0, 5.0, 0.0);
    }

    public static Dots square(Color color, BasicStroke basicStroke, Color color2) {
        return new Rectangle(color, basicStroke, color2, 5.0, 5.0, 0.0);
    }

    public static Dots square(Color color, BasicStroke basicStroke, Color color2, double d) {
        return new Rectangle(color, basicStroke, color2, d, d, 0.0);
    }

    private static class Rectangle
    extends Dots {
        private static final long serialVersionUID = 3000182552146442565L;
        private Color myFillColor;
        private BasicStroke myOutlineStroke;
        private Color myOutlineColor;
        private Rectangle2D.Double myRectangle;
        private double myAngle;

        public Rectangle() {
        }

        public Rectangle(Color color, BasicStroke basicStroke, Color color2, double d, double d2, double d3) {
            this.myFillColor = color;
            this.myOutlineStroke = basicStroke;
            this.myOutlineColor = color2;
            this.myRectangle = new Rectangle2D.Double(-d / 2.0, -d2 / 2.0, d, d2);
            this.myAngle = d3;
        }

        public void draw(Graphics2D graphics2D) {
            Paint paint = graphics2D.getPaint();
            AffineTransform affineTransform = graphics2D.getTransform();
            graphics2D.rotate(this.myAngle);
            if (this.myFillColor != null) {
                graphics2D.setPaint(this.myFillColor);
                graphics2D.fill(this.myRectangle);
            }
            if (this.myOutlineStroke != null && this.myOutlineColor != null) {
                Stroke stroke = graphics2D.getStroke();
                graphics2D.setStroke(this.myOutlineStroke);
                graphics2D.setPaint(this.myOutlineColor);
                graphics2D.draw(this.myRectangle);
                graphics2D.setStroke(stroke);
            }
            graphics2D.setPaint(paint);
            graphics2D.setTransform(affineTransform);
        }

        public void writeExternal(ObjectOutput objectOutput) throws IOException {
            objectOutput.writeObject(this.myFillColor);
            objectOutput.writeObject(this.myOutlineColor);
            Strokes.writeExternal(this.myOutlineStroke, objectOutput);
            objectOutput.writeDouble(this.myRectangle.x);
            objectOutput.writeDouble(this.myRectangle.y);
            objectOutput.writeDouble(this.myRectangle.width);
            objectOutput.writeDouble(this.myRectangle.height);
            objectOutput.writeDouble(this.myAngle);
        }

        public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
            this.myFillColor = (Color)objectInput.readObject();
            this.myOutlineColor = (Color)objectInput.readObject();
            this.myOutlineStroke = Strokes.readExternal(objectInput);
            this.myRectangle = new Rectangle2D.Double(objectInput.readDouble(), objectInput.readDouble(), objectInput.readDouble(), objectInput.readDouble());
            this.myAngle = objectInput.readDouble();
        }
    }

    private static class Ellipse
    extends Dots {
        private static final long serialVersionUID = -3905475094865863992L;
        private Color myFillColor;
        private BasicStroke myOutlineStroke;
        private Color myOutlineColor;
        private Ellipse2D.Double myEllipse;

        public Ellipse() {
        }

        public Ellipse(Color color, BasicStroke basicStroke, Color color2, double d, double d2) {
            this.myFillColor = color;
            this.myOutlineStroke = basicStroke;
            this.myOutlineColor = color2;
            this.myEllipse = new Ellipse2D.Double(-d / 2.0, -d2 / 2.0, d, d2);
        }

        public void draw(Graphics2D graphics2D) {
            Paint paint = graphics2D.getPaint();
            if (this.myFillColor != null) {
                graphics2D.setPaint(this.myFillColor);
                graphics2D.fill(this.myEllipse);
            }
            if (this.myOutlineStroke != null && this.myOutlineColor != null) {
                Stroke stroke = graphics2D.getStroke();
                graphics2D.setStroke(this.myOutlineStroke);
                graphics2D.setPaint(this.myOutlineColor);
                graphics2D.draw(this.myEllipse);
                graphics2D.setStroke(stroke);
            }
            graphics2D.setPaint(paint);
        }

        public void writeExternal(ObjectOutput objectOutput) throws IOException {
            objectOutput.writeObject(this.myFillColor);
            objectOutput.writeObject(this.myOutlineColor);
            Strokes.writeExternal(this.myOutlineStroke, objectOutput);
            objectOutput.writeDouble(this.myEllipse.x);
            objectOutput.writeDouble(this.myEllipse.y);
            objectOutput.writeDouble(this.myEllipse.width);
            objectOutput.writeDouble(this.myEllipse.height);
        }

        public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
            this.myFillColor = (Color)objectInput.readObject();
            this.myOutlineColor = (Color)objectInput.readObject();
            this.myOutlineStroke = Strokes.readExternal(objectInput);
            this.myEllipse = new Ellipse2D.Double(objectInput.readDouble(), objectInput.readDouble(), objectInput.readDouble(), objectInput.readDouble());
        }
    }
}

