/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.mri;

import edu.rit.numeric.Series;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class PixelSignal
implements Externalizable {
    private static final long serialVersionUID = 3137091490421051491L;
    private int fileIndex;
    private int pixelIndex;
    private short[] S;

    public PixelSignal() {
    }

    public PixelSignal(int n, int n2, short[] sArray) {
        this.fileIndex(n);
        this.pixelIndex(n2);
        this.S_measured(sArray);
    }

    public PixelSignal(int n, int n2, Series series) {
        this.fileIndex(n);
        this.pixelIndex(n2);
        this.S_measured(series);
    }

    public int fileIndex() {
        return this.fileIndex;
    }

    public void fileIndex(int n) {
        this.fileIndex = n;
    }

    public int pixelIndex() {
        return this.pixelIndex;
    }

    public void pixelIndex(int n) {
        this.pixelIndex = n;
    }

    public int length() {
        return this.S == null ? 0 : this.S.length;
    }

    public Series S_measured() {
        return this.S == null ? null : new Series(){

            public int length() {
                return PixelSignal.this.S.length;
            }

            public double x(int n) {
                return PixelSignal.this.S[n];
            }
        };
    }

    public void S_measured(short[] sArray) {
        this.S = (short[])(sArray != null ? (short[])sArray.clone() : null);
    }

    public void S_measured(Series series) {
        if (series != null) {
            int n = series.length();
            this.S = new short[n];
            for (int i = 0; i < n; ++i) {
                this.S[i] = (short)Math.max(-32768.0, Math.min(series.x(i), 32767.0));
            }
        } else {
            this.S = null;
        }
    }

    public void write(DataOutput dataOutput) throws IOException {
        int n = this.S == null ? 0 : this.S.length;
        dataOutput.writeShort((short)n);
        for (int i = 0; i < n; ++i) {
            dataOutput.writeShort(this.S[i]);
        }
    }

    public void read(DataInput dataInput) throws IOException {
        int n = dataInput.readShort();
        if (n == 0) {
            this.S = null;
        } else {
            this.S = new short[n];
            for (int i = 0; i < n; ++i) {
                this.S[i] = dataInput.readShort();
            }
        }
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeInt(this.fileIndex);
        objectOutput.writeInt(this.pixelIndex);
        this.write(objectOutput);
    }

    public void readExternal(ObjectInput objectInput) throws IOException {
        this.fileIndex = objectInput.readInt();
        this.pixelIndex = objectInput.readInt();
        this.read(objectInput);
    }
}

