/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.hyb.network;

import edu.rit.io.DoubleMatrixFile;
import edu.rit.io.Files;
import edu.rit.mp.DoubleBuf;
import edu.rit.pj.Comm;
import edu.rit.pj.IntegerForLoop;
import edu.rit.pj.ParallelRegion;
import edu.rit.pj.ParallelTeam;
import edu.rit.util.Range;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;

public class FloydHyb {
    static Comm world;
    static int size;
    static int rank;
    static int n;
    static double[][] d;
    static Range[] ranges;
    static Range myrange;
    static int mylb;
    static int myub;
    static double[] row_i;
    static DoubleBuf row_i_buf;
    static int i;
    static double[] d_i;

    private FloydHyb() {
    }

    public static void main(String[] stringArray) throws Throwable {
        long l = System.currentTimeMillis();
        Comm.init(stringArray);
        world = Comm.world();
        size = world.size();
        rank = world.rank();
        if (stringArray.length != 2) {
            FloydHyb.usage();
        }
        File file = new File(stringArray[0]);
        File file2 = new File(stringArray[1]);
        DoubleMatrixFile doubleMatrixFile = new DoubleMatrixFile();
        DoubleMatrixFile.Reader reader = doubleMatrixFile.prepareToRead(new BufferedInputStream(new FileInputStream(file)));
        d = doubleMatrixFile.getMatrix();
        n = d.length;
        ranges = new Range(0, n - 1).subranges(size);
        myrange = ranges[rank];
        mylb = myrange.lb();
        myub = myrange.ub();
        reader.readRowSlice(myrange);
        reader.close();
        row_i = new double[n];
        row_i_buf = DoubleBuf.buffer(row_i);
        long l2 = System.currentTimeMillis();
        int n = 0;
        ParallelTeam parallelTeam = new ParallelTeam();
        for (i = 0; i < FloydHyb.n; ++i) {
            d_i = d[i];
            if (!ranges[n].contains(i)) {
                ++n;
            }
            if (rank == n) {
                world.broadcast(n, DoubleBuf.buffer(d_i));
            } else {
                world.broadcast(n, row_i_buf);
                d_i = row_i;
            }
            parallelTeam.execute(new ParallelRegion(){

                public void run() throws Exception {
                    this.execute(mylb, myub, new IntegerForLoop(){

                        public void run(int n, int n2) throws Exception {
                            for (int i = n; i <= n2; ++i) {
                                double[] dArray = d[i];
                                for (int j = 0; j < FloydHyb.n; ++j) {
                                    dArray[j] = Math.min(dArray[j], dArray[FloydHyb.i] + d_i[j]);
                                }
                            }
                        }
                    });
                }
            });
        }
        long l3 = System.currentTimeMillis();
        DoubleMatrixFile doubleMatrixFile2 = new DoubleMatrixFile(FloydHyb.n, FloydHyb.n, d);
        DoubleMatrixFile.Writer writer = doubleMatrixFile2.prepareToWrite(new BufferedOutputStream(new FileOutputStream(Files.fileForRank(file2, rank))));
        writer.writeRowSlice(myrange);
        writer.close();
        long l4 = System.currentTimeMillis();
        System.out.println(l2 - l + " msec pre " + rank);
        System.out.println(l3 - l2 + " msec calc " + rank);
        System.out.println(l4 - l3 + " msec post " + rank);
        System.out.println(l4 - l + " msec total " + rank);
    }

    private static void usage() {
        System.err.println("Usage: java -Dpj.np=<Kp> -Dpj.nt=<Kt> edu.rit.hyb.network.FloydHyb <infile> <outfile>");
        System.err.println("<Kp> = Number of parallel processes");
        System.err.println("<Kt> = Number of parallel threads per process");
        System.err.println("<infile> = Input distance matrix file");
        System.err.println("<outfile> = Output distance matrix file");
        System.exit(1);
    }
}

