/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.draw.item;

import edu.rit.draw.Drawing;
import edu.rit.draw.item.DrawingItem;
import edu.rit.draw.item.Point;
import edu.rit.draw.item.Size;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Externalizable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import javax.imageio.ImageIO;

public class Image
extends DrawingItem
implements Externalizable {
    public static final double NORMAL_SCALE = 1.0;
    private static final long serialVersionUID = 6921389113129571217L;
    static double theDefaultScale = 1.0;
    byte[] myImageContents;
    BufferedImage myBufferedImage;
    double myScale = theDefaultScale;
    double x;
    double y;
    double xFactor;
    double yFactor;
    Size mySize;

    public Image() {
    }

    public Image(Image image) {
        super(image);
        this.myImageContents = image.myImageContents;
        this.myScale = image.myScale;
        this.x = image.x;
        this.y = image.y;
        this.xFactor = image.xFactor;
        this.yFactor = image.yFactor;
        this.mySize = image.mySize;
    }

    public static double defaultScale() {
        return theDefaultScale;
    }

    public static void defaultScale(double d) {
        if (d < 0.0) {
            throw new IllegalArgumentException();
        }
        theDefaultScale = d;
    }

    public BufferedImage image() {
        return this.myBufferedImage;
    }

    public Image image(String string) throws IOException {
        this.readImageContents(new FileInputStream(string));
        this.getBufferedImage();
        return this;
    }

    public Image image(File file) throws IOException {
        this.readImageContents(new FileInputStream(file));
        this.getBufferedImage();
        return this;
    }

    public Image image(InputStream inputStream) throws IOException {
        this.readImageContents(inputStream);
        this.getBufferedImage();
        return this;
    }

    public double scale() {
        return this.myScale;
    }

    public Image scale(double d) {
        if (d < 0.0) {
            throw new IllegalArgumentException();
        }
        this.myScale = d;
        return this;
    }

    public double width() {
        this.computeSize();
        return this.mySize.width;
    }

    public double height() {
        this.computeSize();
        return this.mySize.height;
    }

    public Point nw() {
        this.computeSize();
        return new Point(this.x + this.xFactor * this.mySize.width, this.y + this.yFactor * this.mySize.height);
    }

    public Image nw(double d, double d2) {
        this.doNw(d, d2);
        return this;
    }

    public Image nw(Point point) {
        this.doNw(point.x, point.y);
        return this;
    }

    public Image n(double d, double d2) {
        this.doN(d, d2);
        return this;
    }

    public Image n(Point point) {
        this.doN(point.x, point.y);
        return this;
    }

    public Image ne(double d, double d2) {
        this.doNe(d, d2);
        return this;
    }

    public Image ne(Point point) {
        this.doNe(point.x, point.y);
        return this;
    }

    public Image w(double d, double d2) {
        this.doW(d, d2);
        return this;
    }

    public Image w(Point point) {
        this.doW(point.x, point.y);
        return this;
    }

    public Image c(double d, double d2) {
        this.doC(d, d2);
        return this;
    }

    public Image c(Point point) {
        this.doC(point.x, point.y);
        return this;
    }

    public Image e(double d, double d2) {
        this.doE(d, d2);
        return this;
    }

    public Image e(Point point) {
        this.doE(point.x, point.y);
        return this;
    }

    public Image sw(double d, double d2) {
        this.doSw(d, d2);
        return this;
    }

    public Image sw(Point point) {
        this.doSw(point.x, point.y);
        return this;
    }

    public Image s(double d, double d2) {
        this.doS(d, d2);
        return this;
    }

    public Image s(Point point) {
        this.doS(point.x, point.y);
        return this;
    }

    public Image se(double d, double d2) {
        this.doSe(d, d2);
        return this;
    }

    public Image se(Point point) {
        this.doSe(point.x, point.y);
        return this;
    }

    public Image add() {
        this.doAdd(Drawing.defaultDrawing());
        return this;
    }

    public Image add(Drawing drawing) {
        this.doAdd(drawing);
        return this;
    }

    public Image addFirst() {
        this.doAddFirst(Drawing.defaultDrawing());
        return this;
    }

    public Image addFirst(Drawing drawing) {
        this.doAddFirst(drawing);
        return this;
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        super.writeExternal(objectOutput);
        objectOutput.writeInt(this.myImageContents.length);
        objectOutput.write(this.myImageContents);
        objectOutput.writeDouble(this.myScale);
        objectOutput.writeDouble(this.x);
        objectOutput.writeDouble(this.y);
        objectOutput.writeDouble(this.xFactor);
        objectOutput.writeDouble(this.yFactor);
        objectOutput.writeObject(this.mySize);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        super.readExternal(objectInput);
        int n = objectInput.readInt();
        this.myImageContents = new byte[n];
        objectInput.readFully(this.myImageContents);
        this.getBufferedImage();
        this.myScale = objectInput.readDouble();
        this.x = objectInput.readDouble();
        this.y = objectInput.readDouble();
        this.xFactor = objectInput.readDouble();
        this.yFactor = objectInput.readDouble();
        this.mySize = (Size)objectInput.readObject();
    }

    public void draw(Graphics2D graphics2D) {
        super.draw(graphics2D);
        this.computeSize();
        double d = this.x + this.xFactor * this.mySize.width();
        double d2 = this.y + this.yFactor * this.mySize.height();
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.translate(d, d2);
        affineTransform.scale(this.myScale, this.myScale);
        affineTransform.translate(-this.myBufferedImage.getMinX(), -this.myBufferedImage.getMinY());
        graphics2D.drawRenderedImage(this.myBufferedImage, affineTransform);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readImageContents(InputStream inputStream) throws IOException {
        try {
            int n;
            BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            while ((n = bufferedInputStream.read()) != -1) {
                byteArrayOutputStream.write(n);
            }
            this.myImageContents = byteArrayOutputStream.toByteArray();
            this.myBufferedImage = null;
            this.mySize = null;
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
        }
    }

    private void getBufferedImage() throws IOException {
        try {
            this.myBufferedImage = ImageIO.read(new ByteArrayInputStream(this.myImageContents));
            this.mySize = null;
        }
        catch (IOException iOException) {
            this.myImageContents = null;
            this.myBufferedImage = null;
            this.mySize = null;
            throw iOException;
        }
    }

    void computeSize() {
        if (this.mySize == null) {
            this.mySize = this.myBufferedImage != null ? new Size(this.myScale * (double)this.myBufferedImage.getWidth(), this.myScale * (double)this.myBufferedImage.getHeight()) : new Size(0.0, 0.0);
        }
    }

    void doNw(double d, double d2) {
        this.x = d;
        this.y = d2;
        this.xFactor = 0.0;
        this.yFactor = 0.0;
    }

    void doN(double d, double d2) {
        this.x = d;
        this.y = d2;
        this.xFactor = -0.5;
        this.yFactor = 0.0;
    }

    void doNe(double d, double d2) {
        this.x = d;
        this.y = d2;
        this.xFactor = -1.0;
        this.yFactor = 0.0;
    }

    void doW(double d, double d2) {
        this.x = d;
        this.y = d2;
        this.xFactor = 0.0;
        this.yFactor = -0.5;
    }

    void doC(double d, double d2) {
        this.x = d;
        this.y = d2;
        this.xFactor = -0.5;
        this.yFactor = -0.5;
    }

    void doE(double d, double d2) {
        this.x = d;
        this.y = d2;
        this.xFactor = -1.0;
        this.yFactor = -0.5;
    }

    void doSw(double d, double d2) {
        this.x = d;
        this.y = d2;
        this.xFactor = 0.0;
        this.yFactor = -1.0;
    }

    void doS(double d, double d2) {
        this.x = d;
        this.y = d2;
        this.xFactor = -0.5;
        this.yFactor = -1.0;
    }

    void doSe(double d, double d2) {
        this.x = d;
        this.y = d2;
        this.xFactor = -1.0;
        this.yFactor = -1.0;
    }
}

