/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.compbio.seq;

import edu.rit.compbio.seq.ProteinSequence;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;

public class ProteinDatabase {
    private File myDatabaseFile;
    private File myIndexFile;
    private RandomAccessFile myIndex;
    private long myProteinCount;
    private long myDatabaseLength;
    private long myFileLength;

    public ProteinDatabase(File file, File file2) throws IOException {
        if (file == null) {
            throw new NullPointerException("ProteinDatabase(): theDatabaseFile is null");
        }
        if (file2 == null) {
            throw new NullPointerException("ProteinDatabase(): theIndexFile is null");
        }
        this.myDatabaseFile = file;
        this.myIndexFile = file2;
        this.myIndex = new RandomAccessFile(file2, "r");
        long l = this.myIndex.length();
        if ((l & 7L) != 0L) {
            throw new IOException("ProteinDatabase(): Index file \"" + file2 + "\" has invalid length (= " + l + ")");
        }
        this.myProteinCount = (l >> 3) - 1L;
        this.myDatabaseLength = this.myIndex.readLong();
        this.myFileLength = file.length();
    }

    public long getDatabaseLength() {
        return this.myDatabaseLength;
    }

    public long getProteinCount() {
        return this.myProteinCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProteinSequence getProteinSequence(long l) throws IOException {
        long l2;
        if (0L > l || l >= this.myProteinCount) {
            throw new IndexOutOfBoundsException("ProteinDatabase.getProteinSequence(): i (= " + l + ") out of bounds");
        }
        Object object = this;
        synchronized (object) {
            this.myIndex.seek(l + 1L << 3);
            l2 = this.myIndex.readLong();
        }
        if (0L > l2 || l2 >= this.myFileLength) {
            throw new IOException("ProteinDatabase.getProteinSequence(" + l + "): Invalid offset (= " + l2 + ")");
        }
        object = null;
        try {
            object = new BufferedInputStream(new FileInputStream(this.myDatabaseFile));
            long l3 = 0L;
            for (long i = l2; i > 0L; i -= l3) {
                l3 = ((InputStream)object).skip(i);
                if (l3 != 0L) continue;
                throw new IOException("ProteinDatabase.getProteinSequence(" + l + "): Unexpected end of file");
            }
            ProteinSequence proteinSequence = new ProteinSequence((InputStream)object);
            return proteinSequence;
        }
        finally {
            if (object != null) {
                try {
                    ((InputStream)object).close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public void close() throws IOException {
        this.myIndex.close();
    }

    protected void finalize() {
        try {
            this.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void main(String[] stringArray) throws Exception {
        int n;
        if (stringArray.length < 2 || stringArray.length > 3) {
            ProteinDatabase.usage();
        }
        File file = new File(stringArray[0]);
        File file2 = new File(stringArray[1]);
        long l = Long.MAX_VALUE;
        if (stringArray.length == 3) {
            l = Long.parseLong(stringArray[2]);
        }
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
        RandomAccessFile randomAccessFile = new RandomAccessFile(file2, "rw");
        randomAccessFile.writeLong(0L);
        long l2 = 0L;
        long l3 = 0L;
        int n2 = 0;
        block5: while ((n = ((InputStream)bufferedInputStream).read()) != -1) {
            switch (n2) {
                case 0: {
                    if (n == 62) {
                        if (l == 0L) break block5;
                        randomAccessFile.writeLong(l2);
                        --l;
                        n2 = 1;
                        break;
                    }
                    if (n == 13 || n == 10) {
                        n2 = 0;
                        break;
                    }
                    ++l3;
                    n2 = 2;
                    break;
                }
                case 1: {
                    if (n == 13 || n == 10) {
                        n2 = 0;
                        break;
                    }
                    n2 = 1;
                    break;
                }
                case 2: {
                    if (n == 13 || n == 10) {
                        n2 = 0;
                        break;
                    }
                    ++l3;
                    n2 = 2;
                }
            }
            ++l2;
        }
        randomAccessFile.seek(0L);
        randomAccessFile.writeLong(l3);
        ((InputStream)bufferedInputStream).close();
        randomAccessFile.close();
    }

    private static void usage() {
        System.err.println("Usage: java edu.rit.compbio.seq.ProteinDatabase <databasefile> <indexfile> [<length>]");
        System.err.println("<databasefile> = Input protein sequence database file");
        System.err.println("<indexfile> = Output protein sequence index file");
        System.err.println("<length> = Number of sequences in the index (default: all)");
        System.exit(1);
    }
}

