/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.compbio.seq;

import edu.rit.compbio.seq.Alignment;
import edu.rit.compbio.seq.AlignmentStats;
import java.io.PrintStream;

public class DefaultAlignmentStats
implements AlignmentStats {
    private static final double K = 0.035;
    private static final double lambda = 0.252;
    private static final double LN_K = Math.log(0.035);
    private static final double LN_2 = Math.log(2.0);
    private long n;

    public DefaultAlignmentStats(long l) {
        this.n = l;
    }

    public double rawScore(Alignment alignment) {
        return alignment.myScore;
    }

    public double bitScore(Alignment alignment) {
        double d = alignment.myScore;
        return (0.252 * d - LN_K) / LN_2;
    }

    public double eValue(Alignment alignment) {
        int n = alignment.myQueryLength;
        double d = alignment.myScore;
        return 0.035 * (double)n * (double)this.n * Math.exp(-0.252 * d);
    }

    public void print(PrintStream printStream) {
        printStream.println("K: 0.035");
        printStream.println("Lambda: 0.252");
        printStream.println("Matrix: BLOSUM-62");
        printStream.println("Gap Penalties: Existence: -11, Extension: -1");
    }
}

