/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.clu.timing;

import edu.rit.mp.IntegerBuf;
import edu.rit.pj.Comm;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.Date;

public class TimeSendInt {
    private static final DecimalFormat FMT3 = new DecimalFormat("0.00E0");
    static Comm world;
    static int size;
    static int rank;
    static int reps;
    static int numn;
    static int[] n;

    private TimeSendInt() {
    }

    public static void main(String[] stringArray) throws Exception {
        block9: {
            int n;
            block8: {
                Comm.init(stringArray);
                world = Comm.world();
                size = world.size();
                rank = world.rank();
                if (stringArray.length < 2) {
                    TimeSendInt.usage();
                }
                reps = Integer.parseInt(stringArray[0]);
                numn = stringArray.length - 1;
                TimeSendInt.n = new int[numn];
                for (n = 0; n < numn; ++n) {
                    TimeSendInt.n[n] = Integer.parseInt(stringArray[n + 1]);
                }
                if (rank != 0) break block8;
                System.out.println("java -Dpj.np=2 edu.rit.clu.timing.TimeSendInt " + reps);
                System.out.println(new Date());
                System.out.println("n\ttime1\ttime2\tSend time (sec)");
                for (n = 0; n < numn; ++n) {
                    int n2 = TimeSendInt.n[n];
                    int[] nArray = new int[n2];
                    IntegerBuf integerBuf = IntegerBuf.buffer(nArray);
                    long l = -System.currentTimeMillis();
                    for (int i = 0; i < reps; ++i) {
                        TimeSendInt.fill(n2, nArray, integerBuf);
                    }
                    l += System.currentTimeMillis();
                    long l2 = -System.currentTimeMillis();
                    for (int i = 0; i < reps; ++i) {
                        TimeSendInt.fillSendReceive(n2, nArray, integerBuf);
                    }
                    double d = (double)((l2 += System.currentTimeMillis()) - l) / (double)reps / 2000.0;
                    System.out.print(n2);
                    System.out.print('\t');
                    System.out.print(l);
                    System.out.print('\t');
                    System.out.print(l2);
                    System.out.print('\t');
                    System.out.print(FMT3.format(d));
                    System.out.println();
                }
                break block9;
            }
            if (rank != 1) break block9;
            for (n = 0; n < numn; ++n) {
                int n3;
                int n4 = TimeSendInt.n[n];
                int[] nArray = new int[n4];
                IntegerBuf integerBuf = IntegerBuf.buffer(nArray);
                for (n3 = 0; n3 < reps; ++n3) {
                    TimeSendInt.fill(n4, nArray, integerBuf);
                }
                for (n3 = 0; n3 < reps; ++n3) {
                    TimeSendInt.fillReceiveSend(n4, nArray, integerBuf);
                }
            }
        }
    }

    private static void fill(int n, int[] nArray, IntegerBuf integerBuf) {
        for (int i = 0; i < n; ++i) {
            nArray[i] = i;
        }
    }

    private static void fillSendReceive(int n, int[] nArray, IntegerBuf integerBuf) throws IOException {
        for (int i = 0; i < n; ++i) {
            nArray[i] = i;
        }
        world.send(1, integerBuf);
        world.receive(1, integerBuf);
    }

    private static void fillReceiveSend(int n, int[] nArray, IntegerBuf integerBuf) throws IOException {
        for (int i = 0; i < n; ++i) {
            nArray[i] = i;
        }
        world.receive(0, integerBuf);
        world.send(0, integerBuf);
    }

    private static void usage() {
        System.err.println("Usage: java -Dpj.np=2 edu.rit.clu.timing.TimeSendInt <reps> <n1> [<n2> ...]");
        System.err.println("<reps> = Number of repetitions for each value of <n>");
        System.err.println("<n1> = First value of <n>");
        System.err.println("<n2> = Second value of <n> . . .");
        System.exit(1);
    }
}

