/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.clu.keysearch;

import edu.rit.crypto.blockcipher.AES256Cipher;
import edu.rit.pj.Comm;
import edu.rit.pj.WorkerLongForLoop;
import edu.rit.pj.WorkerRegion;
import edu.rit.pj.WorkerTeam;
import edu.rit.util.Hex;

public class FindKeyClu {
    static Comm world;
    static int size;
    static int rank;
    static byte[] plaintext;
    static byte[] ciphertext;
    static byte[] partialkey;
    static int n;
    static long keylsbs;
    static long maxcounter;
    static byte[] foundkey;
    static byte[] trialkey;
    static byte[] trialciphertext;
    static AES256Cipher cipher;

    private FindKeyClu() {
    }

    public static void main(String[] stringArray) throws Exception {
        long l = System.currentTimeMillis();
        Comm.init(stringArray);
        world = Comm.world();
        size = world.size();
        rank = world.rank();
        if (stringArray.length != 4) {
            FindKeyClu.usage();
        }
        plaintext = Hex.toByteArray(stringArray[0]);
        ciphertext = Hex.toByteArray(stringArray[1]);
        partialkey = Hex.toByteArray(stringArray[2]);
        n = Integer.parseInt(stringArray[3]);
        if (n < 0) {
            System.err.println("n = " + n + " is too small");
            System.exit(1);
        }
        if (n > 63) {
            System.err.println("n = " + n + " is too large");
            System.exit(1);
        }
        keylsbs = ((long)partialkey[24] & 0xFFL) << 56 | ((long)partialkey[25] & 0xFFL) << 48 | ((long)partialkey[26] & 0xFFL) << 40 | ((long)partialkey[27] & 0xFFL) << 32 | ((long)partialkey[28] & 0xFFL) << 24 | ((long)partialkey[29] & 0xFFL) << 16 | ((long)partialkey[30] & 0xFFL) << 8 | (long)partialkey[31] & 0xFFL;
        maxcounter = (1L << n) - 1L;
        trialkey = new byte[32];
        System.arraycopy(partialkey, 0, trialkey, 0, 32);
        trialciphertext = new byte[16];
        cipher = new AES256Cipher(trialkey);
        new WorkerTeam().execute(new WorkerRegion(){

            public void run() throws Exception {
                this.execute(0L, maxcounter, new WorkerLongForLoop(){

                    public void run(long l, long l2) {
                        for (long i = l; i <= l2; ++i) {
                            long l3 = keylsbs | i;
                            FindKeyClu.trialkey[24] = (byte)(l3 >>> 56);
                            FindKeyClu.trialkey[25] = (byte)(l3 >>> 48);
                            FindKeyClu.trialkey[26] = (byte)(l3 >>> 40);
                            FindKeyClu.trialkey[27] = (byte)(l3 >>> 32);
                            FindKeyClu.trialkey[28] = (byte)(l3 >>> 24);
                            FindKeyClu.trialkey[29] = (byte)(l3 >>> 16);
                            FindKeyClu.trialkey[30] = (byte)(l3 >>> 8);
                            FindKeyClu.trialkey[31] = (byte)l3;
                            cipher.setKey(trialkey);
                            cipher.encrypt(plaintext, trialciphertext);
                            if (!FindKeyClu.match(ciphertext, trialciphertext)) continue;
                            foundkey = new byte[32];
                            System.arraycopy(trialkey, 0, foundkey, 0, 32);
                        }
                    }
                });
            }
        });
        if (foundkey != null) {
            System.out.println(Hex.toString(foundkey));
        }
        long l2 = System.currentTimeMillis();
        System.out.println(l2 - l + " msec (" + rank + ")");
    }

    private static boolean match(byte[] byArray, byte[] byArray2) {
        boolean bl = true;
        int n = byArray.length;
        for (int i = 0; i < n; ++i) {
            bl = bl && byArray[i] == byArray2[i];
        }
        return bl;
    }

    private static void usage() {
        System.err.println("Usage: java -Dpj.np=<K> edu.rit.clu.keysearch.FindKeyClu <plaintext> <ciphertext> <partialkey> <n>");
        System.err.println("<K> = Number of parallel processes");
        System.err.println("<plaintext> = Plaintext (128-bit hexadecimal number)");
        System.err.println("<ciphertext> = Ciphertext (128-bit hexadecimal number)");
        System.err.println("<partialkey> = Partial key (256-bit hexadecimal number)");
        System.err.println("<n> = Number of key bits to search for");
        System.exit(1);
    }
}

