/*
 * Decompiled with CFR 0.152.
 */
import edu.rit.image.PJGImage;
import edu.rit.swing.DisplayableFrame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;

public class PJG {
    private PJG() {
    }

    public static void main(String[] stringArray) throws Exception {
        String string = "";
        try {
            Object object;
            if (stringArray.length < 1) {
                PJG.usage();
            }
            string = stringArray[0];
            final PJGImage pJGImage = PJGImage.readFromStream(new BufferedInputStream(new FileInputStream(string)));
            for (int i = 1; i < stringArray.length; ++i) {
                string = stringArray[i];
                object = pJGImage.prepareToRead(new BufferedInputStream(new FileInputStream(string)));
                ((PJGImage.Reader)object).read();
                ((PJGImage.Reader)object).close();
            }
            final DisplayableFrame displayableFrame = new DisplayableFrame(stringArray[0], pJGImage.getDisplayable(), 3);
            if (pJGImage.getWidth() > 800 || pJGImage.getHeight() > 800) {
                displayableFrame.setSize(800, 800);
            }
            object = displayableFrame.getJMenuBar();
            JMenu jMenu = ((JMenuBar)object).getMenu(0);
            JMenuItem jMenuItem = new JMenuItem("Save as PJG...", 65);
            jMenuItem.setAccelerator(KeyStroke.getKeyStroke(65, 2));
            jMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    PJG.doSaveAsPjg(displayableFrame, pJGImage);
                }
            });
            jMenu.insert(jMenuItem, 0);
            displayableFrame.setVisible(true);
        }
        catch (IOException iOException) {
            System.err.println("PJG: Error reading file \"" + string + "\"");
            iOException.printStackTrace(System.err);
            System.exit(1);
        }
    }

    private static void doSaveAsPjg(DisplayableFrame displayableFrame, final PJGImage pJGImage) {
        displayableFrame.saveFile(".pjg", "PJG image files", new DisplayableFrame.FileSaver(){

            public void saveFile(File file) throws IOException {
                PJGImage.Writer writer = pJGImage.prepareToWrite(new BufferedOutputStream(new FileOutputStream(file)));
                writer.write();
                writer.close();
            }
        });
    }

    private static void usage() {
        System.err.println("Usage: java PJG <filename>");
        System.exit(1);
    }
}

