## ----message=FALSE------------------------------------------------------------
library(tidyverse)
library(ggplot2)

library(dce)

set.seed(42)

## -----------------------------------------------------------------------------
dce::df_pathway_statistics %>%
  arrange(desc(node_num)) %>%
  head(10) %>%
  knitr::kable()

## -----------------------------------------------------------------------------
dce::df_pathway_statistics %>%
  count(database, sort = TRUE, name = "pathway_number") %>%
  knitr::kable()

## -----------------------------------------------------------------------------
dce::df_pathway_statistics %>%
  ggplot(aes(x = node_num)) +
    geom_histogram(bins = 30) +
    facet_wrap(~ database, scales = "free") +
    theme_minimal()

## ----message=FALSE------------------------------------------------------------
pathways <- get_pathways(
  pathway_list = list(
    pathbank = c("Lactose Synthesis"),
    kegg = c("Fatty acid biosynthesis")
  )
)

lapply(pathways, function(x) {
  plot_network(
    as(x$graph, "matrix"),
    visualize_edge_weights = FALSE,
    arrow_size = 0.02,
    shadowtext = TRUE
  ) +
    ggtitle(x$pathway_name)
})

## -----------------------------------------------------------------------------
sessionInfo()

