## ---- include = FALSE---------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----setup--------------------------------------------------------------------
library(comapr)
library(GenomicRanges)
library(BiocParallel)

## ----install, eval=FALSE------------------------------------------------------
#  if (!requireNamespace("BiocManager", quietly = TRUE))
#      install.packages("BiocManager")
#  
#  BiocManager::install("comapr")

## -----------------------------------------------------------------------------
BiocParallel::register(SerialParam())
BiocParallel::bpparam()

## -----------------------------------------------------------------------------
data(snp_geno_gr)
data(parents_geno)

## -----------------------------------------------------------------------------
corrected_geno <- correctGT(gt_matrix = mcols(snp_geno_gr),
                            ref = parents_geno$ref,
                            alt = parents_geno$alt,
                            fail = "Fail",
                            wrong_label = "Homo_ref")

mcols(snp_geno_gr) <- corrected_geno

## -----------------------------------------------------------------------------
head(mcols(snp_geno_gr)[,1:5])


## -----------------------------------------------------------------------------
genotype_counts <- countGT(mcols(snp_geno_gr))

genotype_counts$plot

## -----------------------------------------------------------------------------
genotype_counts$n_markers
genotype_counts$n_samples

## -----------------------------------------------------------------------------
corrected_geno <- filterGT(snp_geno_gr,
                           min_markers = 30,
                           min_samples = 2)

## -----------------------------------------------------------------------------
dups <- findDupSamples(mcols(corrected_geno),
                       threshold = 0.99)
dups

## -----------------------------------------------------------------------------
mcols(corrected_geno) <- mcols(corrected_geno)[,colnames(mcols(corrected_geno))!="X98"]
#corrected_geno

## -----------------------------------------------------------------------------
marker_gr_cos <- countCOs(corrected_geno)

marker_gr_cos[1:5,1:5]

## -----------------------------------------------------------------------------
dist_gr <- calGeneticDist(marker_gr_cos,
                          mapping_fun = "k")

dist_gr[1:5,]

## -----------------------------------------------------------------------------
dist_bin_gr <- calGeneticDist(marker_gr_cos,bin_size = 1e6)

dist_bin_gr[1:5,]

## -----------------------------------------------------------------------------
sum(dist_bin_gr$kosambi_cm)
sum(dist_gr$kosambi_cm)


## -----------------------------------------------------------------------------
plotGeneticDist(dist_bin_gr,chr = "1")

## -----------------------------------------------------------------------------
plotGeneticDist(dist_bin_gr,chr=c("1"),cumulative = TRUE)


## ----fig.height=10,fig.width=8------------------------------------------------
plotGeneticDist(dist_bin_gr,cumulative = TRUE)

## -----------------------------------------------------------------------------
plotWholeGenome(dist_bin_gr)

## ----sessioninfo--------------------------------------------------------------
sessionInfo()

