## ----echo=FALSE, message=FALSE, include=TRUE----------------------------------
knitr::opts_chunk$set(
  echo = TRUE, collapse = TRUE, cache = TRUE, fig.show = 'hold')
#str(knitr::opts_chunk$get())

## -----------------------------------------------------------------------------
require(autonomics, quietly = TRUE)
object <-  read_rnaseq_counts(file = download_data('billing19.rnacounts.txt'), 
                              pca = TRUE, fit = 'limma', plot = TRUE)

## -----------------------------------------------------------------------------
basedir <- file.path(tempdir(), 'datasets')
dir.create(basedir, showWarnings = FALSE, recursive = TRUE)
if (!dir.exists(file.path(basedir, 'GSE161731'))){
    GEOquery::getGEOSuppFiles("GSE161731", baseDir=basedir)
}
object <- read_rnaseq_counts(
  file  = file.path(basedir, 'GSE161731/GSE161731_counts.csv.gz'), 
  sfile = file.path(basedir, 'GSE161731/GSE161731_counts_key.csv.gz'), 
  sfileby = 'rna_id', 
  subgroupvar = 'gender', 
  pca = TRUE, 
  fit = 'limma', 
  plot = TRUE)

## -----------------------------------------------------------------------------
#object <- read_rnaseq_counts(
#  file  = '~/autonomicscache/datasets/GSE161731/GSE161731_counts.csv.gz', 
#  sfile = '~/autonomicscache/datasets/GSE161731/GSE161731_counts_key.csv.gz', 
#  sfileby = 'rna_id', 
#  subgroupvar = 'gender', 
#  block = 'subject_id')

## ---- results = 'hide', eval = FALSE------------------------------------------
#  # not run to avoid issues with R CMD CHECK
#  if (requireNamespace('Rsubread')){
#    object <- read_rnaseq_bams(
#                  dir    = download_data('billing16.bam.zip'),
#                  paired = TRUE,
#                  genome = 'hg38',
#                  pca    = TRUE,
#                  fit   = 'limma',
#                  plot   = TRUE)
#  }

## -----------------------------------------------------------------------------
  file <- download_data('billing19.rnacounts.txt')
# log2counts
  object <- read_rnaseq_counts(file, 
       cpm = FALSE, voom = FALSE, fit = 'limma', verbose = FALSE, plot = FALSE)
  colSums(summarize_fit(object, 'limma')[, -1])
# log2cpm
  object <- read_rnaseq_counts(file,
       cpm = TRUE,  voom = FALSE, fit = 'limma', verbose = FALSE, plot=FALSE)
  colSums(summarize_fit(object, 'limma')[, -1])
# log2cpm + voom
  object <- read_rnaseq_counts(file,  # log2 cpm + voom
       cpm = TRUE,  voom = TRUE,  fit = 'limma', verbose = FALSE, plot=FALSE)
  colSums(summarize_fit(object, 'limma')[, -1])

## -----------------------------------------------------------------------------
object <- read_proteingroups(file = download_data('fukuda20.proteingroups.txt'), 
                             pca = TRUE, fit = 'limma', plot = TRUE)

## -----------------------------------------------------------------------------
object <- read_proteingroups(
              file = download_data('billing19.proteingroups.txt'),
              select_subgroups = c('E00_STD', 'E01_STD', 'E02_STD',
                                   'E05_STD', 'E15_STD', 'E30_STD', 'M00_STD'), 
              pca = TRUE, fit = 'limma', plot = TRUE)

## -----------------------------------------------------------------------------
object <- read_phosphosites(
              file = download_data('billing19.phosphosites.txt'), 
              proteinfile = download_data('billing19.proteingroups.txt'), 
              select_subgroups = c('E00_STD', 'E01_STD', 'E02_STD',
                                   'E05_STD', 'E15_STD', 'E30_STD', 'M00_STD'), 
              pca = TRUE, fit = 'limma', plot = TRUE)

## ---- fig.width=7, fig.height=4, out.width="95%"------------------------------
object <- read_metabolon(
        file  = download_data('atkin18.metabolon.xlsx'),  subgroupvar = 'SET',
        pca = TRUE, fit = 'limma', block = 'SUB', plot = TRUE)

## -----------------------------------------------------------------------------
object <- read_somascan(
            file = download_data('atkin18.somascan.adat'), 
            pca = TRUE, fit = 'limma', block = 'Subject_ID', plot = TRUE)

## -----------------------------------------------------------------------------
sessionInfo()

