## ----setup, include=FALSE-----------------------------------------------------
knitr::opts_chunk$set(echo = TRUE)

# preload to avoid loading messages
library(NanoMethViz)

## -----------------------------------------------------------------------------
library(NanoMethViz)
library(dplyr)

## -----------------------------------------------------------------------------
anno <- rtracklayer::import(system.file(package = "NanoMethViz", "c_elegans.gtf.gz"))

head(anno)

## -----------------------------------------------------------------------------
anno <- anno %>%
    as.data.frame() %>%
    dplyr::rename(
        chr = seqnames,
        symbol = gene_name
    ) %>%
    dplyr::select(gene_id, chr, strand, start, end, transcript_id, symbol)

head(anno)

## ---- message = FALSE---------------------------------------------------------
nmr <- load_example_nanomethresult()

plot_gene(nmr, "Peg3")

## -----------------------------------------------------------------------------
new_exons <- NanoMethViz::exons(nmr) %>%
    exons_to_genes() %>%
    mutate(transcript_id = gene_id)

NanoMethViz::exons(nmr) <- new_exons

plot_gene(nmr, "Peg3")

