## ----GenSetup, include = FALSE------------------------------------------------
knitr::opts_chunk$set(
    collapse = TRUE,
    comment = "#>",
    crop = NULL
    ## Related to
    ## https://stat.ethz.ch/pipermail/bioc-devel/2020-April/016656.html
)

## ----vignetteSetup, echo=FALSE, message=FALSE, warning = FALSE----------------
## Bib setup
library("RefManageR")

## Write bibliography information
bib <- c(
    R = citation(),
    BiocStyle = citation("BiocStyle")[1],
    knitr = citation("knitr")[1],
    RefManageR = citation("RefManageR")[1],
    rmarkdown = citation("rmarkdown")[1],
    sessioninfo = citation("sessioninfo")[1],
    testthat = citation("testthat")[1],
    ISAnalytics = citation("ISAnalytics")[1]
)

## ----echo=FALSE---------------------------------------------------------------
inst_chunk_path <- system.file("rmd", "install_and_options.Rmd", package = "ISAnalytics")

## ----include=FALSE------------------------------------------------------------
knitr::opts_chunk$set(echo = TRUE)

## ----eval=FALSE---------------------------------------------------------------
#  if (!requireNamespace("BiocManager", quietly = TRUE))
#      install.packages("BiocManager")
#  BiocManager::install("ISAnalytics")

## ----eval=FALSE---------------------------------------------------------------
#  if (!requireNamespace("BiocManager", quietly = TRUE))
#      install.packages("BiocManager")
#  
#  # The following initializes usage of Bioc devel
#  BiocManager::install(version='devel')
#  
#  BiocManager::install("ISAnalytics")

## ----eval=FALSE---------------------------------------------------------------
#  if (!require(devtools)) {
#    install.packages("devtools")
#  }
#  devtools::install_github("calabrialab/ISAnalytics",
#                           ref = "RELEASE_3_15",
#                           dependencies = TRUE,
#                           build_vignettes = TRUE)

## ----eval=FALSE---------------------------------------------------------------
#  if (!require(devtools)) {
#    install.packages("devtools")
#  }
#  devtools::install_github("calabrialab/ISAnalytics",
#                           ref = "master",
#                           dependencies = TRUE,
#                           build_vignettes = TRUE)

## ----OptVerbose, eval=FALSE---------------------------------------------------
#  # DISABLE
#  options("ISAnalytics.verbose" = FALSE)
#  
#  # ENABLE
#  options("ISAnalytics.verbose" = TRUE)
#  

## ----OptWidg, eval=FALSE------------------------------------------------------
#  # DISABLE HTML REPORTS
#  options("ISAnalytics.reports" = FALSE)
#  
#  # ENABLE HTML REPORTS
#  options("ISAnalytics.reports" = TRUE)

