## ---- echo = FALSE, results = "asis"--------------------------------------------------------------------------------------------
options(width = 130)

## ---- echo = FALSE--------------------------------------------------------------------------------------------------------------
htmltools::img(src = knitr::image_uri("functionRules.png"), 
               style = 'margin-left: auto;margin-right: auto')

## ---- eval = FALSE--------------------------------------------------------------------------------------------------------------
#  setGeneric("kNNinterface", function(measurementsTrain, ...) standardGeneric("kNNinterface"))
#  
#  setMethod("kNNinterface", "DataFrame", function(measurementsTrain, classesTrain, measurementsTest, ..., verbose = 3)
#  {
#    splitDataset <- .splitDataAndOutcomes(measurementsTrain, classesTrain)
#    trainingMatrix <- as.matrix(splitDataset[["measurements"]])
#    test <- test[, isNumeric, drop = FALSE]
#  
#    if(!requireNamespace("class", quietly = TRUE))
#      stop("The package 'class' could not be found. Please install it.")
#    if(verbose == 3)
#      message("Fitting k Nearest Neighbours classifier to data and predicting classes.")
#  
#    class::knn(as.matrix(measurementsTrain), as.matrix(measurementsTest), measurementsTest, ...)
#  })

## ---- eval = FALSE--------------------------------------------------------------------------------------------------------------
#  setMethod("kNNinterface", "matrix",
#            function(measurementsTrain, classesTrain, measurementsTest, ...)
#  {
#    kNNinterface(DataFrame(measurementsTrain, check.names = FALSE),
#                 classesTrain,
#                 DataFrame(measurementsTest, check.names = FALSE), ...)
#  })
#  
#  setMethod("kNNinterface", "MultiAssayExperiment",
#  function(measurementsTrain, measurementsTest, targets = names(measurementsTrain), classesTrain, ...)
#  {
#    tablesAndClasses <- .MAEtoWideTable(measurementsTrain, targets, classesTrain)
#    trainingTable <- tablesAndClasses[["dataTable"]]
#    classes <- tablesAndClasses[["outcomes"]]
#    testingTable <- .MAEtoWideTable(measurementsTest, targets)
#  
#    .checkVariablesAndSame(trainingTable, testingTable)
#    kNNinterface(trainingTable, classes, testingTable, ...)
#  })

## ---- message = FALSE-----------------------------------------------------------------------------------------------------------
classes <- factor(rep(c("Healthy", "Disease"), each = 5), levels = c("Healthy", "Disease"))
measurements <- matrix(c(rnorm(50, 10), rnorm(50, 5)), ncol = 10)
colnames(measurements) <- paste("Sample", 1:10)
rownames(measurements) <- paste("mRNA", 1:10)

library(ClassifyR)
knnParams <- ModellingParams(selectParams = NULL,
                             trainParams = TrainParams(kNNinterface),
                             predictParams = NULL)
CVparams <- CrossValParams("Leave-k-Out", leave = 1)
classified <- runTests(measurements, classes, CVparams, knnParams)
classified
cbind(predictions(classified), known = actualOutcomes(classified))

