/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import java.sql.SQLWarning;
import java.sql.Timestamp;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.i18n.MessageService;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.ResultSet;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.conn.StatementContext;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.sql.execute.ExecutionFactory;
import org.apache.derby.iapi.sql.execute.NoPutResultSet;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.iapi.types.DataValueDescriptor;

abstract class BasicNoPutResultSetImpl
implements NoPutResultSet {
    protected boolean isOpen;
    protected boolean finished;
    protected ExecRow currentRow;
    protected boolean isTopResultSet;
    private SQLWarning warnings;
    public int numOpens;
    public int rowsSeen;
    public int rowsFiltered;
    protected long startExecutionTime;
    protected long endExecutionTime;
    public long beginTime;
    public long constructorTime;
    public long openTime;
    public long nextTime;
    public long closeTime;
    public double optimizerEstimatedRowCount;
    public double optimizerEstimatedCost;
    private StatementContext statementContext;
    public NoPutResultSet[] subqueryTrackingArray;
    ExecRow compactRow;
    protected final Activation activation;
    private final boolean statisticsTimingOn;
    private transient TransactionController tc;
    private int[] baseColumnMap;

    BasicNoPutResultSetImpl(Activation activation, double d, double d2) {
        this.activation = activation;
        this.statisticsTimingOn = this.getLanguageConnectionContext().getStatisticsTiming();
        if (this.statisticsTimingOn) {
            this.beginTime = this.startExecutionTime = this.getCurrentTimeMillis();
        }
        this.optimizerEstimatedRowCount = d;
        this.optimizerEstimatedCost = d2;
    }

    protected final void recordConstructorTime() {
        if (this.statisticsTimingOn) {
            this.constructorTime = this.getElapsedMillis(this.beginTime);
        }
    }

    public final Activation getActivation() {
        return this.activation;
    }

    public void reopenCore() throws StandardException {
        this.close();
        this.openCore();
    }

    public abstract ExecRow getNextRowCore() throws StandardException;

    public int getPointOfAttachment() {
        return -1;
    }

    public void markAsTopResultSet() {
        this.isTopResultSet = true;
    }

    public int getScanIsolationLevel() {
        return 0;
    }

    public double getEstimatedRowCount() {
        return this.optimizerEstimatedRowCount;
    }

    public boolean requiresRelocking() {
        return false;
    }

    public final void open() throws StandardException {
        this.finished = false;
        this.attachStatementContext();
        try {
            this.openCore();
        }
        catch (StandardException standardException) {
            this.activation.checkStatementValidity();
            throw standardException;
        }
        this.activation.checkStatementValidity();
    }

    public ExecRow getAbsoluteRow(int n) throws StandardException {
        if (!this.isOpen) {
            throw StandardException.newException("XCL16.S.0", "absolute");
        }
        this.attachStatementContext();
        return null;
    }

    public ExecRow getRelativeRow(int n) throws StandardException {
        if (!this.isOpen) {
            throw StandardException.newException("XCL16.S.0", "relative");
        }
        this.attachStatementContext();
        return null;
    }

    public ExecRow setBeforeFirstRow() throws StandardException {
        if (!this.isOpen) {
            throw StandardException.newException("XCL16.S.0", "first");
        }
        return null;
    }

    public boolean checkRowPosition(int n) throws StandardException {
        return false;
    }

    public int getRowNumber() {
        return 0;
    }

    public ExecRow getFirstRow() throws StandardException {
        if (!this.isOpen) {
            throw StandardException.newException("XCL16.S.0", "first");
        }
        this.attachStatementContext();
        return null;
    }

    public final ExecRow getNextRow() throws StandardException {
        if (!this.isOpen) {
            throw StandardException.newException("XCL16.S.0", "next");
        }
        this.attachStatementContext();
        return this.getNextRowCore();
    }

    public ExecRow getPreviousRow() throws StandardException {
        if (!this.isOpen) {
            throw StandardException.newException("XCL16.S.0", "previous");
        }
        this.attachStatementContext();
        return null;
    }

    public ExecRow getLastRow() throws StandardException {
        if (!this.isOpen) {
            throw StandardException.newException("XCL16.S.0", "last");
        }
        this.attachStatementContext();
        return null;
    }

    public ExecRow setAfterLastRow() throws StandardException {
        if (!this.isOpen) {
            throw StandardException.newException("XCL16.S.0", "last");
        }
        return null;
    }

    public boolean returnsRows() {
        return true;
    }

    public final int modifiedRowCount() {
        return 0;
    }

    public void cleanUp() throws StandardException {
        if (this.isOpen) {
            this.close();
        }
    }

    public boolean isClosed() {
        return !this.isOpen;
    }

    public void finish() throws StandardException {
        this.finishAndRTS();
    }

    protected final void finishAndRTS() throws StandardException {
        if (!this.finished) {
            if (!this.isClosed()) {
                this.close();
            }
            this.finished = true;
            if (this.isTopResultSet && this.activation.isSingleExecution()) {
                this.activation.close();
            }
        }
    }

    public long getExecuteTime() {
        return this.getTimeSpent(1);
    }

    public Timestamp getBeginExecutionTimestamp() {
        if (this.startExecutionTime == 0L) {
            return null;
        }
        return new Timestamp(this.startExecutionTime);
    }

    public Timestamp getEndExecutionTimestamp() {
        if (this.endExecutionTime == 0L) {
            return null;
        }
        return new Timestamp(this.endExecutionTime);
    }

    public final NoPutResultSet[] getSubqueryTrackingArray(int n) {
        if (this.subqueryTrackingArray == null) {
            this.subqueryTrackingArray = new NoPutResultSet[n];
        }
        return this.subqueryTrackingArray;
    }

    protected final long getCurrentTimeMillis() {
        if (this.statisticsTimingOn) {
            return System.currentTimeMillis();
        }
        return 0L;
    }

    public ResultSet getAutoGeneratedKeysResultset() {
        return null;
    }

    protected final long getElapsedMillis(long l) {
        if (this.statisticsTimingOn) {
            return System.currentTimeMillis() - l;
        }
        return 0L;
    }

    protected final String dumpTimeStats(String string, String string2) {
        return string + MessageService.getTextMessage("42Z30.U") + " " + this.getTimeSpent(0) + "\n" + string + MessageService.getTextMessage("42Z31.U") + " " + this.getTimeSpent(1) + "\n" + string + MessageService.getTextMessage("42Z32.U") + "\n" + string2 + MessageService.getTextMessage("42Z33.U") + " " + this.constructorTime + "\n" + string2 + MessageService.getTextMessage("42Z34.U") + " " + this.openTime + "\n" + string2 + MessageService.getTextMessage("42Z35.U") + " " + this.nextTime + "\n" + string2 + MessageService.getTextMessage("42Z36.U") + " " + this.closeTime;
    }

    protected void attachStatementContext() throws StandardException {
        if (this.isTopResultSet) {
            if (this.statementContext == null || !this.statementContext.onStack()) {
                this.statementContext = this.getLanguageConnectionContext().getStatementContext();
            }
            this.statementContext.setTopResultSet(this, this.subqueryTrackingArray);
            if (this.subqueryTrackingArray == null) {
                this.subqueryTrackingArray = this.statementContext.getSubqueryTrackingArray();
            }
            this.statementContext.setActivation(this.activation);
        }
    }

    protected final LanguageConnectionContext getLanguageConnectionContext() {
        return this.getActivation().getLanguageConnectionContext();
    }

    public int resultSetNumber() {
        return 0;
    }

    final ExecutionFactory getExecutionFactory() {
        return this.activation.getExecutionFactory();
    }

    final TransactionController getTransactionController() {
        if (this.tc == null) {
            this.tc = this.getLanguageConnectionContext().getTransactionExecute();
        }
        return this.tc;
    }

    protected ExecRow getCompactRow(ExecRow execRow, FormatableBitSet formatableBitSet, boolean bl) throws StandardException {
        int n = execRow.nColumns();
        if (formatableBitSet == null) {
            this.compactRow = execRow;
            this.baseColumnMap = new int[n];
            for (int i = 0; i < this.baseColumnMap.length; ++i) {
                this.baseColumnMap[i] = i;
            }
        } else {
            int n2 = formatableBitSet.getNumBitsSet();
            this.baseColumnMap = new int[n2];
            if (this.compactRow == null) {
                ExecutionFactory executionFactory = this.getLanguageConnectionContext().getLanguageConnectionFactory().getExecutionFactory();
                this.compactRow = bl ? executionFactory.getIndexableRow(n2) : executionFactory.getValueRow(n2);
            }
            int n3 = 0;
            int n4 = formatableBitSet.anySetBit();
            while (n4 != -1 && n4 < n) {
                DataValueDescriptor dataValueDescriptor = execRow.getColumn(n4 + 1);
                if (dataValueDescriptor != null) {
                    this.compactRow.setColumn(n3 + 1, dataValueDescriptor);
                }
                this.baseColumnMap[n3] = n4;
                ++n3;
                n4 = formatableBitSet.anySetBit(n4);
            }
        }
        return this.compactRow;
    }

    protected ExecRow setCompactRow(ExecRow execRow, ExecRow execRow2) {
        ExecRow execRow3;
        if (this.baseColumnMap == null) {
            execRow3 = execRow;
        } else {
            execRow3 = execRow2;
            this.setCompatRow(execRow2, execRow.getRowArray());
        }
        return execRow3;
    }

    protected final void setCompatRow(ExecRow execRow, DataValueDescriptor[] dataValueDescriptorArray) {
        DataValueDescriptor[] dataValueDescriptorArray2 = execRow.getRowArray();
        int[] nArray = this.baseColumnMap;
        for (int i = 0; i < nArray.length; ++i) {
            dataValueDescriptorArray2[i] = dataValueDescriptorArray[nArray[i]];
        }
    }

    public boolean isForUpdate() {
        return false;
    }

    public void checkCancellationFlag() throws StandardException {
        StatementContext statementContext = this.getLanguageConnectionContext().getStatementContext();
        if (statementContext == null) {
            return;
        }
        if (statementContext.isCancelled()) {
            throw StandardException.newException("XCL52.S");
        }
    }

    protected final void addWarning(SQLWarning sQLWarning) {
        ResultSet resultSet;
        if (this.isTopResultSet) {
            if (this.warnings == null) {
                this.warnings = sQLWarning;
            } else {
                this.warnings.setNextWarning(sQLWarning);
            }
            return;
        }
        if (this.activation != null && (resultSet = this.activation.getResultSet()) instanceof BasicNoPutResultSetImpl) {
            ((BasicNoPutResultSetImpl)resultSet).addWarning(sQLWarning);
        }
    }

    public final SQLWarning getWarnings() {
        SQLWarning sQLWarning = this.warnings;
        this.warnings = null;
        return sQLWarning;
    }
}

