/*
 * Decompiled with CFR 0.152.
 */
package edu.msu.cme.rdp.readseq.writers;

import edu.msu.cme.rdp.readseq.readers.Sequence;
import edu.msu.cme.rdp.readseq.writers.SequenceWriter;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;

public class FastaWriter
implements SequenceWriter {
    private PrintStream out;

    public FastaWriter(OutputStream is) {
        this(new PrintStream(is));
    }

    public FastaWriter(String s) throws IOException {
        this(new File(s));
    }

    public FastaWriter(File f) throws IOException {
        this(new PrintStream(f));
    }

    public FastaWriter(PrintStream pw) {
        this.out = pw;
    }

    public void close() {
        this.out.close();
    }

    public void writeSeq(Sequence s) {
        this.writeSeq(s.getSeqName(), s.getDesc(), s.getSeqString());
    }

    public void writeSeq(String seqid, String desc, String seqString) {
        this.out.println(">" + seqid + "  " + desc);
        this.out.println(seqString);
    }

    public void writeSeq(String seqid, String seqString) throws IOException {
        this.writeSeq(seqid, "", seqString);
    }

    public void writeRawQual(String seqid, byte[] qualSeq) {
        this.writeRawQual(seqid, "", qualSeq);
    }

    public void writeRawQual(String seqid, String desc, byte[] qualSeq) {
        StringBuilder qualString = new StringBuilder();
        for (byte b : qualSeq) {
            qualString.append(b).append("  ");
        }
        this.writeSeq(seqid, desc, qualString.toString());
    }
}

