/*
 * Decompiled with CFR 0.152.
 */
package edu.msu.cme.rdp.multicompare;

import edu.msu.cme.rdp.classifier.ClassificationResult;
import edu.msu.cme.rdp.classifier.RankAssignment;
import edu.msu.cme.rdp.classifier.utils.ClassifierSequence;
import edu.msu.cme.rdp.readseq.readers.SeqReader;
import edu.msu.cme.rdp.readseq.readers.Sequence;
import edu.msu.cme.rdp.readseq.readers.SequenceReader;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MCSample {
    private String sampleName;
    private SeqReader parser = null;
    private List<ClassifierSequence> sampleSeqs = new ArrayList<ClassifierSequence>();
    private Map<String, int[]> bootstrapCountTable = new HashMap<String, int[]>();
    private Map<String, Integer> dupCountTable = new HashMap<String, Integer>();
    private int seqIndex = 0;

    public MCSample(SeqReader reader, String name) {
        this.sampleName = name;
        this.parser = reader;
    }

    public MCSample(File f) throws IOException {
        this(f, f.getName());
    }

    public MCSample(String sampleName) {
        this.sampleName = sampleName;
    }

    public MCSample(String sampleName, File dupCountFile) throws IOException {
        this.sampleName = sampleName;
        this.setDupCountFile(dupCountFile);
    }

    public MCSample(List<ClassifierSequence> sampleSeqs, String sampleName) {
        this.sampleSeqs = sampleSeqs;
        this.sampleName = sampleName;
    }

    public MCSample(List<ClassifierSequence> sampleSeqs, String sampleName, File dupCountFile) throws IOException {
        this.sampleSeqs = sampleSeqs;
        this.sampleName = sampleName;
        this.setDupCountFile(dupCountFile);
    }

    public MCSample(File in, String sampleName) throws IOException {
        this.parser = new SequenceReader(in);
        this.sampleName = sampleName;
    }

    public MCSample(File sampleFile, File dupCountFile) throws IOException {
        this(sampleFile);
        this.setDupCountFile(dupCountFile);
    }

    public String getSampleName() {
        return this.sampleName;
    }

    public ClassifierSequence getNextSeq() throws IOException {
        if (this.parser != null) {
            Sequence seq = this.parser.readNextSequence();
            if (seq == null) {
                return null;
            }
            return new ClassifierSequence(seq);
        }
        if (this.seqIndex < this.sampleSeqs.size()) {
            return this.sampleSeqs.get(this.seqIndex++);
        }
        return null;
    }

    private void setDupCountFile(File dupCountFile) throws IOException {
        if (dupCountFile == null) {
            return;
        }
        BufferedReader reader = new BufferedReader(new FileReader(dupCountFile));
        String line = "";
        while ((line = reader.readLine()) != null) {
            String[] keys = line.split("\\s+");
            String[] dupSeqList = keys[1].split(",");
            this.dupCountTable.put(dupSeqList[0], new Integer(dupSeqList.length));
        }
        reader.close();
    }

    public int getDupCount(String seqName) {
        Integer dup = this.dupCountTable.get(seqName);
        return dup == null ? 1 : dup;
    }

    public void addRankCount(ClassificationResult result) {
        int count = this.getDupCount(result.getSequence().getSeqName());
        for (RankAssignment assignment : result.getAssignments()) {
            int bootstrapIndex;
            int[] bootstrapCountArr = this.bootstrapCountTable.get(assignment.getRank());
            if (bootstrapCountArr == null) {
                bootstrapCountArr = new int[11];
                this.bootstrapCountTable.put(assignment.getRank(), bootstrapCountArr);
            }
            int n = bootstrapIndex = MCSample.getBootstrapIndex(assignment.getConfidence());
            bootstrapCountArr[n] = bootstrapCountArr[n] + count;
        }
    }

    public static int getBootstrapIndex(double d) {
        return (int)Math.ceil(d * 10.0);
    }

    public Map<String, int[]> getBootstrapCountTable() {
        return this.bootstrapCountTable;
    }

    public String toString() {
        return this.sampleName;
    }
}

