/*
 * Decompiled with CFR 0.152.
 */
package psidev.psi.tools.xxindex.index;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ListIterator;
import java.util.Set;
import java.util.Stack;
import org.apache.commons.io.input.CountingInputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import psidev.psi.tools.xxindex.index.ByteBuffer;
import psidev.psi.tools.xxindex.index.LineNumberedByteRange;
import psidev.psi.tools.xxindex.index.StandardXpathIndex;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlXpathIndexer {
    private static final Log log = LogFactory.getLog(XmlXpathIndexer.class);

    public static StandardXpathIndex buildIndex(InputStream is) throws IOException {
        return XmlXpathIndexer.buildIndex(is, null);
    }

    public static StandardXpathIndex buildIndex(InputStream is, Set<String> aXpathInclusionSet) throws IOException {
        return XmlXpathIndexer.buildIndex(is, aXpathInclusionSet, true);
    }

    public static StandardXpathIndex buildIndex(InputStream is, Set<String> aXpathInclusionSet, boolean recordLineNumber) throws IOException {
        return XmlXpathIndexer.buildIndex(is, aXpathInclusionSet, recordLineNumber, true);
    }

    public static StandardXpathIndex buildIndex(InputStream is, Set<String> aXpathInclusionSet, boolean recordLineNumber, boolean ignoreNSPrefix) throws IOException {
        BufferedInputStream bis = new BufferedInputStream(is);
        CountingInputStream cis = new CountingInputStream(bis);
        StandardXpathIndex index = new StandardXpathIndex(aXpathInclusionSet);
        if (log.isDebugEnabled()) {
            log.debug("Indexing " + (recordLineNumber ? "and" : "without") + " keeping track of line numbers.");
        }
        index.setRecordLineNumber(recordLineNumber);
        Stack<TmpIndexElement> stack = new Stack<TmpIndexElement>();
        byte[] buf = new byte[1];
        byte read = 32;
        long startPos = 0L;
        boolean recording = false;
        boolean closingTag = false;
        boolean startTag = false;
        boolean inQuote = false;
        ByteBuffer bb = new ByteBuffer();
        long lineNum = 1L;
        while (XmlXpathIndexer.nextByte(cis, buf) != -1) {
            byte oldRead = read;
            read = buf[0];
            if (read == 10) {
                ++lineNum;
            }
            if (oldRead == 13 && read != 10) {
                ++lineNum;
            }
            if (read == 60 && !inQuote) {
                startPos = cis.getByteCount() - 1L;
                oldRead = read;
                XmlXpathIndexer.nextByte(cis, buf);
                read = buf[0];
                if (read == 33 || read == 63) {
                    int skippedLines = XmlXpathIndexer.skipSpecialSection(cis, buf);
                    lineNum += (long)skippedLines;
                    startPos = -1L;
                } else if (read == 47) {
                    closingTag = true;
                    recording = true;
                } else {
                    startTag = true;
                    recording = true;
                }
            }
            if (read == 34 && recording) {
                boolean bl = inQuote = !inQuote;
            }
            if (read == 62 && !inQuote) {
                long stopPos = cis.getByteCount();
                if (startTag) {
                    TmpIndexElement element;
                    String tagName;
                    if (oldRead == 47) {
                        tagName = XmlXpathIndexer.getTagName(bb, ignoreNSPrefix);
                        bb.clear();
                        element = new TmpIndexElement(tagName, startPos, stopPos, lineNum);
                        stack.push(element);
                        String xpath = XmlXpathIndexer.createPathFromStack(stack);
                        stack.pop();
                        index.put(xpath, element.getStart(), element.getStop(), element.getLineNumber());
                    } else {
                        tagName = XmlXpathIndexer.getTagName(bb, ignoreNSPrefix);
                        bb.clear();
                        element = new TmpIndexElement(tagName, startPos, -1L, lineNum);
                        stack.push(element);
                    }
                    recording = false;
                    startTag = false;
                    bb.clear();
                } else if (closingTag) {
                    String tagName = XmlXpathIndexer.getTagName(bb, ignoreNSPrefix);
                    bb.clear();
                    recording = false;
                    closingTag = false;
                    String xpath = XmlXpathIndexer.createPathFromStack(stack);
                    TmpIndexElement element = stack.pop();
                    if (!element.getName().equalsIgnoreCase(tagName)) {
                        StringBuilder sb = new StringBuilder(256);
                        sb.append("Tag name mismatch! Found '").append(tagName);
                        sb.append("' but '").append(element.getName()).append("' on stack.");
                        sb.append("\n State of the Stack:\n");
                        ListIterator iter = stack.listIterator();
                        while (iter.hasNext()) {
                            TmpIndexElement tmpIndexElement = (TmpIndexElement)iter.next();
                            sb.append("[");
                            sb.append(tmpIndexElement.getName());
                            sb.append(" at line ");
                            sb.append(tmpIndexElement.getLineNumber());
                            sb.append("]\n");
                        }
                        log.error(sb.toString());
                        System.out.println(sb.toString());
                        System.out.println("line number" + lineNum);
                        throw new IllegalStateException("Internal stack of XML tags was corrupted!");
                    }
                    element.setStop(stopPos);
                    index.put(xpath, element.getStart(), element.getStop(), element.getLineNumber());
                }
            }
            if (!recording) continue;
            bb.append(read);
        }
        cis.close();
        is.close();
        return index;
    }

    private static int skipSpecialSection(CountingInputStream cis, byte[] buf) throws IOException {
        int skippedLines = 0;
        boolean possibleCDATA = false;
        boolean cDATA = false;
        boolean possibleComment = false;
        boolean comment = false;
        int read = 33;
        int oldRead = 60;
        while (XmlXpathIndexer.nextByte(cis, buf) != -1) {
            int veryOldRead = oldRead;
            oldRead = read;
            read = buf[0];
            if (read == 10) {
                ++skippedLines;
            }
            if (oldRead == 13 && read != 10) {
                ++skippedLines;
            }
            if (read == 91 && oldRead == 33 && veryOldRead == 60) {
                possibleCDATA = true;
            }
            if (read == 68 && oldRead == 67 && veryOldRead == 91 && possibleCDATA) {
                cDATA = true;
            }
            if (read == 45 && oldRead == 33 && veryOldRead == 60) {
                possibleComment = true;
            }
            if (read == 45 && oldRead == 45 && possibleComment) {
                comment = true;
            }
            if (!(cDATA ? read == 62 && oldRead == 93 && veryOldRead == 93 : (comment ? read == 62 && oldRead == 45 && veryOldRead == 45 : read == 62))) continue;
            break;
        }
        return skippedLines;
    }

    private static int nextByte(CountingInputStream cis, byte[] buf) throws IOException {
        int result = cis.read(buf);
        while (result != -1 && buf[0] == 0) {
            result = cis.read(buf);
        }
        return result;
    }

    protected static String getTagName(ByteBuffer bb, boolean ignoreNSPrefix) {
        ByteBuffer bbTmp = new ByteBuffer();
        for (Byte aByte : bb) {
            if (aByte == 32 || aByte == 9 || aByte == 10 || aByte == 13) break;
            bbTmp.append(aByte);
            if (!ignoreNSPrefix || aByte != 58) continue;
            bbTmp.clear();
        }
        if (bbTmp.get(0) == 47) {
            bbTmp.remove(0);
        }
        if (bbTmp.get(bbTmp.size() - 1) == 47) {
            bbTmp.remove(bbTmp.size() - 1);
        }
        return bbTmp.toString();
    }

    private static String createPathFromStack(Stack<TmpIndexElement> stack) {
        StringBuilder path = new StringBuilder(100);
        path.append("/");
        for (TmpIndexElement element : stack) {
            path.append(element.getName()).append("/");
        }
        return path.substring(0, path.length() - 1);
    }

    private static class TmpIndexElement
    extends LineNumberedByteRange {
        private String name;

        public TmpIndexElement(String name, long start, long stop, long lineNumber) {
            this.setValues(start, stop, lineNumber);
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

