/*
 * Decompiled with CFR 0.152.
 */
package psidev.psi.mi.xml.xmlindex;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import psidev.psi.mi.xml.PsimiXmlReaderException;
import psidev.psi.mi.xml.model.Attribute;
import psidev.psi.mi.xml.model.Availability;
import psidev.psi.mi.xml.model.Entry;
import psidev.psi.mi.xml.model.ExperimentDescription;
import psidev.psi.mi.xml.model.Interaction;
import psidev.psi.mi.xml.model.Interactor;
import psidev.psi.mi.xml.model.Source;
import psidev.psi.mi.xml.xmlindex.ExperimentIterator;
import psidev.psi.mi.xml.xmlindex.IndexElementAdapter;
import psidev.psi.mi.xml.xmlindex.IndexElementUtils;
import psidev.psi.mi.xml.xmlindex.InputStreamRange;
import psidev.psi.mi.xml.xmlindex.InputStreamRangeAdapter;
import psidev.psi.mi.xml.xmlindex.InteractionIterator;
import psidev.psi.mi.xml.xmlindex.InteractorIterator;
import psidev.psi.mi.xml.xmlindex.PsimiXmlExtractor;
import psidev.psi.mi.xml.xmlindex.PsimiXmlFileIndex;
import psidev.psi.mi.xml.xmlindex.PsimiXmlPullParser;
import psidev.psi.tools.xxindex.index.IndexElement;
import psidev.psi.tools.xxindex.index.StandardXpathIndex;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IndexedEntry {
    private final PsimiXmlFileIndex idIndex;
    private final StandardXpathIndex xpathIndex;
    private final IndexElement entryIndexElement;
    private final File xmlDataFile;
    private PsimiXmlPullParser psimiXmlPullParser;

    public IndexedEntry(PsimiXmlFileIndex idIndex, StandardXpathIndex xpathIndex, IndexElement indexElement, File xmlDataFile, PsimiXmlPullParser psimiXmlPullParser) {
        if (idIndex == null) {
            throw new IllegalArgumentException("You must give a non null identifier index");
        }
        if (xpathIndex == null) {
            throw new IllegalArgumentException("You must give a non null xpath index");
        }
        if (indexElement == null) {
            throw new IllegalArgumentException("You must give a non null byte Range");
        }
        if (xmlDataFile == null) {
            throw new IllegalArgumentException("You must give a non null xml data file");
        }
        if (psimiXmlPullParser == null) {
            throw new IllegalArgumentException("You must give a non null psimiXmlPullParser");
        }
        this.idIndex = idIndex;
        this.xpathIndex = xpathIndex;
        this.entryIndexElement = indexElement;
        this.xmlDataFile = xmlDataFile;
        this.psimiXmlPullParser = psimiXmlPullParser;
    }

    public Entry unmarshalledEntry() throws PsimiXmlReaderException {
        return this.psimiXmlPullParser.parseEntry(this.getXmlSnippet(this.entryIndexElement));
    }

    public List<Availability> unmarshallAvailabilityList() throws PsimiXmlReaderException {
        List<IndexElement> ranges = this.xpathIndex.getElements("/entrySet/entry/availabilityList");
        ranges = IndexElementUtils.filterRanges(this.entryIndexElement, ranges);
        switch (ranges.size()) {
            case 0: {
                return Collections.EMPTY_LIST;
            }
            case 1: {
                IndexElement range = ranges.iterator().next();
                return this.psimiXmlPullParser.parseAvailabilityList(this.getXmlSnippet(range));
            }
        }
        throw new IllegalStateException("We were expecting none or a single <availibility> element, found " + ranges.size());
    }

    public Source unmarshallSource() throws PsimiXmlReaderException {
        List<IndexElement> ranges = this.xpathIndex.getElements("/entrySet/entry/source");
        ranges = IndexElementUtils.filterRanges(this.entryIndexElement, ranges);
        switch (ranges.size()) {
            case 1: {
                IndexElement range = ranges.iterator().next();
                return this.psimiXmlPullParser.parseSource(this.getXmlSnippet(range));
            }
        }
        throw new IllegalStateException("We were expecting a single <source> element, found " + ranges.size());
    }

    public long getExperimentLineNumber(int id) {
        InputStreamRange range = this.idIndex.getExperimentPosition(id);
        return range.getLineNumber();
    }

    public List<ExperimentDescription> unmarshallExperimentList() throws PsimiXmlReaderException {
        List<IndexElement> ranges = this.xpathIndex.getElements("/entrySet/entry/experimentList/experimentDescription");
        ranges = IndexElementUtils.filterRanges(this.entryIndexElement, ranges);
        ArrayList<ExperimentDescription> experiments = new ArrayList<ExperimentDescription>(ranges.size());
        PsimiXmlPullParser parser = this.psimiXmlPullParser;
        for (IndexElement range : ranges) {
            experiments.add(parser.parseExperiment(this.getXmlSnippet(range)));
        }
        return experiments;
    }

    public Iterator<ExperimentDescription> unmarshallExperimentIterator() throws PsimiXmlReaderException {
        List<IndexElement> ranges = this.xpathIndex.getElements("/entrySet/entry/experimentList/experimentDescription");
        ranges = IndexElementUtils.filterRanges(this.entryIndexElement, ranges);
        return new ExperimentIterator(this.buildInputStreamRanges(ranges), this.xmlDataFile, this.psimiXmlPullParser);
    }

    public ExperimentDescription unmarshallExperimentById(int id) throws PsimiXmlReaderException {
        ExperimentDescription experiment = null;
        InputStreamRange isr = this.idIndex.getExperimentPosition(id);
        if (isr != null) {
            IndexElementAdapter IndexElement2 = new IndexElementAdapter(isr);
            PsimiXmlPullParser parser = this.psimiXmlPullParser;
            experiment = parser.parseExperiment(this.getXmlSnippet(IndexElement2));
        }
        return experiment;
    }

    public long getInteractorLineNumber(int id) {
        InputStreamRange range = this.idIndex.getInteractorPosition(id);
        return range.getLineNumber();
    }

    public List<Interactor> unmarshallInteractorList() throws PsimiXmlReaderException {
        List<IndexElement> ranges = this.xpathIndex.getElements("/entrySet/entry/interactorList/interactor");
        ranges = IndexElementUtils.filterRanges(this.entryIndexElement, ranges);
        ArrayList<Interactor> interactors = new ArrayList<Interactor>(ranges.size());
        PsimiXmlPullParser parser = this.psimiXmlPullParser;
        for (IndexElement range : ranges) {
            interactors.add(parser.parseInteractor(this.getXmlSnippet(range)));
        }
        return interactors;
    }

    public Iterator<Interactor> unmarshallInteractorIterator() throws PsimiXmlReaderException {
        List<IndexElement> ranges = this.xpathIndex.getElements("/entrySet/entry/interactorList/interactor");
        ranges = IndexElementUtils.filterRanges(this.entryIndexElement, ranges);
        return new InteractorIterator(this.buildInputStreamRanges(ranges), this.xmlDataFile, this.psimiXmlPullParser);
    }

    public Interactor unmarshallInteractorById(int id) throws PsimiXmlReaderException {
        Interactor interactor = null;
        InputStreamRange isr = this.idIndex.getInteractorPosition(id);
        if (isr != null) {
            IndexElementAdapter IndexElement2 = new IndexElementAdapter(isr);
            PsimiXmlPullParser parser = this.psimiXmlPullParser;
            interactor = parser.parseInteractor(this.getXmlSnippet(IndexElement2));
        }
        return interactor;
    }

    public long getInteractionLineNumber(int id) {
        InputStreamRange range = this.idIndex.getInteractionPosition(id);
        return range.getLineNumber();
    }

    public List<Interaction> unmarshallInteractionList() throws PsimiXmlReaderException {
        List<IndexElement> ranges = this.xpathIndex.getElements("/entrySet/entry/interactionList/interaction");
        ranges = IndexElementUtils.filterRanges(this.entryIndexElement, ranges);
        ArrayList<Interaction> interactions = new ArrayList<Interaction>(ranges.size());
        PsimiXmlPullParser parser = this.psimiXmlPullParser;
        for (IndexElement range : ranges) {
            interactions.add(parser.parseInteraction(this.getXmlSnippet(range)));
        }
        return interactions;
    }

    public Interaction unmarshallInteractionById(int id) throws PsimiXmlReaderException {
        Interaction interaction2 = null;
        InputStreamRange isr = this.idIndex.getInteractionPosition(id);
        if (isr != null) {
            IndexElementAdapter indexElement = new IndexElementAdapter(isr);
            PsimiXmlPullParser parser = this.psimiXmlPullParser;
            interaction2 = parser.parseInteraction(this.getXmlSnippet(indexElement));
        }
        return interaction2;
    }

    public Iterator<Interaction> unmarshallInteractionIterator() throws PsimiXmlReaderException {
        List<IndexElement> ranges = this.xpathIndex.getElements("/entrySet/entry/interactionList/interaction");
        ranges = IndexElementUtils.filterRanges(this.entryIndexElement, ranges);
        return new InteractionIterator(this.idIndex, this.buildInputStreamRanges(ranges), this.xmlDataFile, this.psimiXmlPullParser);
    }

    public List<Attribute> unmarshallAttributeList() throws PsimiXmlReaderException {
        List<IndexElement> ranges = this.xpathIndex.getElements("/entrySet/entry/attributeList/attribute");
        ranges = IndexElementUtils.filterRanges(this.entryIndexElement, ranges);
        ArrayList<Attribute> attributes = new ArrayList<Attribute>(ranges.size());
        PsimiXmlPullParser parser = this.psimiXmlPullParser;
        for (IndexElement range : ranges) {
            attributes.add(parser.parseAttribute(this.getXmlSnippet(range)));
        }
        return attributes;
    }

    public long getParticipantLineNumber(int id) {
        InputStreamRange range = this.idIndex.getParticipantPosition(id);
        return range.getLineNumber();
    }

    public long getFeatureLineNumber(int id) {
        InputStreamRange range = this.idIndex.getFeaturePosition(id);
        return range.getLineNumber();
    }

    private FileInputStream getFileInputStream() throws PsimiXmlReaderException {
        try {
            return new FileInputStream(this.xmlDataFile);
        }
        catch (FileNotFoundException e2) {
            throw new PsimiXmlReaderException(e2);
        }
    }

    private InputStream getXmlSnippet(IndexElement indexElement) throws PsimiXmlReaderException {
        InputStreamRange isr = new InputStreamRange();
        isr.setFromPosition(indexElement.getStart());
        isr.setToPosition(indexElement.getStop());
        try {
            return PsimiXmlExtractor.extractXmlSnippet(this.xmlDataFile, isr);
        }
        catch (IOException e2) {
            throw new PsimiXmlReaderException("Error while extract XML snippet: " + indexElement, e2);
        }
    }

    private List<InputStreamRange> buildInputStreamRanges(List<IndexElement> ranges) {
        ArrayList<InputStreamRange> inputStreamRanges = new ArrayList<InputStreamRange>(ranges.size());
        for (IndexElement range : ranges) {
            inputStreamRanges.add(new InputStreamRangeAdapter(range));
        }
        return inputStreamRanges;
    }
}

