/*
 * Decompiled with CFR 0.152.
 */
package org.ivis.layout.cose;

import java.awt.Dimension;
import java.awt.Point;
import org.ivis.layout.LGraphManager;
import org.ivis.layout.cose.CoSELayout;
import org.ivis.layout.fd.FDLayoutNode;
import org.ivis.layout.sbgn.SbgnProcessNode;
import org.ivis.util.IMath;

public class CoSENode
extends FDLayoutNode {
    private CoSENode pred1;
    private CoSENode pred2;
    private CoSENode next;
    private boolean processed;
    public double OKCount = 0.0;
    public SbgnProcessNode.Orientation orient;
    public boolean isOrientationProper;

    public CoSENode(LGraphManager gm, Object vNode) {
        super(gm, vNode);
    }

    public CoSENode(LGraphManager gm, Point loc, Dimension size, Object vNode) {
        super(gm, loc, size, vNode);
    }

    @Override
    public void move() {
        CoSELayout layout = (CoSELayout)this.graphManager.getLayout();
        this.displacementX = layout.coolingFactor * (this.springForceX + this.repulsionForceX + this.gravitationForceX);
        this.displacementY = layout.coolingFactor * (this.springForceY + this.repulsionForceY + this.gravitationForceY);
        if (Math.abs(this.displacementX) > layout.maxNodeDisplacement) {
            this.displacementX = layout.maxNodeDisplacement * (double)IMath.sign(this.displacementX);
        }
        if (Math.abs(this.displacementY) > layout.maxNodeDisplacement) {
            this.displacementY = layout.maxNodeDisplacement * (double)IMath.sign(this.displacementY);
        }
        if (this.child == null) {
            this.moveBy(this.displacementX, this.displacementY);
        } else if (this.child.getNodes().size() == 0) {
            this.moveBy(this.displacementX, this.displacementY);
        } else {
            this.propogateDisplacementToChildren(this.displacementX, this.displacementY);
        }
        layout.totalDisplacement += Math.abs(this.displacementX) + Math.abs(this.displacementY);
        this.springForceX = 0.0;
        this.springForceY = 0.0;
        this.repulsionForceX = 0.0;
        this.repulsionForceY = 0.0;
        this.gravitationForceX = 0.0;
        this.gravitationForceY = 0.0;
        this.displacementX = 0.0;
        this.displacementY = 0.0;
    }

    public void propogateDisplacementToChildren(double dX, double dY) {
        for (CoSENode lNode : this.getChild().getNodes()) {
            if (lNode.getChild() == null) {
                lNode.moveBy(dX, dY);
                lNode.displacementX += dX;
                lNode.displacementY += dY;
                continue;
            }
            lNode.propogateDisplacementToChildren(dX, dY);
        }
    }

    public void setPred1(CoSENode pred1) {
        this.pred1 = pred1;
    }

    public CoSENode getPred1() {
        return this.pred1;
    }

    public void setPred2(CoSENode pred2) {
        this.pred2 = pred2;
    }

    public CoSENode getPred2() {
        return this.pred2;
    }

    public void setNext(CoSENode next) {
        this.next = next;
    }

    public CoSENode getNext() {
        return this.next;
    }

    public void setProcessed(boolean processed) {
        this.processed = processed;
    }

    public boolean isProcessed() {
        return this.processed;
    }
}

