/*
 * Decompiled with CFR 0.152.
 */
package org.ivis.layout.cise;

import org.ivis.layout.cise.CiSENode;

public class CiSEOnCircleNodePair
implements Comparable<CiSEOnCircleNodePair> {
    private CiSENode firstNode;
    private CiSENode secondNode;
    private double discrepancy;
    private boolean inSameDirection;

    public CiSEOnCircleNodePair(CiSENode first, CiSENode second, double displacement, boolean inSameDirection) {
        assert (first.getOnCircleNodeExt() != null && second.getOnCircleNodeExt() != null);
        this.firstNode = first;
        this.secondNode = second;
        this.discrepancy = displacement;
        this.inSameDirection = inSameDirection;
    }

    public double getDiscrepancy() {
        return this.discrepancy;
    }

    public boolean inSameDirection() {
        return this.inSameDirection;
    }

    public CiSENode getFirstNode() {
        return this.firstNode;
    }

    public CiSENode getSecondNode() {
        return this.secondNode;
    }

    @Override
    public int compareTo(CiSEOnCircleNodePair other) {
        return (int)(this.getDiscrepancy() - other.getDiscrepancy());
    }

    public void swap() {
        this.getFirstNode().getOnCircleNodeExt().swapWith(this.getSecondNode().getOnCircleNodeExt());
    }

    public boolean equals(Object other) {
        boolean result = other instanceof CiSEOnCircleNodePair;
        if (result) {
            CiSEOnCircleNodePair pair = (CiSEOnCircleNodePair)other;
            result &= this.firstNode.equals(pair.getFirstNode()) && this.secondNode.equals(pair.getSecondNode()) || this.secondNode.equals(pair.getFirstNode()) && this.firstNode.equals(pair.getSecondNode());
        }
        return result;
    }

    public int hashCode() {
        return this.firstNode.hashCode() + this.secondNode.hashCode();
    }

    public String toString() {
        String result = "Swap: " + this.getFirstNode().label;
        result = result + "<->" + this.getSecondNode().label;
        result = result + ", " + this.getDiscrepancy();
        return result;
    }
}

