/*
 * Decompiled with CFR 0.152.
 */
package org.ivis.layout.cise;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.ivis.layout.LNode;
import org.ivis.layout.cise.CiSECircle;
import org.ivis.layout.cise.CiSEEdge;
import org.ivis.layout.cise.CiSENode;
import org.ivis.util.IGeometry;
import org.ivis.util.PointD;

public class CiSEOnCircleNodeExt {
    private CiSENode ciseNode;
    private List<CiSEEdge> intraClusterEdges = null;
    private List<CiSEEdge> interClusterEdges = null;
    private double angle = -1.0;
    private int orderIndex = -1;
    private boolean canSwapWithNext;
    private boolean canSwapWithPrevious;
    private double displacementForSwap;

    public CiSEOnCircleNodeExt(CiSENode ciseNode) {
        this.ciseNode = ciseNode;
    }

    public CiSENode getCiSENode() {
        return this.ciseNode;
    }

    public double getAngle() {
        return this.angle;
    }

    public void setAngle(double angle) {
        this.angle = angle % (Math.PI * 2);
        if (this.angle < 0.0) {
            this.angle += Math.PI * 2;
        }
    }

    public int getIndex() {
        return this.orderIndex;
    }

    public void setIndex(int index) {
        this.orderIndex = index;
    }

    public char getCharCode() {
        assert (this.orderIndex >= 0);
        char charCode = this.orderIndex < 26 ? (char)(97 + this.orderIndex) : (this.orderIndex < 52 ? (char)(65 + this.orderIndex - 26) : (char)'?');
        return charCode;
    }

    public CiSENode getNextNode() {
        int nextNodeIndex = this.orderIndex + 1;
        CiSECircle circle = (CiSECircle)this.ciseNode.getOwner();
        int totalNodes = circle.getOnCircleNodes().size();
        if (nextNodeIndex == totalNodes) {
            nextNodeIndex = 0;
        }
        return circle.getOnCircleNodes().get(nextNodeIndex);
    }

    public CiSENode getPrevNode() {
        CiSECircle circle = (CiSECircle)this.ciseNode.getOwner();
        int nextNodeIndex = this.orderIndex - 1;
        if (nextNodeIndex == -1) {
            nextNodeIndex = circle.getOnCircleNodes().size() - 1;
        }
        return circle.getOnCircleNodes().get(nextNodeIndex);
    }

    public CiSEOnCircleNodeExt getNextNodeExt() {
        return this.getNextNode().getOnCircleNodeExt();
    }

    public CiSEOnCircleNodeExt getPrevNodeExt() {
        return this.getPrevNode().getOnCircleNodeExt();
    }

    public boolean canSwapWithNext() {
        return this.canSwapWithNext;
    }

    public boolean canSwapWithPrev() {
        return this.canSwapWithPrevious;
    }

    public double getDisplacementForSwap() {
        return this.displacementForSwap;
    }

    public void setDisplacementForSwap(double displacementForSwap) {
        this.displacementForSwap = displacementForSwap;
    }

    public void addDisplacementForSwap(double displacementIncrForSwap) {
        this.displacementForSwap = displacementIncrForSwap;
    }

    public void updatePosition() {
        CiSECircle ownerGraph = (CiSECircle)this.ciseNode.getOwner();
        LNode parentNode = ownerGraph.getParent();
        double parentX = parentNode.getCenterX();
        double parentY = parentNode.getCenterY();
        double xDifference = ownerGraph.getRadius() * Math.cos(this.angle);
        double yDifference = ownerGraph.getRadius() * Math.sin(this.angle);
        this.ciseNode.setCenter(parentX + xDifference, parentY + yDifference);
    }

    public int getCircDistWithTheNode(CiSEOnCircleNodeExt refNode) {
        int otherIndex = refNode.getIndex();
        if (otherIndex == -1 || this.getIndex() == -1) {
            return -1;
        }
        int diff = this.getIndex() - otherIndex;
        if (diff < 0) {
            diff += ((CiSECircle)this.ciseNode.getOwner()).getOnCircleNodes().size();
        }
        return diff;
    }

    public int calculateTotalCrossing() {
        Iterator<CiSEEdge> iter = this.getIntraClusterEdges().iterator();
        int count = 0;
        ArrayList<CiSEEdge> temp = new ArrayList<CiSEEdge>();
        temp.addAll(((CiSECircle)this.ciseNode.getOwner()).getIntraClusterEdges());
        temp.removeAll(this.ciseNode.getEdges());
        while (iter.hasNext()) {
            CiSEEdge edge = iter.next();
            count += edge.calculateTotalCrossingWithList(temp);
        }
        return count;
    }

    public void updateSwappingConditions() {
        int currentCrossingNumber = this.calculateTotalCrossing();
        int currentNodeIndex = this.orderIndex;
        CiSEOnCircleNodeExt nextNodeExt = this.getNextNode().getOnCircleNodeExt();
        this.orderIndex = nextNodeExt.getIndex();
        nextNodeExt.setIndex(currentNodeIndex);
        int tempCrossingNumber = this.calculateTotalCrossing();
        this.canSwapWithNext = tempCrossingNumber <= currentCrossingNumber;
        nextNodeExt.setIndex(this.orderIndex);
        this.setIndex(currentNodeIndex);
        CiSEOnCircleNodeExt prevNodeExt = this.getPrevNode().getOnCircleNodeExt();
        this.orderIndex = prevNodeExt.getIndex();
        prevNodeExt.setIndex(currentNodeIndex);
        tempCrossingNumber = this.calculateTotalCrossing();
        this.canSwapWithPrevious = tempCrossingNumber <= currentCrossingNumber;
        prevNodeExt.setIndex(this.orderIndex);
        this.setIndex(currentNodeIndex);
    }

    public void swapWith(CiSEOnCircleNodeExt neighborExt) {
        assert (this.getNextNode().getOnCircleNodeExt() == neighborExt || this.getPrevNode().getOnCircleNodeExt() == neighborExt);
        ((CiSECircle)this.ciseNode.getOwner()).swapNodes(this.ciseNode, neighborExt.ciseNode);
    }

    public int getInterClusterIntersections(CiSEOnCircleNodeExt other) {
        int count = 0;
        List<CiSEEdge> thisInterClusterEdges = this.getInterClusterEdges();
        List<CiSEEdge> otherInterClusterEdges = other.getInterClusterEdges();
        for (CiSEEdge edge : thisInterClusterEdges) {
            PointD point1 = this.ciseNode.getCenter();
            PointD point2 = edge.getOtherEnd(this.ciseNode).getCenter();
            for (CiSEEdge otherEdge : otherInterClusterEdges) {
                boolean result;
                PointD point3 = other.ciseNode.getCenter();
                PointD point4 = otherEdge.getOtherEnd(other.ciseNode).getCenter();
                if (edge.getOtherEnd(this.ciseNode) == otherEdge.getOtherEnd(other.ciseNode) || !(result = IGeometry.doIntersect(point1, point2, point3, point4))) continue;
                ++count;
            }
        }
        return count;
    }

    public List<CiSEEdge> getInterClusterEdges() {
        if (this.interClusterEdges == null) {
            this.interClusterEdges = new ArrayList<CiSEEdge>();
            for (CiSEEdge edge : this.ciseNode.getEdges()) {
                if (edge.isIntraCluster) continue;
                this.interClusterEdges.add(edge);
            }
        }
        return this.interClusterEdges;
    }

    public List<CiSEEdge> getIntraClusterEdges() {
        if (this.intraClusterEdges == null) {
            this.intraClusterEdges = new ArrayList<CiSEEdge>();
            for (CiSEEdge edge : this.ciseNode.getEdges()) {
                if (!edge.isIntraCluster) continue;
                this.intraClusterEdges.add(edge);
            }
        }
        return this.intraClusterEdges;
    }
}

