/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.util;

import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class CompositeIterator<T>
implements Iterator<T> {
    Iterator<? extends Collection<? extends T>> collectionIterator;
    Iterator<? extends T> currentIterator;

    public CompositeIterator(Collection<? extends Collection<? extends T>> collections) {
        this.collectionIterator = collections.iterator();
        this.currentIterator = this.getNextSet();
    }

    @Override
    public boolean hasNext() {
        if (this.currentIterator == null) {
            return false;
        }
        if (!this.currentIterator.hasNext()) {
            this.currentIterator = this.getNextSet();
            return this.hasNext();
        }
        return true;
    }

    @Override
    public T next() {
        if (this.hasNext()) {
            return this.currentIterator.next();
        }
        throw new NoSuchElementException();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    private Iterator<? extends T> getNextSet() {
        return this.collectionIterator.hasNext() ? this.collectionIterator.next().iterator() : null;
    }
}

