/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.pattern.util;

import java.util.List;

public class AdjacencyMatrix {
    public String[] names;
    public boolean[][] matrix;

    public AdjacencyMatrix(boolean[][] matrix, List<String> namesList) {
        if (matrix.length != namesList.size()) {
            throw new IllegalArgumentException("Matrix row size not equal to nodes size");
        }
        for (boolean[] m : matrix) {
            if (m.length == namesList.size()) continue;
            throw new IllegalArgumentException("Matrix column size not equal to nodes size");
        }
        this.matrix = matrix;
        this.names = namesList.toArray(new String[namesList.size()]);
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        for (String name : this.names) {
            b.append("\t").append(name);
        }
        int i = 0;
        for (boolean[] m : this.matrix) {
            b.append("\n").append(this.names[i++]);
            for (boolean v : m) {
                b.append(v ? "\tX" : "\t");
            }
        }
        return b.toString();
    }
}

