/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.pattern;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.pattern.Constraint;
import org.biopax.paxtools.pattern.MappedConst;

public class Pattern {
    protected int lastIndex;
    protected Class<? extends BioPAXElement> startingClass;
    protected List<MappedConst> constraints;
    protected Map<String, Integer> labelMap;

    private Pattern(Class<? extends BioPAXElement> startingClass) {
        this.startingClass = startingClass;
        this.labelMap = new HashMap<String, Integer>();
        this.constraints = new ArrayList<MappedConst>();
        this.lastIndex = 0;
    }

    public Pattern(Class<? extends BioPAXElement> startingClass, Constraint firstConstraint, String ... label) {
        this(startingClass, label[0]);
        this.add(firstConstraint, label);
    }

    public Pattern(Class<? extends BioPAXElement> startingClass, String label) {
        this(startingClass);
        this.label(label, 0);
    }

    private void add(Constraint constr, int ... ind) {
        assert (ind.length > 0);
        assert (constr.getVariableSize() == ind.length);
        for (int i = 0; i < (constr.canGenerate() ? ind.length - 1 : ind.length); ++i) {
            assert (ind[i] <= this.lastIndex);
        }
        this.constraints.add(new MappedConst(constr, ind));
        if (constr.canGenerate() && ind[ind.length - 1] > this.lastIndex) {
            if (ind[ind.length - 1] - this.lastIndex > 1) {
                throw new IllegalArgumentException("Generated index too large. Attempting to generate index " + ind[ind.length - 1] + " while last index is " + this.lastIndex);
            }
            ++this.lastIndex;
        }
    }

    public void removeLastConstraint() {
        if (this.constraints.isEmpty()) {
            return;
        }
        MappedConst mc = this.constraints.get(this.constraints.size() - 1);
        this.constraints.remove(mc);
        if (mc.canGenerate() && mc.getInds()[mc.getInds().length - 1] == this.lastIndex) {
            this.setLastIndexToMaxFound();
        }
    }

    private void setLastIndexToMaxFound() {
        int max2 = -1;
        for (MappedConst mc : this.constraints) {
            int[] ind = mc.getInds();
            int last = ind[ind.length - 1];
            if (last <= max2) continue;
            max2 = last;
        }
        this.lastIndex = max2;
    }

    public void optimizeConstraintOrder() {
        HashMap preMap = new HashMap();
        for (MappedConst con1 : this.constraints) {
            preMap.put(con1, new HashSet());
            int m1 = con1.getMaxInd();
            for (MappedConst con2 : this.constraints) {
                int m2;
                if (con1 == con2 || m1 <= (m2 = con2.getMaxInd()) && (m1 != m2 || !con2.canGenerate() || con1.canGenerate())) continue;
                ((Set)preMap.get(con1)).add(con2);
            }
        }
        ArrayList levels = new ArrayList();
        do {
            HashSet<MappedConst> level = new HashSet<MappedConst>();
            for (MappedConst mappedConst : preMap.keySet()) {
                if (!((Set)preMap.get(mappedConst)).isEmpty()) continue;
                level.add(mappedConst);
            }
            for (MappedConst mappedConst : level) {
                preMap.remove(mappedConst);
            }
            for (MappedConst mappedConst : preMap.keySet()) {
                ((Set)preMap.get(mappedConst)).removeAll(level);
            }
            levels.add(level);
        } while (!preMap.isEmpty());
        ArrayList<MappedConst> newList = new ArrayList<MappedConst>(this.constraints.size());
        for (Set set : levels) {
            ArrayList<MappedConst> temp = new ArrayList<MappedConst>(this.constraints);
            temp.retainAll(set);
            newList.addAll(temp);
        }
        this.constraints = newList;
    }

    public void add(Constraint constr, String ... label) {
        this.checkLabels(constr.canGenerate(), label);
        int[] ind = this.convertLabelsToInds(label);
        if (ind.length != constr.getVariableSize()) {
            throw new IllegalArgumentException("Mapped elements do not match the constraint size.");
        }
        this.add(constr, ind);
        if (!this.hasLabel(label[label.length - 1]) && constr.canGenerate()) {
            this.label(label[label.length - 1], this.lastIndex);
        }
    }

    private int[] convertLabelsToInds(String ... label) {
        int[] ind = new int[label.length];
        for (int i = 0; i < label.length; ++i) {
            ind[i] = this.hasLabel(label[i]) ? this.indexOf(label[i]) : this.lastIndex + 1;
        }
        return ind;
    }

    private String[] convertIndsToLabels(int ... ind) {
        String[] label = new String[ind.length];
        for (int i = 0; i < ind.length; ++i) {
            if (!this.hasLabel(ind[i])) {
                throw new IllegalArgumentException("The index " + ind[i] + " does not have a label.");
            }
            label[i] = this.getLabel(ind[i]);
        }
        return label;
    }

    private void checkLabels(boolean forGenerative, String ... label) {
        for (int i = 0; i < (forGenerative ? label.length - 1 : label.length); ++i) {
            if (this.hasLabel(label[i])) continue;
            throw new IllegalArgumentException("Label neither found, nor generated: " + label[i]);
        }
    }

    public void add(Pattern p) {
        if (!this.hasLabel(p.getLabel(0))) {
            throw new IllegalArgumentException("The label of first element of parameter index \"" + p.getLabel(0) + "\" not found in this pattern.");
        }
        for (MappedConst mc : p.getConstraints()) {
            this.add(mc.getConstr(), p.convertIndsToLabels(mc.getInds()));
        }
    }

    private String getLabel(int i) {
        for (String label : this.labelMap.keySet()) {
            if (this.labelMap.get(label) != i) continue;
            return label;
        }
        return null;
    }

    public void insertPointConstraint(Constraint con, int ... ind) {
        assert (con.getVariableSize() == 1);
        block0: for (int i : ind) {
            for (int j = 0; j < this.constraints.size(); ++j) {
                int[] index = this.constraints.get(j).getInds();
                if (index[index.length - 1] != i) continue;
                this.constraints.add(j + 1, new MappedConst(con, i));
                continue block0;
            }
        }
    }

    public List<MappedConst> getConstraints() {
        return this.constraints;
    }

    public int size() {
        return this.lastIndex + 1;
    }

    public Class<? extends BioPAXElement> getStartingClass() {
        return this.startingClass;
    }

    public void label(String labelText, int index) {
        if (this.labelMap.containsKey(labelText)) {
            throw new IllegalArgumentException("Label \"" + labelText + "\" already exists.");
        }
        if (this.labelMap.containsValue(index)) {
            throw new IllegalArgumentException("Index \"" + index + "\" already has a label.");
        }
        this.labelMap.put(labelText, index);
    }

    public boolean hasLabel(String labelText) {
        return this.labelMap.containsKey(labelText);
    }

    public boolean hasLabel(int index) {
        return this.labelMap.containsValue(index);
    }

    public int indexOf(String labelText) {
        if (!this.labelMap.containsKey(labelText)) {
            throw new IllegalArgumentException("The label \"" + labelText + "\" is absent in pattern.");
        }
        return this.labelMap.get(labelText);
    }

    public void updateLabel(String oldLabel, String newLabel) {
        if (this.hasLabel(newLabel)) {
            throw new IllegalArgumentException("The label \"" + newLabel + "\" already exists.");
        }
        int i = this.indexOf(oldLabel);
        this.labelMap.remove(oldLabel);
        this.labelMap.put(newLabel, i);
    }
}

