/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.impl.level3;

import java.util.Set;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.Transient;
import org.biopax.paxtools.impl.level3.EvidenceImpl;
import org.biopax.paxtools.impl.level3.L3ElementImpl;
import org.biopax.paxtools.impl.level3.PathwayImpl;
import org.biopax.paxtools.impl.level3.ProcessImpl;
import org.biopax.paxtools.model.level3.Evidence;
import org.biopax.paxtools.model.level3.Pathway;
import org.biopax.paxtools.model.level3.PathwayStep;
import org.biopax.paxtools.model.level3.Process;
import org.biopax.paxtools.util.BPCollections;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Proxy;
import org.hibernate.search.annotations.Indexed;

@Entity
@Proxy(proxyClass=PathwayStep.class)
@Indexed
@DynamicUpdate
@DynamicInsert
@Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
public class PathwayStepImpl
extends L3ElementImpl
implements PathwayStep {
    private Set<Process> stepProcess;
    private Set<PathwayStep> nextStep = BPCollections.I.createSafeSet();
    private Set<PathwayStep> nextStepOf = BPCollections.I.createSafeSet();
    private Pathway pathwayOrderOf;
    private Set<Evidence> evidence;

    public PathwayStepImpl() {
        this.stepProcess = BPCollections.I.createSafeSet();
        this.evidence = BPCollections.I.createSafeSet();
    }

    @Transient
    public Class<? extends PathwayStep> getModelInterface() {
        return PathwayStep.class;
    }

    @Override
    @Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
    @ManyToMany(targetEntity=PathwayStepImpl.class)
    @JoinTable(name="nextStep")
    public Set<PathwayStep> getNextStep() {
        return this.nextStep;
    }

    @Override
    public void addNextStep(PathwayStep nextStep) {
        if (nextStep != null) {
            this.nextStep.add(nextStep);
            nextStep.getNextStepOf().add(this);
        }
    }

    @Override
    public void removeNextStep(PathwayStep nextStep) {
        if (nextStep != null) {
            nextStep.getNextStepOf().remove(this);
            this.nextStep.remove(nextStep);
        }
    }

    protected void setNextStep(Set<PathwayStep> nextStep) {
        this.nextStep = nextStep;
    }

    @Override
    @Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
    @ManyToMany(targetEntity=PathwayStepImpl.class, mappedBy="nextStep")
    public Set<PathwayStep> getNextStepOf() {
        return this.nextStepOf;
    }

    protected void setNextStepOf(Set<PathwayStep> nextStepOf) {
        this.nextStepOf = nextStepOf;
    }

    @Override
    @Transient
    public Set<Process> getStepProcess() {
        return this.getStepProcessX();
    }

    @Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
    @ManyToMany(targetEntity=ProcessImpl.class)
    @JoinTable(name="stepProcess", joinColumns={@JoinColumn(name="STEPPROCESS_PK", referencedColumnName="PK")}, inverseJoinColumns={@JoinColumn(name="STEPPROCESSOF_PK", referencedColumnName="PK")})
    Set<Process> getStepProcessX() {
        return this.stepProcess;
    }

    void setStepProcessX(Set<Process> stepProcess) {
        this.stepProcess = stepProcess;
    }

    @Override
    public void addStepProcess(Process processStep) {
        if (processStep != null) {
            this.stepProcess.add(processStep);
            processStep.getStepProcessOf().add(this);
        }
    }

    @Override
    public void removeStepProcess(Process processStep) {
        if (processStep != null) {
            processStep.getStepProcessOf().remove(this);
            this.stepProcess.remove(processStep);
        }
    }

    @Override
    @Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
    @ManyToMany(targetEntity=EvidenceImpl.class)
    @JoinTable(name="evidence")
    public Set<Evidence> getEvidence() {
        return this.evidence;
    }

    @Override
    public void addEvidence(Evidence evidence2) {
        if (evidence2 != null) {
            this.evidence.add(evidence2);
        }
    }

    @Override
    public void removeEvidence(Evidence evidence2) {
        if (evidence2 != null) {
            this.evidence.remove(evidence2);
        }
    }

    public void setEvidence(Set<Evidence> evidence2) {
        this.evidence = evidence2;
    }

    @Override
    @ManyToOne(targetEntity=PathwayImpl.class)
    public Pathway getPathwayOrderOf() {
        return this.pathwayOrderOf;
    }

    protected void setPathwayOrderOf(Pathway pathwayOrderOf) {
        this.pathwayOrderOf = pathwayOrderOf;
    }
}

