/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.impl.level3;

import java.util.Set;
import javax.persistence.Entity;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.OneToMany;
import javax.persistence.Transient;
import org.biopax.paxtools.impl.level3.EvidenceCodeVocabularyImpl;
import org.biopax.paxtools.impl.level3.ExperimentalFormImpl;
import org.biopax.paxtools.impl.level3.ScoreImpl;
import org.biopax.paxtools.impl.level3.XReferrableImpl;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.model.level3.Evidence;
import org.biopax.paxtools.model.level3.EvidenceCodeVocabulary;
import org.biopax.paxtools.model.level3.ExperimentalForm;
import org.biopax.paxtools.model.level3.PublicationXref;
import org.biopax.paxtools.model.level3.Score;
import org.biopax.paxtools.model.level3.Xref;
import org.biopax.paxtools.util.BPCollections;
import org.biopax.paxtools.util.ClassFilterSet;
import org.biopax.paxtools.util.SetEquivalenceChecker;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Proxy;
import org.hibernate.search.annotations.Indexed;

@Entity
@Proxy(proxyClass=Evidence.class)
@Indexed
@DynamicUpdate
@DynamicInsert
@Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
public class EvidenceImpl
extends XReferrableImpl
implements Evidence {
    private Set<ExperimentalForm> experimentalForm;
    private Set<Score> confidence = BPCollections.I.createSafeSet();
    private Set<EvidenceCodeVocabulary> evidenceCode = BPCollections.I.createSafeSet();

    public EvidenceImpl() {
        this.experimentalForm = BPCollections.I.createSafeSet();
    }

    @Transient
    public Class<? extends Evidence> getModelInterface() {
        return Evidence.class;
    }

    @Override
    @Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
    @OneToMany(targetEntity=ScoreImpl.class)
    @JoinTable(name="confidence")
    public Set<Score> getConfidence() {
        return this.confidence;
    }

    public void setConfidence(Set<Score> confidence2) {
        this.confidence = confidence2;
    }

    @Override
    public void addConfidence(Score confidence2) {
        if (confidence2 != null) {
            this.confidence.add(confidence2);
        }
    }

    @Override
    public void removeConfidence(Score confidence2) {
        if (confidence2 != null) {
            this.confidence.remove(confidence2);
        }
    }

    @Override
    @Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
    @ManyToMany(targetEntity=EvidenceCodeVocabularyImpl.class)
    @JoinTable(name="evidencecode")
    public Set<EvidenceCodeVocabulary> getEvidenceCode() {
        return this.evidenceCode;
    }

    public void setEvidenceCode(Set<EvidenceCodeVocabulary> evidenceCode) {
        this.evidenceCode = evidenceCode;
    }

    @Override
    public void addEvidenceCode(EvidenceCodeVocabulary evidenceCode) {
        if (evidenceCode != null) {
            this.evidenceCode.add(evidenceCode);
        }
    }

    @Override
    public void removeEvidenceCode(EvidenceCodeVocabulary evidenceCode) {
        if (evidenceCode != null) {
            this.evidenceCode.remove(evidenceCode);
        }
    }

    @Override
    @Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
    @ManyToMany(targetEntity=ExperimentalFormImpl.class)
    @JoinTable(name="experimentalForm")
    public Set<ExperimentalForm> getExperimentalForm() {
        return this.experimentalForm;
    }

    public void setExperimentalForm(Set<ExperimentalForm> experimentalForm2) {
        this.experimentalForm = experimentalForm2;
    }

    @Override
    public void addExperimentalForm(ExperimentalForm experimentalForm2) {
        if (experimentalForm2 != null) {
            this.experimentalForm.add(experimentalForm2);
        }
    }

    @Override
    public void removeExperimentalForm(ExperimentalForm experimentalForm2) {
        if (experimentalForm2 != null) {
            this.experimentalForm.remove(experimentalForm2);
        }
    }

    @Override
    protected boolean semanticallyEquivalent(BioPAXElement element) {
        boolean hasAllEquivEvidenceCodes;
        Evidence that;
        block7: {
            block6: {
                if (!(element instanceof Evidence)) {
                    return false;
                }
                that = (Evidence)element;
                hasAllEquivEvidenceCodes = false;
                if (!this.getEvidenceCode().isEmpty()) break block6;
                if (!that.getEvidenceCode().isEmpty()) break block7;
                hasAllEquivEvidenceCodes = true;
                break block7;
            }
            if (!that.getEvidenceCode().isEmpty()) {
                Set<EvidenceCodeVocabulary> longer;
                Set<EvidenceCodeVocabulary> shorter;
                if (this.getEvidenceCode().size() < that.getEvidenceCode().size()) {
                    shorter = this.getEvidenceCode();
                    longer = that.getEvidenceCode();
                } else {
                    longer = this.getEvidenceCode();
                    shorter = that.getEvidenceCode();
                }
                hasAllEquivEvidenceCodes = true;
                for (EvidenceCodeVocabulary secv : shorter) {
                    boolean foundEquiv = false;
                    for (EvidenceCodeVocabulary lecv : longer) {
                        if (!secv.isEquivalent(lecv)) continue;
                        foundEquiv = true;
                    }
                    if (foundEquiv) continue;
                    hasAllEquivEvidenceCodes = false;
                    break;
                }
            }
        }
        boolean hasCommonPublicationXref = SetEquivalenceChecker.hasEquivalentIntersection(new ClassFilterSet<Xref, PublicationXref>(this.getXref(), PublicationXref.class), new ClassFilterSet<Xref, PublicationXref>(that.getXref(), PublicationXref.class));
        return super.semanticallyEquivalent(element) && hasAllEquivEvidenceCodes && hasAllEquivEvidenceCodes;
    }
}

