/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.controller;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.biopax.paxtools.controller.EditorMap;
import org.biopax.paxtools.controller.ObjectPropertyEditor;
import org.biopax.paxtools.controller.PropertyEditor;
import org.biopax.paxtools.controller.PropertyFilterBilinked;
import org.biopax.paxtools.controller.TraverserBilinked;
import org.biopax.paxtools.controller.Visitor;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.model.Model;

public class Completer
implements Visitor {
    protected TraverserBilinked traverser;
    private final Set<BioPAXElement> completed;

    public Completer(EditorMap map) {
        this.traverser = new TraverserBilinked(map, (Visitor)this, new PropertyFilterBilinked(){

            @Override
            public boolean filter(PropertyEditor editor) {
                return editor instanceof ObjectPropertyEditor && ((ObjectPropertyEditor)editor).isCompleteForward();
            }

            @Override
            public boolean filterInverse(PropertyEditor editor) {
                return editor instanceof ObjectPropertyEditor && ((ObjectPropertyEditor)editor).isCompleteBackward();
            }
        });
        this.completed = new HashSet<BioPAXElement>();
    }

    public Set<BioPAXElement> complete(Collection<BioPAXElement> elements, Model model) {
        this.completed.clear();
        for (BioPAXElement element : elements) {
            if (this.completed.contains(element)) continue;
            this.completed.add(element);
            this.traverser.traverse(element, model);
        }
        return this.completed;
    }

    public void visit(BioPAXElement domain, Object range, Model model, PropertyEditor editor) {
        BioPAXElement element;
        if (range instanceof BioPAXElement && !this.completed.contains(element = (BioPAXElement)range)) {
            this.completed.add(element);
            this.traverser.traverse(element, model);
        }
    }
}

