/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.command;

import org.biopax.paxtools.command.AbstractPropertyCommand;
import org.biopax.paxtools.controller.PropertyEditor;
import org.biopax.paxtools.model.BioPAXElement;

public class PropertyRemoveCommand
extends AbstractPropertyCommand {
    PropertyRemoveCommand(BioPAXElement bpe, PropertyEditor editor, Object value) {
        super(bpe, editor, value);
        if (!editor.isMultipleCardinality()) {
            throw new IllegalArgumentException();
        }
    }

    @Override
    protected void undoAction() {
        this.editor.setValueToBean(this.value, this.bpe);
    }

    @Override
    protected void redoAction() {
        this.editor.removeValueFromBean(this.value, this.bpe);
    }

    public boolean canUndo() {
        return this.bpe != null;
    }

    public boolean canRedo() {
        return this.bpe != null && this.value != null;
    }

    public boolean isSignificant() {
        return this.value != null;
    }

    public String getPresentationName() {
        return "Remove " + this.value + " from " + this.editor.getProperty() + "s of " + this.bpe;
    }

    public String getUndoPresentationName() {
        return "Add" + this.value + "to" + this.editor.getProperty() + "s of " + this.bpe;
    }

    public String getRedoPresentationName() {
        return "Re-Remove " + this.value + " from " + this.editor.getProperty() + "s of " + this.bpe;
    }
}

