/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.value;

import net.sf.saxon.om.FastStringBuffer;

public class FloatingPointConverter {
    public static FloatingPointConverter THE_INSTANCE = new FloatingPointConverter();
    private static final char[] NEGATIVE_INFINITY = new char[]{'-', 'I', 'N', 'F'};
    private static final char[] POSITIVE_INFINITY = new char[]{'I', 'N', 'F'};
    private static final char[] NaN = new char[]{'N', 'a', 'N'};
    private static final char[] DOUBLE_ZERO = new char[]{'0', '.', '0'};
    private static final char[] DOUBLE_ZERO2 = new char[]{'0', '.', '0', '0'};
    private static final char[] DOUBLE_ZERO3 = new char[]{'0', '.', '0', '0', '0'};
    private static final char[] DOUBLE_ZERO4 = new char[]{'0', '.', '0', '0', '0', '0'};
    private static final char[] DOUBLE_ZERO5 = new char[]{'0', '.', '0', '0', '0', '0', '0'};
    private static final char[] DOUBLE_ZERO0 = new char[]{'0', '.'};
    private static final char[] DOT_ZERO = new char[]{'.', '0'};
    private static final long doubleSignMask = Long.MIN_VALUE;
    private static final long doubleExpMask = 0x7FF0000000000000L;
    private static final int doubleExpShift = 52;
    private static final int doubleExpBias = 1023;
    private static final int floatSignMask = Integer.MIN_VALUE;
    private static final int floatExpMask = 2139095040;
    private static final int floatExpShift = 23;
    private static final int floatExpBias = 127;
    private static final char[] charForDigit = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
    private static final float[] f_magnitudes = new float[]{9.8E-45f, 9.9E-44f, 1.0E-42f, 1.0E-41f, 1.0E-40f, 1.0E-39f, 1.0E-38f, 1.0E-37f, 1.0E-36f, 1.0E-35f, 1.0E-34f, 1.0E-33f, 1.0E-32f, 1.0E-31f, 1.0E-30f, 1.0E-29f, 1.0E-28f, 1.0E-27f, 1.0E-26f, 1.0E-25f, 1.0E-24f, 1.0E-23f, 1.0E-22f, 1.0E-21f, 1.0E-20f, 1.0E-19f, 1.0E-18f, 1.0E-17f, 1.0E-16f, 1.0E-15f, 1.0E-14f, 1.0E-13f, 1.0E-12f, 1.0E-11f, 1.0E-10f, 1.0E-9f, 1.0E-8f, 1.0E-7f, 1.0E-6f, 1.0E-5f, 1.0E-4f, 0.001f, 0.01f, 0.1f, 1.0f, 10.0f, 100.0f, 1000.0f, 10000.0f, 100000.0f, 1000000.0f, 1.0E7f, 1.0E8f, 1.0E9f, 1.0E10f, 1.0E11f, 1.0E12f, 1.0E13f, 1.0E14f, 1.0E15f, 1.0E16f, 1.0E17f, 1.0E18f, 1.0E19f, 1.0E20f, 1.0E21f, 1.0E22f, 1.0E23f, 1.0E24f, 1.0E25f, 1.0E26f, 1.0E27f, 1.0E28f, 1.0E29f, 1.0E30f, 1.0E31f, 1.0E32f, 1.0E33f, 1.0E34f, 1.0E35f, 1.0E36f, 1.0E37f, 1.0E38f};
    private static final double[] d_magnitudes = new double[]{9.9E-324, 9.9E-323, 1.0E-321, 1.0E-320, 1.0E-319, 1.0E-318, 1.0E-317, 1.0E-316, 1.0E-315, 1.0E-314, 1.0E-313, 1.0E-312, 1.0E-311, 1.0E-310, 1.0E-309, 1.0E-308, 1.0E-307, 1.0E-306, 1.0E-305, 1.0E-304, 1.0E-303, 1.0E-302, 1.0E-301, 1.0E-300, 1.0E-299, 1.0E-298, 1.0E-297, 1.0E-296, 1.0E-295, 1.0E-294, 1.0E-293, 1.0E-292, 1.0E-291, 1.0E-290, 1.0E-289, 1.0E-288, 1.0E-287, 1.0E-286, 1.0E-285, 1.0E-284, 1.0E-283, 1.0E-282, 1.0E-281, 1.0E-280, 1.0E-279, 1.0E-278, 1.0E-277, 1.0E-276, 1.0E-275, 1.0E-274, 1.0E-273, 1.0E-272, 1.0E-271, 1.0E-270, 1.0E-269, 1.0E-268, 1.0E-267, 1.0E-266, 1.0E-265, 1.0E-264, 1.0E-263, 1.0E-262, 1.0E-261, 1.0E-260, 1.0E-259, 1.0E-258, 1.0E-257, 1.0E-256, 1.0E-255, 1.0E-254, 1.0E-253, 1.0E-252, 1.0E-251, 1.0E-250, 1.0E-249, 1.0E-248, 1.0E-247, 1.0E-246, 1.0E-245, 1.0E-244, 1.0E-243, 1.0E-242, 1.0E-241, 1.0E-240, 1.0E-239, 1.0E-238, 1.0E-237, 1.0E-236, 1.0E-235, 1.0E-234, 1.0E-233, 1.0E-232, 1.0E-231, 1.0E-230, 1.0E-229, 1.0E-228, 1.0E-227, 1.0E-226, 1.0E-225, 1.0E-224, 1.0E-223, 1.0E-222, 1.0E-221, 1.0E-220, 1.0E-219, 1.0E-218, 1.0E-217, 1.0E-216, 1.0E-215, 1.0E-214, 1.0E-213, 1.0E-212, 1.0E-211, 1.0E-210, 1.0E-209, 1.0E-208, 1.0E-207, 1.0E-206, 1.0E-205, 1.0E-204, 1.0E-203, 1.0E-202, 1.0E-201, 1.0E-200, 1.0E-199, 1.0E-198, 1.0E-197, 1.0E-196, 1.0E-195, 1.0E-194, 1.0E-193, 1.0E-192, 1.0E-191, 1.0E-190, 1.0E-189, 1.0E-188, 1.0E-187, 1.0E-186, 1.0E-185, 1.0E-184, 1.0E-183, 1.0E-182, 1.0E-181, 1.0E-180, 1.0E-179, 1.0E-178, 1.0E-177, 1.0E-176, 1.0E-175, 1.0E-174, 1.0E-173, 1.0E-172, 1.0E-171, 1.0E-170, 1.0E-169, 1.0E-168, 1.0E-167, 1.0E-166, 1.0E-165, 1.0E-164, 1.0E-163, 1.0E-162, 1.0E-161, 1.0E-160, 1.0E-159, 1.0E-158, 1.0E-157, 1.0E-156, 1.0E-155, 1.0E-154, 1.0E-153, 1.0E-152, 1.0E-151, 1.0E-150, 1.0E-149, 1.0E-148, 1.0E-147, 1.0E-146, 1.0E-145, 1.0E-144, 1.0E-143, 1.0E-142, 1.0E-141, 1.0E-140, 1.0E-139, 1.0E-138, 1.0E-137, 1.0E-136, 1.0E-135, 1.0E-134, 1.0E-133, 1.0E-132, 1.0E-131, 1.0E-130, 1.0E-129, 1.0E-128, 1.0E-127, 1.0E-126, 1.0E-125, 1.0E-124, 1.0E-123, 1.0E-122, 1.0E-121, 1.0E-120, 1.0E-119, 1.0E-118, 1.0E-117, 1.0E-116, 1.0E-115, 1.0E-114, 1.0E-113, 1.0E-112, 1.0E-111, 1.0E-110, 1.0E-109, 1.0E-108, 1.0E-107, 1.0E-106, 1.0E-105, 1.0E-104, 1.0E-103, 1.0E-102, 1.0E-101, 1.0E-100, 1.0E-99, 1.0E-98, 1.0E-97, 1.0E-96, 1.0E-95, 1.0E-94, 1.0E-93, 1.0E-92, 1.0E-91, 1.0E-90, 1.0E-89, 1.0E-88, 1.0E-87, 1.0E-86, 1.0E-85, 1.0E-84, 1.0E-83, 1.0E-82, 1.0E-81, 1.0E-80, 1.0E-79, 1.0E-78, 1.0E-77, 1.0E-76, 1.0E-75, 1.0E-74, 1.0E-73, 1.0E-72, 1.0E-71, 1.0E-70, 1.0E-69, 1.0E-68, 1.0E-67, 1.0E-66, 1.0E-65, 1.0E-64, 1.0E-63, 1.0E-62, 1.0E-61, 1.0E-60, 1.0E-59, 1.0E-58, 1.0E-57, 1.0E-56, 1.0E-55, 1.0E-54, 1.0E-53, 1.0E-52, 1.0E-51, 1.0E-50, 1.0E-49, 1.0E-48, 1.0E-47, 1.0E-46, 1.0E-45, 1.0E-44, 1.0E-43, 1.0E-42, 1.0E-41, 1.0E-40, 1.0E-39, 1.0E-38, 1.0E-37, 1.0E-36, 1.0E-35, 1.0E-34, 1.0E-33, 1.0E-32, 1.0E-31, 1.0E-30, 1.0E-29, 1.0E-28, 1.0E-27, 1.0E-26, 1.0E-25, 1.0E-24, 1.0E-23, 1.0E-22, 1.0E-21, 1.0E-20, 1.0E-19, 1.0E-18, 1.0E-17, 1.0E-16, 1.0E-15, 1.0E-14, 1.0E-13, 1.0E-12, 1.0E-11, 1.0E-10, 1.0E-9, 1.0E-8, 1.0E-7, 1.0E-6, 1.0E-5, 1.0E-4, 0.001, 0.01, 0.1, 1.0, 10.0, 100.0, 1000.0, 10000.0, 100000.0, 1000000.0, 1.0E7, 1.0E8, 1.0E9, 1.0E10, 1.0E11, 1.0E12, 1.0E13, 1.0E14, 1.0E15, 1.0E16, 1.0E17, 1.0E18, 1.0E19, 1.0E20, 1.0E21, 1.0E22, 1.0E23, 1.0E24, 1.0E25, 1.0E26, 1.0E27, 1.0E28, 1.0E29, 1.0E30, 1.0E31, 1.0E32, 1.0E33, 1.0E34, 1.0E35, 1.0E36, 1.0E37, 1.0E38, 1.0E39, 1.0E40, 1.0E41, 1.0E42, 1.0E43, 1.0E44, 1.0E45, 1.0E46, 1.0E47, 1.0E48, 1.0E49, 1.0E50, 1.0E51, 1.0E52, 1.0E53, 1.0E54, 1.0E55, 1.0E56, 1.0E57, 1.0E58, 1.0E59, 1.0E60, 1.0E61, 1.0E62, 1.0E63, 1.0E64, 1.0E65, 1.0E66, 1.0E67, 1.0E68, 1.0E69, 1.0E70, 1.0E71, 1.0E72, 1.0E73, 1.0E74, 1.0E75, 1.0E76, 1.0E77, 1.0E78, 1.0E79, 1.0E80, 1.0E81, 1.0E82, 1.0E83, 1.0E84, 1.0E85, 1.0E86, 1.0E87, 1.0E88, 1.0E89, 1.0E90, 1.0E91, 1.0E92, 1.0E93, 1.0E94, 1.0E95, 1.0E96, 1.0E97, 1.0E98, 1.0E99, 1.0E100, 1.0E101, 1.0E102, 1.0E103, 1.0E104, 1.0E105, 1.0E106, 1.0E107, 1.0E108, 1.0E109, 1.0E110, 1.0E111, 1.0E112, 1.0E113, 1.0E114, 1.0E115, 1.0E116, 1.0E117, 1.0E118, 1.0E119, 1.0E120, 1.0E121, 1.0E122, 1.0E123, 1.0E124, 1.0E125, 1.0E126, 1.0E127, 1.0E128, 1.0E129, 1.0E130, 1.0E131, 1.0E132, 1.0E133, 1.0E134, 1.0E135, 1.0E136, 1.0E137, 1.0E138, 1.0E139, 1.0E140, 1.0E141, 1.0E142, 1.0E143, 1.0E144, 1.0E145, 1.0E146, 1.0E147, 1.0E148, 1.0E149, 1.0E150, 1.0E151, 1.0E152, 1.0E153, 1.0E154, 1.0E155, 1.0E156, 1.0E157, 1.0E158, 1.0E159, 1.0E160, 1.0E161, 1.0E162, 1.0E163, 1.0E164, 1.0E165, 1.0E166, 1.0E167, 1.0E168, 1.0E169, 1.0E170, 1.0E171, 1.0E172, 1.0E173, 1.0E174, 1.0E175, 1.0E176, 1.0E177, 1.0E178, 1.0E179, 1.0E180, 1.0E181, 1.0E182, 1.0E183, 1.0E184, 1.0E185, 1.0E186, 1.0E187, 1.0E188, 1.0E189, 1.0E190, 1.0E191, 1.0E192, 1.0E193, 1.0E194, 1.0E195, 1.0E196, 1.0E197, 1.0E198, 1.0E199, 1.0E200, 1.0E201, 1.0E202, 1.0E203, 1.0E204, 1.0E205, 1.0E206, 1.0E207, 1.0E208, 1.0E209, 1.0E210, 1.0E211, 1.0E212, 1.0E213, 1.0E214, 1.0E215, 1.0E216, 1.0E217, 1.0E218, 1.0E219, 1.0E220, 1.0E221, 1.0E222, 1.0E223, 1.0E224, 1.0E225, 1.0E226, 1.0E227, 1.0E228, 1.0E229, 1.0E230, 1.0E231, 1.0E232, 1.0E233, 1.0E234, 1.0E235, 1.0E236, 1.0E237, 1.0E238, 1.0E239, 1.0E240, 1.0E241, 1.0E242, 1.0E243, 1.0E244, 1.0E245, 1.0E246, 1.0E247, 1.0E248, 1.0E249, 1.0E250, 1.0E251, 1.0E252, 1.0E253, 1.0E254, 1.0E255, 1.0E256, 1.0E257, 1.0E258, 1.0E259, 1.0E260, 1.0E261, 1.0E262, 1.0E263, 1.0E264, 1.0E265, 1.0E266, 1.0E267, 1.0E268, 1.0E269, 1.0E270, 1.0E271, 1.0E272, 1.0E273, 1.0E274, 1.0E275, 1.0E276, 1.0E277, 1.0E278, 1.0E279, 1.0E280, 1.0E281, 1.0E282, 1.0E283, 1.0E284, 1.0E285, 1.0E286, 1.0E287, 1.0E288, 1.0E289, 1.0E290, 1.0E291, 1.0E292, 1.0E293, 1.0E294, 1.0E295, 1.0E296, 1.0E297, 1.0E298, 1.0E299, 1.0E300, 1.0E301, 1.0E302, 1.0E303, 1.0E304, 1.0E305, 1.0E306, 1.0E307, 1.0E308};
    private static final char[][] ZEROS = new char[][]{new char[0], {'0'}, {'0', '0'}, {'0', '0', '0'}, {'0', '0', '0', '0'}, {'0', '0', '0', '0', '0'}, {'0', '0', '0', '0', '0', '0'}, {'0', '0', '0', '0', '0', '0', '0'}, {'0', '0', '0', '0', '0', '0', '0', '0'}, {'0', '0', '0', '0', '0', '0', '0', '0', '0'}, {'0', '0', '0', '0', '0', '0', '0', '0', '0', '0'}, {'0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0'}, {'0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0'}, {'0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0'}, {'0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0'}, {'0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0'}, {'0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0'}, {'0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0'}, {'0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0'}, {'0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0'}, {'0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0'}};

    private FloatingPointConverter() {
    }

    public FastStringBuffer append(FastStringBuffer fastStringBuffer, double d) {
        double d2 = d;
        if (d2 == Double.NEGATIVE_INFINITY) {
            fastStringBuffer.append(NEGATIVE_INFINITY);
        } else if (d2 == Double.POSITIVE_INFINITY) {
            fastStringBuffer.append(POSITIVE_INFINITY);
        } else if (d2 != d2) {
            fastStringBuffer.append(NaN);
        } else if (d2 == 0.0) {
            if ((Double.doubleToLongBits(d2) & Long.MIN_VALUE) != 0L) {
                fastStringBuffer.append('-');
            }
            fastStringBuffer.append('0');
        } else if (d2 == Double.MAX_VALUE) {
            fastStringBuffer.append("1.7976931348623157E308");
        } else if (d2 == -1.7976931348623157E308) {
            fastStringBuffer.append("-1.7976931348623157E308");
        } else if (d2 == Double.MIN_VALUE) {
            fastStringBuffer.append("4.9E-324");
        } else if (d2 == -4.9E-324) {
            fastStringBuffer.append("-4.9E-324");
        } else {
            if (d2 < 0.0) {
                fastStringBuffer.append('-');
                d2 = -d2;
            }
            if (d2 >= 1.0E-6 && d2 < 1000000.0) {
                if (d2 < 1.0) {
                    if (d2 < 1.0E-5) {
                        long l = (long)(d2 * 1.0E23);
                        l = l % 100L >= 50L ? l / 100L + 1L : l / 100L;
                        fastStringBuffer.append(DOUBLE_ZERO5);
                        FloatingPointConverter.appendFractDigits(fastStringBuffer, l, -1, false);
                    } else if (d2 < 1.0E-4) {
                        long l = (long)(d2 * 1.0E22);
                        l = l % 100L >= 50L ? l / 100L + 1L : l / 100L;
                        fastStringBuffer.append(DOUBLE_ZERO4);
                        FloatingPointConverter.appendFractDigits(fastStringBuffer, l, -1, false);
                    } else if (d2 < 0.001) {
                        long l = (long)(d2 * 1.0E21);
                        l = l % 100L >= 50L ? l / 100L + 1L : l / 100L;
                        fastStringBuffer.append(DOUBLE_ZERO3);
                        FloatingPointConverter.appendFractDigits(fastStringBuffer, l, -1, false);
                    } else if (d2 < 0.01) {
                        long l = (long)(d2 * 1.0E20);
                        l = l % 100L >= 50L ? l / 100L + 1L : l / 100L;
                        fastStringBuffer.append(DOUBLE_ZERO2);
                        FloatingPointConverter.appendFractDigits(fastStringBuffer, l, -1, false);
                    } else if (d2 < 0.1) {
                        long l = (long)(d2 * 1.0E19);
                        l = l % 100L >= 50L ? l / 100L + 1L : l / 100L;
                        fastStringBuffer.append(DOUBLE_ZERO);
                        FloatingPointConverter.appendFractDigits(fastStringBuffer, l, -1, false);
                    } else {
                        long l = (long)(d2 * 1.0E18);
                        l = l % 100L >= 50L ? l / 100L + 1L : l / 100L;
                        fastStringBuffer.append(DOUBLE_ZERO0);
                        FloatingPointConverter.appendFractDigits(fastStringBuffer, l, -1, false);
                    }
                } else if (d2 < 10.0) {
                    long l = (long)(d2 * 1.0E17);
                    l = l % 100L >= 50L ? l / 100L + 1L : l / 100L;
                    FloatingPointConverter.appendFractDigits(fastStringBuffer, l, 1, false);
                } else if (d2 < 100.0) {
                    long l = (long)(d2 * 1.0E16);
                    l = l % 100L >= 50L ? l / 100L + 1L : l / 100L;
                    FloatingPointConverter.appendFractDigits(fastStringBuffer, l, 2, false);
                } else if (d2 < 1000.0) {
                    long l = (long)(d2 * 1.0E15);
                    l = l % 100L >= 50L ? l / 100L + 1L : l / 100L;
                    FloatingPointConverter.appendFractDigits(fastStringBuffer, l, 3, false);
                } else if (d2 < 10000.0) {
                    long l = (long)(d2 * 1.0E14);
                    l = l % 100L >= 50L ? l / 100L + 1L : l / 100L;
                    FloatingPointConverter.appendFractDigits(fastStringBuffer, l, 4, false);
                } else if (d2 < 100000.0) {
                    long l = (long)(d2 * 1.0E13);
                    l = l % 100L >= 50L ? l / 100L + 1L : l / 100L;
                    FloatingPointConverter.appendFractDigits(fastStringBuffer, l, 5, false);
                } else {
                    long l = (long)(d2 * 1.0E12);
                    l = l % 100L >= 50L ? l / 100L + 1L : l / 100L;
                    FloatingPointConverter.appendFractDigits(fastStringBuffer, l, 6, false);
                }
            } else {
                int n = FloatingPointConverter.magnitude(d2);
                long l = n < -305 ? (long)(d2 * 1.0E18 / d_magnitudes[n + 324]) : (long)(d2 / d_magnitudes[n + 323 - 17]);
                l = l % 100L >= 50L ? l / 100L + 1L : l / 100L;
                FloatingPointConverter.appendFractDigits(fastStringBuffer, l, 1, true);
                fastStringBuffer.append('E');
                this.append(fastStringBuffer, n);
            }
        }
        if (fastStringBuffer.length() > 8) {
            double d3 = Double.parseDouble(fastStringBuffer.toString());
            if (d == d3) {
                FloatingPointConverter.snapDouble(fastStringBuffer, d);
                return fastStringBuffer;
            }
            if (d > 0.0 ? d < d3 : d > d3) {
                FloatingPointConverter.nudgeDownDouble(fastStringBuffer, d);
                return fastStringBuffer;
            }
            FloatingPointConverter.nudgeUpDouble(fastStringBuffer, d);
            return fastStringBuffer;
        }
        return fastStringBuffer;
    }

    public FastStringBuffer append(FastStringBuffer fastStringBuffer, float f) {
        float f2 = f;
        if (f2 == Float.NEGATIVE_INFINITY) {
            fastStringBuffer.append(NEGATIVE_INFINITY);
        } else if (f2 == Float.POSITIVE_INFINITY) {
            fastStringBuffer.append(POSITIVE_INFINITY);
        } else if (f2 != f2) {
            fastStringBuffer.append(NaN);
        } else if ((double)f2 == 0.0) {
            if ((Float.floatToIntBits(f2) & Integer.MIN_VALUE) != 0) {
                fastStringBuffer.append('-');
            }
            fastStringBuffer.append('0');
        } else if (f2 == Float.MAX_VALUE) {
            fastStringBuffer.append("3.4028235E38");
        } else if (f2 == -3.4028235E38f) {
            fastStringBuffer.append("-3.4028235E38");
        } else if (f2 == Float.MIN_VALUE) {
            fastStringBuffer.append("1.4E-45");
        } else if (f2 == -1.4E-45f) {
            fastStringBuffer.append("-1.4E-45");
        } else {
            if (f2 < 0.0f) {
                fastStringBuffer.append('-');
                f2 = -f2;
            }
            if (f2 >= 1.0E-6f && f2 < 1000000.0f) {
                if (f2 < 1.0f) {
                    if (f2 < 1.0E-5f) {
                        long l = (long)(f2 * 1.0E15f);
                        l = l % 100L >= 50L ? l / 100L + 1L : l / 100L;
                        fastStringBuffer.append(DOUBLE_ZERO5);
                        FloatingPointConverter.appendFractDigits(fastStringBuffer, l, -1, false);
                    } else if (f2 < 1.0E-4f) {
                        long l = (long)(f2 * 1.0E14f);
                        l = l % 100L >= 50L ? l / 100L + 1L : l / 100L;
                        fastStringBuffer.append(DOUBLE_ZERO4);
                        FloatingPointConverter.appendFractDigits(fastStringBuffer, l, -1, false);
                    } else if (f2 < 0.001f) {
                        long l = (long)(f2 * 1.0E13f);
                        l = l % 100L >= 50L ? l / 100L + 1L : l / 100L;
                        fastStringBuffer.append(DOUBLE_ZERO3);
                        FloatingPointConverter.appendFractDigits(fastStringBuffer, l, -1, false);
                    } else if (f2 < 0.01f) {
                        long l = (long)(f2 * 1.0E12f);
                        l = l % 100L >= 50L ? l / 100L + 1L : l / 100L;
                        fastStringBuffer.append(DOUBLE_ZERO2);
                        FloatingPointConverter.appendFractDigits(fastStringBuffer, l, -1, false);
                    } else if (f2 < 0.1f) {
                        long l = (long)(f2 * 1.0E11f);
                        l = l % 100L >= 50L ? l / 100L + 1L : l / 100L;
                        fastStringBuffer.append(DOUBLE_ZERO);
                        FloatingPointConverter.appendFractDigits(fastStringBuffer, l, -1, false);
                    } else {
                        long l = (long)(f2 * 1.0E10f);
                        l = l % 100L >= 50L ? l / 100L + 1L : l / 100L;
                        fastStringBuffer.append(DOUBLE_ZERO0);
                        FloatingPointConverter.appendFractDigits(fastStringBuffer, l, -1, false);
                    }
                } else if (f2 < 10.0f) {
                    long l = (long)(f2 * 1.0E9f);
                    l = l % 100L >= 50L ? l / 100L + 1L : l / 100L;
                    FloatingPointConverter.appendFractDigits(fastStringBuffer, l, 1, false);
                } else if (f2 < 100.0f) {
                    long l = (long)(f2 * 1.0E8f);
                    l = l % 100L >= 50L ? l / 100L + 1L : l / 100L;
                    FloatingPointConverter.appendFractDigits(fastStringBuffer, l, 2, false);
                } else if (f2 < 1000.0f) {
                    long l = (long)(f2 * 1.0E7f);
                    l = l % 100L >= 50L ? l / 100L + 1L : l / 100L;
                    FloatingPointConverter.appendFractDigits(fastStringBuffer, l, 3, false);
                } else if (f2 < 10000.0f) {
                    long l = (long)(f2 * 1000000.0f);
                    l = l % 100L >= 50L ? l / 100L + 1L : l / 100L;
                    FloatingPointConverter.appendFractDigits(fastStringBuffer, l, 4, false);
                } else if (f2 < 100000.0f) {
                    long l = (long)(f2 * 100000.0f);
                    l = l % 100L >= 50L ? l / 100L + 1L : l / 100L;
                    FloatingPointConverter.appendFractDigits(fastStringBuffer, l, 5, false);
                } else {
                    long l = (long)(f2 * 10000.0f);
                    l = l % 100L >= 50L ? l / 100L + 1L : l / 100L;
                    FloatingPointConverter.appendFractDigits(fastStringBuffer, l, 6, false);
                }
            } else {
                int n = FloatingPointConverter.magnitude(f2);
                long l = n < -35 ? (long)(f2 * 1.0E10f / f_magnitudes[n + 45]) : (long)(f2 / f_magnitudes[n + 44 - 9]);
                l = l % 100L >= 50L ? l / 100L + 1L : l / 100L;
                FloatingPointConverter.appendFractDigits(fastStringBuffer, l, 1, true);
                fastStringBuffer.append('E');
                this.append(fastStringBuffer, n);
            }
        }
        if (fastStringBuffer.length() > 5) {
            float f3 = Float.parseFloat(fastStringBuffer.toString());
            if (f == f3) {
                FloatingPointConverter.snapFloat(fastStringBuffer, f);
                return fastStringBuffer;
            }
            if (f > 0.0f ? f < f3 : f > f3) {
                FloatingPointConverter.nudgeDownFloat(fastStringBuffer, f);
                return fastStringBuffer;
            }
            FloatingPointConverter.nudgeUpFloat(fastStringBuffer, f);
            return fastStringBuffer;
        }
        return fastStringBuffer;
    }

    private FloatingPointConverter append(FastStringBuffer fastStringBuffer, int n) {
        if (n < 0) {
            if (n == Integer.MIN_VALUE) {
                fastStringBuffer.append("-2147483648");
                return this;
            }
            fastStringBuffer.append('-');
            n = -n;
        }
        if (n < 10) {
            fastStringBuffer.append(charForDigit[n]);
            return this;
        }
        if (n < 100) {
            fastStringBuffer.append(charForDigit[n / 10]);
            fastStringBuffer.append(charForDigit[n % 10]);
            return this;
        }
        if (n < 1000) {
            fastStringBuffer.append(charForDigit[n / 100]);
            int n2 = n % 100;
            fastStringBuffer.append(charForDigit[n2 / 10]);
            fastStringBuffer.append(charForDigit[n2 % 10]);
            return this;
        }
        if (n < 10000) {
            fastStringBuffer.append(charForDigit[n / 1000]);
            int n4 = n % 1000;
            fastStringBuffer.append(charForDigit[n4 / 100]);
            fastStringBuffer.append(charForDigit[(n4 %= 100) / 10]);
            fastStringBuffer.append(charForDigit[n4 % 10]);
            return this;
        }
        if (n < 100000) {
            fastStringBuffer.append(charForDigit[n / 10000]);
            int n5 = n % 10000;
            fastStringBuffer.append(charForDigit[n5 / 1000]);
            fastStringBuffer.append(charForDigit[(n5 %= 1000) / 100]);
            fastStringBuffer.append(charForDigit[(n5 %= 100) / 10]);
            fastStringBuffer.append(charForDigit[n5 % 10]);
            return this;
        }
        if (n < 1000000) {
            fastStringBuffer.append(charForDigit[n / 100000]);
            int n6 = n % 100000;
            fastStringBuffer.append(charForDigit[n6 / 10000]);
            fastStringBuffer.append(charForDigit[(n6 %= 10000) / 1000]);
            fastStringBuffer.append(charForDigit[(n6 %= 1000) / 100]);
            fastStringBuffer.append(charForDigit[(n6 %= 100) / 10]);
            fastStringBuffer.append(charForDigit[n6 % 10]);
            return this;
        }
        if (n < 10000000) {
            fastStringBuffer.append(charForDigit[n / 1000000]);
            int n7 = n % 1000000;
            fastStringBuffer.append(charForDigit[n7 / 100000]);
            fastStringBuffer.append(charForDigit[(n7 %= 100000) / 10000]);
            fastStringBuffer.append(charForDigit[(n7 %= 10000) / 1000]);
            fastStringBuffer.append(charForDigit[(n7 %= 1000) / 100]);
            fastStringBuffer.append(charForDigit[(n7 %= 100) / 10]);
            fastStringBuffer.append(charForDigit[n7 % 10]);
            return this;
        }
        if (n < 100000000) {
            fastStringBuffer.append(charForDigit[n / 10000000]);
            int n8 = n % 10000000;
            fastStringBuffer.append(charForDigit[n8 / 1000000]);
            fastStringBuffer.append(charForDigit[(n8 %= 1000000) / 100000]);
            fastStringBuffer.append(charForDigit[(n8 %= 100000) / 10000]);
            fastStringBuffer.append(charForDigit[(n8 %= 10000) / 1000]);
            fastStringBuffer.append(charForDigit[(n8 %= 1000) / 100]);
            fastStringBuffer.append(charForDigit[(n8 %= 100) / 10]);
            fastStringBuffer.append(charForDigit[n8 % 10]);
            return this;
        }
        if (n < 1000000000) {
            fastStringBuffer.append(charForDigit[n / 100000000]);
            int n9 = n % 100000000;
            fastStringBuffer.append(charForDigit[n9 / 10000000]);
            fastStringBuffer.append(charForDigit[(n9 %= 10000000) / 1000000]);
            fastStringBuffer.append(charForDigit[(n9 %= 1000000) / 100000]);
            fastStringBuffer.append(charForDigit[(n9 %= 100000) / 10000]);
            fastStringBuffer.append(charForDigit[(n9 %= 10000) / 1000]);
            fastStringBuffer.append(charForDigit[(n9 %= 1000) / 100]);
            fastStringBuffer.append(charForDigit[(n9 %= 100) / 10]);
            fastStringBuffer.append(charForDigit[n9 % 10]);
            return this;
        }
        fastStringBuffer.append(charForDigit[n / 1000000000]);
        int n10 = n % 1000000000;
        fastStringBuffer.append(charForDigit[n10 / 100000000]);
        fastStringBuffer.append(charForDigit[(n10 %= 100000000) / 10000000]);
        fastStringBuffer.append(charForDigit[(n10 %= 10000000) / 1000000]);
        fastStringBuffer.append(charForDigit[(n10 %= 1000000) / 100000]);
        fastStringBuffer.append(charForDigit[(n10 %= 100000) / 10000]);
        fastStringBuffer.append(charForDigit[(n10 %= 10000) / 1000]);
        fastStringBuffer.append(charForDigit[(n10 %= 1000) / 100]);
        fastStringBuffer.append(charForDigit[(n10 %= 100) / 10]);
        fastStringBuffer.append(charForDigit[n10 % 10]);
        return this;
    }

    private static void appendFractDigits(FastStringBuffer fastStringBuffer, long l, int n, boolean bl) {
        long l2 = FloatingPointConverter.magnitude(l);
        while (l > 0L) {
            long l3 = l / l2;
            fastStringBuffer.append(charForDigit[(int)l3]);
            if (--n == 0) {
                fastStringBuffer.append('.');
            }
            if ((l3 *= l2) <= l) {
                l -= l3;
            }
            l2 /= 10L;
        }
        if (l != 0L) {
            fastStringBuffer.append(charForDigit[(int)l]);
        } else if (n > 0) {
            fastStringBuffer.append(ZEROS[n]);
            n = 1;
        }
        if (--n == 0) {
            if (bl) {
                fastStringBuffer.append(DOT_ZERO);
            }
        } else if (n == -1) {
            if (bl) {
                fastStringBuffer.append('0');
            } else {
                fastStringBuffer.setLength(fastStringBuffer.length() - 1);
            }
        }
    }

    private static int magnitude(double d) {
        return FloatingPointConverter.magnitude(d, Double.doubleToLongBits(d));
    }

    private static int magnitude(double d, long l) {
        int n = (int)((double)(((l & 0x7FF0000000000000L) >> 52) - 1023L) * 0.301029995663981);
        if (n < -323) {
            n = -323;
        } else if (n > 308) {
            n = 308;
        }
        if (d >= d_magnitudes[n + 323]) {
            while (n < 309 && d >= d_magnitudes[n + 323]) {
                ++n;
            }
            return --n;
        }
        while (n > -324 && d < d_magnitudes[n + 323]) {
            --n;
        }
        return n;
    }

    private static int magnitude(float f) {
        return FloatingPointConverter.magnitude(f, Float.floatToIntBits(f));
    }

    private static int magnitude(float f, int n) {
        int n2 = (int)((double)(((n & 0x7F800000) >> 23) - 127) * 0.301029995663981);
        if (n2 < -44) {
            n2 = -44;
        } else if (n2 > 38) {
            n2 = 38;
        }
        if (f >= f_magnitudes[n2 + 44]) {
            while (n2 < 39 && f >= f_magnitudes[n2 + 44]) {
                ++n2;
            }
            return --n2;
        }
        while (n2 > -45 && f < f_magnitudes[n2 + 44]) {
            --n2;
        }
        return n2;
    }

    private static long magnitude(long l) {
        if (l < 10L) {
            return 1L;
        }
        if (l < 100L) {
            return 10L;
        }
        if (l < 1000L) {
            return 100L;
        }
        if (l < 10000L) {
            return 1000L;
        }
        if (l < 100000L) {
            return 10000L;
        }
        if (l < 1000000L) {
            return 100000L;
        }
        if (l < 10000000L) {
            return 1000000L;
        }
        if (l < 100000000L) {
            return 10000000L;
        }
        if (l < 1000000000L) {
            return 100000000L;
        }
        if (l < 10000000000L) {
            return 1000000000L;
        }
        if (l < 100000000000L) {
            return 10000000000L;
        }
        if (l < 1000000000000L) {
            return 100000000000L;
        }
        if (l < 10000000000000L) {
            return 1000000000000L;
        }
        if (l < 100000000000000L) {
            return 10000000000000L;
        }
        if (l < 1000000000000000L) {
            return 100000000000000L;
        }
        if (l < 10000000000000000L) {
            return 1000000000000000L;
        }
        if (l < 100000000000000000L) {
            return 10000000000000000L;
        }
        if (l < 1000000000000000000L) {
            return 100000000000000000L;
        }
        return 1000000000000000000L;
    }

    private static boolean nudgeUpDouble(FastStringBuffer fastStringBuffer, double d) {
        int n = fastStringBuffer.indexOf('E');
        int n2 = n >= 0 ? n - 1 : fastStringBuffer.length() - 1;
        while (true) {
            boolean bl;
            FloatingPointConverter.increment(fastStringBuffer, n2);
            double d2 = Double.parseDouble(fastStringBuffer.toString());
            if (d2 == d) {
                FloatingPointConverter.snapDouble(fastStringBuffer, d);
                return true;
            }
            if (!(d > 0.0 ? d2 > d : d2 < d)) continue;
            FloatingPointConverter.decrement(fastStringBuffer, n2);
            if (n2 == fastStringBuffer.length() - 1) {
                fastStringBuffer.append('0');
            } else {
                fastStringBuffer.insertCharAt(n2 + 1, '0');
            }
            if (bl = FloatingPointConverter.nudgeUpDouble(fastStringBuffer, d)) break;
        }
        return true;
    }

    private static boolean nudgeDownDouble(FastStringBuffer fastStringBuffer, double d) {
        int n = fastStringBuffer.indexOf('E');
        int n2 = n >= 0 ? n - 1 : fastStringBuffer.length() - 1;
        while (true) {
            boolean bl;
            FloatingPointConverter.decrement(fastStringBuffer, n2);
            double d2 = Double.parseDouble(fastStringBuffer.toString());
            if (d2 == d) {
                FloatingPointConverter.snapDouble(fastStringBuffer, d);
                return true;
            }
            if (!(d > 0.0 ? d2 < d : d2 > d)) continue;
            FloatingPointConverter.increment(fastStringBuffer, n2);
            if (n2 == fastStringBuffer.length() - 1) {
                fastStringBuffer.append('0');
            } else {
                fastStringBuffer.insertCharAt(n2 + 1, '0');
            }
            if (bl = FloatingPointConverter.nudgeDownDouble(fastStringBuffer, d)) break;
        }
        return true;
    }

    private static boolean nudgeUpFloat(FastStringBuffer fastStringBuffer, float f) {
        int n = fastStringBuffer.indexOf('E');
        int n2 = n >= 0 ? n - 1 : fastStringBuffer.length() - 1;
        while (true) {
            boolean bl;
            FloatingPointConverter.increment(fastStringBuffer, n2);
            double d = Float.parseFloat(fastStringBuffer.toString());
            if (d == (double)f) {
                FloatingPointConverter.snapFloat(fastStringBuffer, f);
                return true;
            }
            if (!(f > 0.0f ? d > (double)f : d < (double)f)) continue;
            FloatingPointConverter.decrement(fastStringBuffer, n2);
            if (n2 == fastStringBuffer.length() - 1) {
                fastStringBuffer.append('0');
            } else {
                fastStringBuffer.insertCharAt(n2 + 1, '0');
            }
            if (bl = FloatingPointConverter.nudgeUpFloat(fastStringBuffer, f)) break;
        }
        return true;
    }

    private static boolean nudgeDownFloat(FastStringBuffer fastStringBuffer, float f) {
        int n = fastStringBuffer.indexOf('E');
        int n2 = n >= 0 ? n - 1 : fastStringBuffer.length() - 1;
        while (true) {
            boolean bl;
            FloatingPointConverter.decrement(fastStringBuffer, n2);
            double d = Float.parseFloat(fastStringBuffer.toString());
            if (d == (double)f) {
                FloatingPointConverter.snapFloat(fastStringBuffer, f);
                return true;
            }
            if (!(f > 0.0f ? d < (double)f : d > (double)f)) continue;
            FloatingPointConverter.increment(fastStringBuffer, n2);
            if (n2 == fastStringBuffer.length() - 1) {
                fastStringBuffer.append('0');
            } else {
                fastStringBuffer.insertCharAt(n2, '0');
            }
            if (bl = FloatingPointConverter.nudgeDownFloat(fastStringBuffer, f)) break;
        }
        return true;
    }

    private static void snapDouble(FastStringBuffer fastStringBuffer, double d) {
        int n = -1;
        int n2 = 0;
        int n4 = 0;
        int n5 = -1;
        int n6 = fastStringBuffer.length();
        block6: for (int i = 0; i < n6; ++i) {
            switch (fastStringBuffer.charAt(i)) {
                case '0': {
                    ++n2;
                    continue block6;
                }
                case '9': {
                    ++n4;
                    continue block6;
                }
                case '.': {
                    n = i;
                    continue block6;
                }
                case 'E': {
                    n5 = i;
                    continue block6;
                }
            }
        }
        if (n < 0) {
            return;
        }
        int n7 = n5 >= 0 ? n5 : fastStringBuffer.length();
        if (n2 >= 5) {
            if (fastStringBuffer.charAt(n7 - 3) == '0' && fastStringBuffer.charAt(n7 - 2) == '0' && fastStringBuffer.charAt(n7 - 1) == '1') {
                fastStringBuffer.setCharAt(n7 - 1, '0');
                if (Double.parseDouble(fastStringBuffer.toString()) != d) {
                    fastStringBuffer.setCharAt(n7 - 1, '1');
                    return;
                }
            }
        } else if (n4 >= 5 && fastStringBuffer.charAt(n7 - 3) == '9' && fastStringBuffer.charAt(n7 - 2) == '9' && fastStringBuffer.charAt(n7 - 1) == '9') {
            FloatingPointConverter.increment(fastStringBuffer, n7 - 1);
            if (Double.parseDouble(fastStringBuffer.toString()) != d) {
                FloatingPointConverter.decrement(fastStringBuffer, n7 - 1);
                return;
            }
        }
        --n7;
        while (fastStringBuffer.charAt(n7) == '0' && fastStringBuffer.charAt(n7 - 1) != '.') {
            fastStringBuffer.removeCharAt(n7--);
        }
    }

    private static void snapFloat(FastStringBuffer fastStringBuffer, float f) {
        int n = -1;
        int n2 = 0;
        int n4 = 0;
        int n5 = -1;
        int n6 = fastStringBuffer.length();
        block6: for (int i = 0; i < n6; ++i) {
            switch (fastStringBuffer.charAt(i)) {
                case '0': {
                    ++n2;
                    continue block6;
                }
                case '9': {
                    ++n4;
                    continue block6;
                }
                case '.': {
                    n = i;
                    continue block6;
                }
                case 'E': {
                    n5 = i;
                    continue block6;
                }
            }
        }
        if (n < 0) {
            return;
        }
        int n7 = n5 >= 0 ? n5 : fastStringBuffer.length();
        if (n2 >= 2) {
            if (fastStringBuffer.charAt(n7 - 3) == '0' && fastStringBuffer.charAt(n7 - 2) == '0' && fastStringBuffer.charAt(n7 - 1) == '1') {
                fastStringBuffer.setCharAt(n7 - 1, '0');
                if (Float.parseFloat(fastStringBuffer.toString()) != f) {
                    fastStringBuffer.setCharAt(n7 - 1, '1');
                    return;
                }
            }
        } else if (n4 >= 2 && fastStringBuffer.charAt(n7 - 3) == '9' && fastStringBuffer.charAt(n7 - 2) == '9' && fastStringBuffer.charAt(n7 - 1) == '9') {
            FloatingPointConverter.increment(fastStringBuffer, n7 - 1);
            if (Float.parseFloat(fastStringBuffer.toString()) != f) {
                FloatingPointConverter.decrement(fastStringBuffer, n7 - 1);
                return;
            }
        }
        --n7;
        while (fastStringBuffer.charAt(n7) == '0' && fastStringBuffer.charAt(n7 - 1) != '.') {
            fastStringBuffer.removeCharAt(n7--);
        }
    }

    private static void increment(FastStringBuffer fastStringBuffer, int n) {
        char c = fastStringBuffer.charAt(n);
        if (c == '.') {
            FloatingPointConverter.increment(fastStringBuffer, n - 1);
        } else if (c == '9') {
            fastStringBuffer.setCharAt(n, '0');
            if (n == 0) {
                fastStringBuffer.insertCharAt(0, '1');
            } else {
                FloatingPointConverter.increment(fastStringBuffer, n - 1);
            }
        } else {
            fastStringBuffer.setCharAt(n, (char)(c + '\u0001'));
        }
    }

    private static void decrement(FastStringBuffer fastStringBuffer, int n) {
        char c = fastStringBuffer.charAt(n);
        if (c == '.') {
            FloatingPointConverter.decrement(fastStringBuffer, n - 1);
        } else if (c == '0') {
            fastStringBuffer.setCharAt(n, '9');
            if (n == 0) {
                throw new IllegalArgumentException("cannot decrement zero");
            }
            FloatingPointConverter.decrement(fastStringBuffer, n - 1);
        } else {
            fastStringBuffer.setCharAt(n, (char)(c - '\u0001'));
        }
    }
}

