/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.tinytree;

import net.sf.saxon.event.Receiver;
import net.sf.saxon.om.FastStringBuffer;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.tinytree.TinyNodeImpl;
import net.sf.saxon.tinytree.TinyTree;
import net.sf.saxon.trans.XPathException;

final class TinyAttributeImpl
extends TinyNodeImpl {
    public TinyAttributeImpl(TinyTree tinyTree, int n) {
        this.tree = tinyTree;
        this.nodeNr = n;
    }

    public NodeInfo getParent() {
        return this.tree.getNode(this.tree.attParent[this.nodeNr]);
    }

    public NodeInfo getRoot() {
        NodeInfo nodeInfo = this.getParent();
        if (nodeInfo == null) {
            return this;
        }
        return nodeInfo.getRoot();
    }

    protected long getSequenceNumber() {
        long l = ((TinyNodeImpl)this.getParent()).getSequenceNumber() + 32768L + (long)(this.nodeNr - this.tree.alpha[this.tree.attParent[this.nodeNr]]);
        return l;
    }

    public final int getNodeKind() {
        return 2;
    }

    public CharSequence getStringValueCS() {
        return this.tree.attValue[this.nodeNr];
    }

    public String getStringValue() {
        return ((Object)this.tree.attValue[this.nodeNr]).toString();
    }

    public int getFingerprint() {
        return this.tree.attCode[this.nodeNr] & 0xFFFFF;
    }

    public int getNameCode() {
        return this.tree.attCode[this.nodeNr];
    }

    public String getPrefix() {
        int n = this.tree.attCode[this.nodeNr];
        if ((n >> 20 & 0xFF) == 0) {
            return "";
        }
        return this.tree.getNamePool().getPrefix(n);
    }

    public String getDisplayName() {
        return this.tree.getNamePool().getDisplayName(this.tree.attCode[this.nodeNr]);
    }

    public String getLocalPart() {
        return this.tree.getNamePool().getLocalName(this.tree.attCode[this.nodeNr]);
    }

    public final String getURI() {
        return this.tree.getNamePool().getURI(this.tree.attCode[this.nodeNr]);
    }

    public int getTypeAnnotation() {
        return this.tree.getAttributeAnnotation(this.nodeNr);
    }

    public void generateId(FastStringBuffer fastStringBuffer) {
        this.getParent().generateId(fastStringBuffer);
        fastStringBuffer.append("a");
        fastStringBuffer.append(Integer.toString(this.tree.attCode[this.nodeNr]));
    }

    public void copy(Receiver receiver, int n, boolean bl, int n2) throws XPathException {
        int n4 = this.tree.attCode[this.nodeNr];
        int n5 = bl ? this.getTypeAnnotation() : -1;
        receiver.attribute(n4, n5, this.getStringValue(), n2, 0);
    }

    public int getLineNumber() {
        return this.getParent().getLineNumber();
    }
}

