/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.event;

import java.util.Arrays;
import java.util.Properties;
import net.sf.saxon.event.HTMLTagHashSet;
import net.sf.saxon.event.ProxyReceiver;
import net.sf.saxon.tinytree.CharSlice;
import net.sf.saxon.trans.XPathException;

public class HTMLIndenter
extends ProxyReceiver {
    private int level = 0;
    private int indentSpaces = 3;
    private char[] indentChars = new char[]{'\n', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' '};
    private boolean sameLine = false;
    private boolean isInlineTag = false;
    private boolean inFormattedTag = false;
    private boolean afterInline = false;
    private boolean afterFormatted = true;
    private int[] propertyStack = new int[20];
    protected static String[] inlineTags;
    private static HTMLTagHashSet inlineTable;
    protected static final int IS_INLINE = 1;
    protected static final int IS_FORMATTED = 2;
    private static HTMLTagHashSet formattedTable;
    protected static String[] formattedTags;

    protected int classifyTag(int n) {
        int n2 = 0;
        String string = this.getNamePool().getDisplayName(n);
        if (inlineTable.contains(string)) {
            n2 |= 1;
        }
        if (formattedTable.contains(string)) {
            n2 |= 2;
        }
        return n2;
    }

    public void setOutputProperties(Properties properties) {
        String string = properties.getProperty("{http://saxon.sf.net/}indent-spaces");
        if (string == null) {
            this.indentSpaces = 3;
        } else {
            try {
                this.indentSpaces = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                this.indentSpaces = 3;
            }
        }
    }

    public void startElement(int n, int n2, int n4, int n5) throws XPathException {
        int n6 = this.classifyTag(n);
        if (this.level >= this.propertyStack.length) {
            int[] nArray = new int[this.level * 2];
            System.arraycopy(this.propertyStack, 0, nArray, 0, this.propertyStack.length);
            this.propertyStack = nArray;
        }
        this.propertyStack[this.level] = n6;
        this.isInlineTag = (n6 & 1) != 0;
        boolean bl = this.inFormattedTag = this.inFormattedTag || (n6 & 2) != 0;
        if (!(this.isInlineTag || this.inFormattedTag || this.afterInline || this.afterFormatted)) {
            this.indent();
        }
        super.startElement(n, n2, n4, n5);
        ++this.level;
        this.sameLine = true;
        this.afterInline = false;
        this.afterFormatted = false;
    }

    public void endElement() throws XPathException {
        boolean bl;
        --this.level;
        boolean bl2 = (this.propertyStack[this.level] & 1) != 0;
        boolean bl3 = bl = (this.propertyStack[this.level] & 2) != 0;
        if (!(bl2 || bl || this.afterInline || this.sameLine || this.afterFormatted || this.inFormattedTag)) {
            this.indent();
            this.afterInline = false;
            this.afterFormatted = false;
        } else {
            this.afterInline = bl2;
            this.afterFormatted = bl;
        }
        super.endElement();
        this.inFormattedTag = this.inFormattedTag && !bl;
        this.sameLine = false;
    }

    public void characters(CharSequence charSequence, int n, int n2) throws XPathException {
        if (this.inFormattedTag || (n2 & 0x100) != 0) {
            super.characters(charSequence, n, n2);
        } else {
            int n4 = 0;
            for (int i = 0; i < charSequence.length(); ++i) {
                if (charSequence.charAt(i) != '\n' && (i - n4 <= 120 || charSequence.charAt(i) != ' ')) continue;
                this.sameLine = false;
                super.characters(charSequence.subSequence(n4, i), n, n2);
                this.indent();
                for (n4 = i + 1; n4 < charSequence.length() && charSequence.charAt(n4) == ' '; ++n4) {
                }
            }
            if (n4 < charSequence.length()) {
                super.characters(charSequence.subSequence(n4, charSequence.length()), n, n2);
            }
        }
        this.afterInline = false;
    }

    public void comment(CharSequence charSequence, int n, int n2) throws XPathException {
        this.indent();
        super.comment(charSequence, n, n2);
    }

    private void indent() throws XPathException {
        int n = this.level * this.indentSpaces;
        if (n + 1 >= this.indentChars.length) {
            int n2 = Math.min(n + 1 - this.indentChars.length, 5 * this.indentSpaces);
            char[] cArray = new char[this.indentChars.length + n2];
            System.arraycopy(this.indentChars, 0, cArray, 0, this.indentChars.length);
            Arrays.fill(cArray, this.indentChars.length, cArray.length, ' ');
            this.indentChars = cArray;
        }
        super.characters(new CharSlice(this.indentChars, 0, n + 1), 0, 0);
        this.sameLine = false;
    }

    static {
        int n;
        inlineTags = new String[]{"tt", "i", "b", "u", "s", "strike", "big", "small", "em", "strong", "dfn", "code", "samp", "kbd", "var", "cite", "abbr", "acronym", "a", "img", "applet", "object", "font", "basefont", "br", "script", "map", "q", "sub", "sup", "span", "bdo", "iframe", "input", "select", "textarea", "label", "button", "ins", "del"};
        inlineTable = new HTMLTagHashSet(101);
        for (n = 0; n < inlineTags.length; ++n) {
            inlineTable.add(inlineTags[n]);
        }
        formattedTable = new HTMLTagHashSet(23);
        formattedTags = new String[]{"pre", "script", "style", "textarea", "xmp"};
        for (n = 0; n < formattedTags.length; ++n) {
            formattedTable.add(formattedTags[n]);
        }
    }
}

