/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.util;

import com.hp.hpl.jena.util.FileManager;
import com.hp.hpl.jena.util.FileUtils;
import com.hp.hpl.jena.util.Locator;
import com.hp.hpl.jena.util.TypedStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.AccessControlException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LocatorFile
implements Locator {
    static Log log = LogFactory.getLog(LocatorFile.class);
    private String altDir = null;
    private String altDirLogStr = "";

    public LocatorFile(String dir) {
        if (dir != null) {
            if (dir.endsWith("/") || dir.endsWith(File.separator)) {
                dir = dir.substring(0, dir.length() - 1);
            }
            this.altDirLogStr = " [" + dir + "]";
        }
        this.altDir = dir;
    }

    LocatorFile() {
        this(null);
    }

    public boolean equals(Object other) {
        return other instanceof LocatorFile && this.equals(this.altDir, ((LocatorFile)other).altDir);
    }

    private boolean equals(String a, String b) {
        return a == null ? b == null : a.equals(b);
    }

    public int hashCode() {
        return this.altDir.hashCode();
    }

    private File toFile(String filenameOrURI) {
        String fn = FileUtils.toFilename(filenameOrURI);
        if (fn == null) {
            return null;
        }
        if (this.altDir != null && !fn.startsWith("/") && !fn.startsWith(FileManager.filePathSeparator)) {
            fn = this.altDir + File.separator + fn;
        }
        return new File(fn);
    }

    public boolean exists(String filenameOrURI) {
        File f = this.toFile(filenameOrURI);
        if (f == null) {
            return false;
        }
        return f.exists();
    }

    public TypedStream open(String filenameOrURI) {
        File f = this.toFile(filenameOrURI);
        try {
            if (f == null || !f.exists()) {
                if (FileManager.logAllLookups && log.isTraceEnabled()) {
                    log.trace("Not found: " + filenameOrURI + this.altDirLogStr);
                }
                return null;
            }
        }
        catch (AccessControlException e2) {
            log.warn("Security problem testing for file", e2);
            return null;
        }
        try {
            FileInputStream in = new FileInputStream(f);
            if (in == null) {
                if (FileManager.logAllLookups && log.isTraceEnabled()) {
                    log.trace("LocatorFile: Failed to open: " + filenameOrURI + this.altDirLogStr);
                }
                return null;
            }
            if (FileManager.logAllLookups && log.isTraceEnabled()) {
                log.trace("Found: " + filenameOrURI + this.altDirLogStr);
            }
            return new TypedStream(in);
        }
        catch (IOException ioEx) {
            log.warn("File unreadable (but exists): " + f.getPath() + " Exception: " + ioEx.getMessage());
            return null;
        }
    }

    public String getName() {
        String tmp = "LocatorFile";
        if (this.altDir != null) {
            tmp = tmp + "(" + this.altDir + ")";
        }
        return tmp;
    }
}

